///////////////////////////
// Common stuff

uniform sampler2D BorderSampler;
uniform vec4   Color;
uniform float  Width;
uniform float  PixelSize;

vec4 CalcColor(float d, float t)
{
	vec2 borderTc = vec2(t, 1.0 + d/Width);
	vec4 tex = texture2D(BorderSampler, borderTc) * Color * vec4(2, 2, 2, 1);
	vec4 InsideColor = Color;
	
	d = -d; // Invert, so that d is the depth into the body
	
	if (d < Width*0.5) // Outside-fade
		return vec4(tex.rgb, tex.a * smoothstep(-PixelSize, PixelSize, d));
	else // Inside fade
		return mix(tex, InsideColor, smoothstep(-PixelSize, PixelSize, d-Width));
}

//////////////////////////

uniform float Circumference;
uniform float Radius;

void main()
{
	vec2 tc = gl_TexCoord[0].st * 2.0 - 1.0;
	tc *= Radius;
	float dist = length(tc) - Radius;
	float t = atan(tc.y, tc.x) / 3.14159; // In [-1, +1]
	t = (1.0-t)/2.0; // [0, +1]
	gl_FragColor = CalcColor(dist, t);
	
	//if (t < 1.0/16.0)
	//	gl_FragColor.rgb *= 0.0;
}
