/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TrainFrame
extends JFrame
implements ActionListener {
    Vector trainPanels = new Vector();

    public TrainFrame() {
        super("Train");
        this.setDefaultCloseOperation(0);
        this.setSize(400, 300);
        this.setLocation(420, 200);
        this.setVisible(true);
        JPanel o = new JPanel(new BorderLayout());
        this.setContentPane(o);
        JPanel p = new JPanel(new GridLayout(4, 6));
        o.add("Center", p);
        JPanel q = new JPanel(new GridLayout(1, 3));
        o.add("South", q);
        JButton clear = new JButton("Clear");
        clear.setActionCommand("clear");
        JButton learn = new JButton("Learn");
        learn.setActionCommand("learn");
        JButton save = new JButton("Save");
        save.setActionCommand("save");
        clear.addActionListener(this);
        learn.addActionListener(this);
        save.addActionListener(this);
        q.add(clear);
        q.add(learn);
        q.add(save);
        this.trainPanels.addElement(new TrainPanel('0'));
        this.trainPanels.addElement(new TrainPanel('1'));
        this.trainPanels.addElement(new TrainPanel('2'));
        this.trainPanels.addElement(new TrainPanel('3'));
        this.trainPanels.addElement(new TrainPanel('4'));
        this.trainPanels.addElement(new TrainPanel('5'));
        this.trainPanels.addElement(new TrainPanel('6'));
        this.trainPanels.addElement(new TrainPanel('7'));
        this.trainPanels.addElement(new TrainPanel('8'));
        this.trainPanels.addElement(new TrainPanel('9'));
        this.trainPanels.addElement(new TrainPanel('+'));
        this.trainPanels.addElement(new TrainPanel('-'));
        this.trainPanels.addElement(new TrainPanel('*'));
        this.trainPanels.addElement(new TrainPanel('/'));
        this.trainPanels.addElement(new TrainPanel('R'));
        this.trainPanels.addElement(new TrainPanel('='));
        this.trainPanels.addElement(new TrainPanel('('));
        this.trainPanels.addElement(new TrainPanel(')'));
        this.trainPanels.addElement(new TrainPanel('!'));
        this.trainPanels.addElement(new TrainPanel('?'));
        this.trainPanels.addElement(new TrainPanel('#'));
        this.trainPanels.addElement(new TrainPanel('e'));
        this.trainPanels.addElement(new TrainPanel('P'));
        this.trainPanels.addElement(new TrainPanel('i'));
        for (int i = 0; i < this.trainPanels.size(); ++i) {
            p.add((TrainPanel)this.trainPanels.elementAt(i));
        }
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!"clear".equals(e.getActionCommand())) break block5;
                        for (int i = 0; i < this.trainPanels.size(); ++i) {
                            ((TrainPanel)this.trainPanels.elementAt(i)).clear();
                        }
                        break block6;
                    }
                    if (!"learn".equals(e.getActionCommand())) break block7;
                    for (int i = 0; i < this.trainPanels.size(); ++i) {
                        TrainPanel p = (TrainPanel)this.trainPanels.elementAt(i);
                        RCSymbol sym = p.finish();
                        if (sym != null) {
                            RCSymbolRecogniser.symbolRecogniser().addSymbol(sym);
                        }
                        p.clear();
                    }
                    break block6;
                }
                if (!"save".equals(e.getActionCommand())) break block8;
                RCSymbolRecogniser.symbolRecogniser().saveUnipenFile("symbols.unipen");
                break block6;
            }
            if (!"reset".equals(e.getActionCommand())) break block6;
            RCSymbolRecogniser.symbolRecogniser().reset();
            try {
                RCSymbolRecogniser.symbolRecogniser().openUnipenFile(new URL(RCApplet.baseURL, "symbols.unipen"), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class TrainPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        RCStroke stroke;
        RCSymbol symbol;
        char symbolChar;

        public TrainPanel(char c) {
            this.symbolChar = c;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            char[] cArray = new char[]{this.symbolChar};
            g.drawString(new String(cArray), 20, 20);
            if (this.symbol != null) {
                this.symbol.draw((Graphics2D)g);
            }
            if (this.stroke != null) {
                this.stroke.draw((Graphics2D)g);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.symbol == null) {
                this.symbol = new RCSymbol(this.symbolChar);
            }
            this.stroke = new RCStroke(null, new RCPoint(e.getX(), e.getY()), '?');
        }

        public void mouseReleased(MouseEvent e) {
            this.stroke.addPoint(new RCPoint(e.getX(), e.getY()));
            this.symbol.addStroke(this.stroke);
            this.stroke = null;
            this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            this.stroke.addPoint(new RCPoint(e.getX(), e.getY()));
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        RCSymbol finish() {
            if (this.symbol != null) {
                this.symbol.normalise();
            }
            return this.symbol;
        }

        void clear() {
            this.stroke = null;
            this.symbol = null;
            this.repaint();
        }
    }
}

