/*
 * Decompiled with CFR 0.152.
 */
public class Rational {
    double d;
    double n;
    double v;

    Rational(float v) {
        this.v = v;
        this.n = v;
        this.d = 1.0;
        this.rationalise();
    }

    float numerator() {
        return (float)this.n;
    }

    float denominator() {
        return (float)this.d;
    }

    private boolean approx(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    private void rationalise() {
        double bestqn;
        double bestpn;
        boolean reciprocal;
        int b = 1;
        if (this.approx(this.v, 0.0)) {
            this.n = this.v;
            this.d = 1.0;
            return;
        }
        boolean sign = this.v < 0.0;
        if (sign) {
            this.v = -this.v;
        }
        if (reciprocal = this.v < 1.0) {
            this.v = 1.0 / this.v;
        }
        if (this.approx(this.v, 0.0)) {
            bestpn = 0.0;
            bestqn = 1.0;
        } else {
            int e;
            double m = this.v;
            for (e = 0; m < 1.0E10 && e < 20; m *= 2.0, ++e) {
            }
            if (e < 10) {
                bestpn = this.v;
                bestqn = 1.0;
            } else {
                double error;
                int a1;
                int a = (int)m;
                b = 1 << e;
                int r1 = a % b;
                int pn = a1 = a / b;
                bestpn = pn;
                int qn = 1;
                bestqn = 1;
                int pn1 = 1;
                int qn1 = 0;
                double besterror = error = Math.abs((double)((float)pn / (float)qn) - this.v);
                while (r1 != 0 && !this.approx(error, 0.0)) {
                    a = b;
                    b = r1;
                    r1 = a % b;
                    a1 = a / b;
                    pn1 = pn;
                    int pn2 = pn1;
                    qn1 = qn;
                    int qn2 = qn1;
                    error = Math.abs((double)(pn = a1 * pn1 + pn2) / (double)(qn = a1 * qn1 + qn2) - this.v);
                    if (!(error < besterror)) continue;
                    besterror = error;
                    bestpn = pn;
                    bestqn = qn;
                }
            }
        }
        if (this.approx(bestpn, bestpn / this.v)) {
            bestqn = 1.0;
            bestpn = 1.0;
        }
        if (reciprocal) {
            this.d = bestpn;
            bestpn = bestqn;
        } else {
            this.d = bestqn;
        }
        if (sign) {
            bestpn = -bestpn;
        }
        this.n = bestpn;
    }
}

