/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;

public class RCSyntaxOperator
extends RCGraphObject
implements Comparable {
    boolean rtol = true;
    int priority = 100;
    int syntaxPriority = 0;
    int bracketCount;
    RCSymbol gSymbol;

    public RCSyntaxOperator(RCSymbol s) {
        super(s.graph());
        this.replace(s);
        this.gSymbol = s;
        this.unionWithRect(s);
        if (s.graph() != null) {
            s.graph().removeObject(s);
        }
        this.computer = true;
    }

    public RCSyntaxOperator(RCGraph g) {
        super(g);
        this.computer = true;
    }

    public String stringValue() {
        if (this.gSymbol != null) {
            return "" + this.gSymbol.symbol;
        }
        return "?";
    }

    public int priority() {
        return this.priority;
    }

    public void check() {
    }

    public void syntaxParse() {
    }

    public void implicitParse() {
    }

    public void parse() {
    }

    public int compareTo(Object o) {
        RCSyntaxOperator r = (RCSyntaxOperator)o;
        if (this.priority() != r.priority()) {
            return this.priority() - r.priority();
        }
        if (this.rtol) {
            return r.gSymbol.xcentre() > this.gSymbol.xcentre() ? 1 : -1;
        }
        return r.gSymbol.xcentre() > this.gSymbol.xcentre() ? -1 : 1;
    }

    public float fontHeight() {
        if (this.gSymbol != null) {
            return this.gSymbol.morphRect.h;
        }
        return 1.0f;
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        this.fh = this.morphRect.h = fhin;
        this.morphRect.w = this.idealRatio(g) * fhin;
        if (this.gSymbol != null) {
            this.gSymbol.setFontHeight(fhin, g);
        }
    }

    public float idealRatio(Graphics2D g) {
        return this.gSymbol.idealRatio(g);
    }

    public void calculateSize() {
        if (this.gSymbol == null) {
            return;
        }
        this.morphRect.w = this.gSymbol.morphWidth();
        this.morphRect.h = this.gSymbol.morphHeight();
    }

    public void calculatePosition() {
        if (this.gSymbol == null) {
            return;
        }
        this.x = this.gSymbol.x();
        this.y = this.gSymbol.y();
        this.gSymbol.morphToPosition(this.x, this.y);
    }

    public void draw(Graphics2D g) {
    }

    public String toString() {
        return "Op: " + this.stringValue() + "\\n(" + this.value() + ")";
    }

    public String dotID() {
        return "n" + this.hashCode();
    }

    public String dotNode() {
        return this.dotID() + " [label=\"" + this.toString() + "\" color=" + (this.gSymbol == null || this.gSymbol.computer ? "red" : "black") + "];\n";
    }

    public String toDot() {
        return this.dotNode();
    }
}

