/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class RCSymbolRecogniser {
    Vector symbols = new Vector();
    int maxStrokes = 0;
    File theFile;
    FileOutputStream outStream;
    FileInputStream inStream;
    ObjectOutput objOut;
    ObjectInput objIn;
    String fileName = "./realSave";
    static RCSymbolRecogniser recogniser = new RCSymbolRecogniser();

    public static RCSymbolRecogniser symbolRecogniser() {
        return recogniser;
    }

    private RCSymbolRecogniser() {
    }

    public RCSymbolRecogniser(String fName) {
        this.fileName = fName;
    }

    public void close() {
        this.theFile = new File(this.fileName);
        try {
            this.outStream = new FileOutputStream(this.theFile);
            this.objOut = new ObjectOutputStream(this.outStream);
            this.objOut.writeObject(this.symbols);
            this.objOut.close();
        }
        catch (Exception e) {
            System.err.println("File read not going as planned.");
            e.printStackTrace();
        }
    }

    public void open() {
        this.theFile = new File("./realSave");
        try {
            this.inStream = new FileInputStream(this.theFile);
            this.objIn = new ObjectInputStream(this.inStream);
            this.symbols = (Vector)this.objIn.readObject();
            this.objIn.close();
        }
        catch (Exception e) {
            System.err.println("Open not going as planned.");
            e.printStackTrace();
        }
        for (int i = 0; i < this.symbols.size(); ++i) {
            int ns = ((RCSymbol)this.symbols.elementAt(i)).numStrokes();
            if (ns <= this.maxStrokes) continue;
            this.maxStrokes = ns;
        }
    }

    void save() {
        this.close();
    }

    public void reset() {
        this.symbols.removeAllElements();
    }

    public void saveUnipenFile(String fn) {
        File theFile = new File(fn);
        try {
            FileOutputStream outStream = new FileOutputStream(theFile);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(outStream));
            for (int i = 0; i < this.symbols.size(); ++i) {
                RCSymbol symbol = (RCSymbol)this.symbols.elementAt(i);
                w.write(".SEGMENT DIGIT " + i + " ? ");
                w.write("\"" + symbol.symbol + "\"\n");
                for (int j = 0; j < symbol.strokes.size(); ++j) {
                    w.write(".PEN_DOWN\n");
                    RCStroke stroke = (RCStroke)symbol.strokes.elementAt(j);
                    for (int k = 0; k < stroke.data.size(); ++k) {
                        RCPoint point = (RCPoint)stroke.data.elementAt(k);
                        w.write(" " + point.x() + "\t" + point.y() + "\n");
                    }
                    w.write(".PEN_UP\n");
                }
                w.write("\n\n");
            }
            ((Writer)w).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void openUnipenFile(URL fn, boolean invertY) {
        int ymultipler = invertY ? -1 : 1;
        try {
            URLConnection conn = fn.openConnection();
            conn.connect();
            BufferedReader r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            st.wordChars(65, 122);
            st.wordChars(48, 57);
            st.wordChars(63, 63);
            st.wordChars(46, 46);
            st.wordChars(45, 45);
            st.quoteChar(34);
            st.whitespaceChars(32, 32);
            st.whitespaceChars(9, 9);
            st.eolIsSignificant(false);
            while (st.ttype != -1) {
                if (st.sval == null || st.sval.compareTo(".SEGMENT") != 0) {
                    st.nextToken();
                }
                if (st.ttype != -1) {
                    String tok;
                    if (st.ttype != -3 || (tok = st.sval).compareTo(".SEGMENT") != 0) continue;
                    String digit = "?";
                    for (int i = 0; i < 4; ++i) {
                        st.nextToken();
                    }
                    digit = st.sval;
                    RCSymbol symbol = new RCSymbol(digit.charAt(0));
                    while (st.ttype != -1) {
                        st.nextToken();
                        if (st.ttype == -1) break;
                        if (st.ttype != -3) continue;
                        if (st.sval.compareTo(".PEN_DOWN") == 0) {
                            RCStroke stroke = null;
                            while (st.ttype != -1) {
                                st.nextToken();
                                if (st.ttype == 10) {
                                    st.nextToken();
                                }
                                if (st.sval.compareTo(".PEN_UP") == 0) break;
                                String x = st.sval;
                                st.nextToken();
                                String y = st.sval;
                                if (stroke == null) {
                                    stroke = new RCStroke(null, new RCPoint(Float.valueOf(x).floatValue(), (float)ymultipler * Float.valueOf(y).floatValue()), '?');
                                } else {
                                    stroke.addPoint(new RCPoint(Float.valueOf(x).floatValue(), (float)ymultipler * Float.valueOf(y).floatValue()));
                                }
                                digit = st.sval;
                            }
                            symbol.addStroke(stroke);
                        }
                        if (st.sval.compareTo(".SEGMENT") != 0) continue;
                    }
                    symbol.normalise();
                    if (symbol.strokes.size() >= 4) continue;
                    char type = symbol.symbol;
                    float distance = this.whatIs(symbol);
                    if (type == symbol.symbol && !(distance > 10000.0f)) continue;
                    symbol.symbol = type;
                    this.addSymbol(symbol);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    int count() {
        return this.symbols.size();
    }

    int maxStrokes() {
        return this.maxStrokes;
    }

    void addSymbol(RCSymbol sym) {
        if (sym != null) {
            if (sym.numStrokes() > this.maxStrokes) {
                this.maxStrokes = sym.numStrokes();
            }
            this.symbols.addElement(sym);
        }
    }

    float whatIs(RCSymbol s) {
        RCSymbol b;
        float minDistance = Float.MAX_VALUE;
        char best = '~';
        if (s.width() < 10.0f && s.height() < 10.0f) {
            s.setSymbol('.');
            return 0.0f;
        }
        for (int i = 0; i < this.symbols.size(); ++i) {
            float distance;
            RCSymbol t = (RCSymbol)this.symbols.elementAt(i);
            if (s.numStrokes() != t.numStrokes() || !RCPreferences.symbolIsValid(t.symbol()) || !((distance = s.distance(t) / (float)s.numStrokes()) < minDistance)) continue;
            minDistance = distance;
            best = t.symbol();
        }
        if (s.numStrokes() == 2 && best == '4') {
            RCSymbol a = new RCSymbol('?');
            a.addStroke((RCStroke)s.strokes.elementAt(0));
            b = new RCSymbol('?');
            b.addStroke((RCStroke)s.strokes.elementAt(1));
            this.whatIs(a);
            this.whatIs(b);
            if (a.symbol() == 'i' && b.symbol() == '1' || b.symbol() == 'i' && a.symbol() == '1') {
                minDistance = (float)((double)minDistance * 0.4);
            }
        } else if (s.numStrokes() == 2 && best == '+') {
            RCSymbol a = new RCSymbol('?');
            a.addStroke((RCStroke)s.strokes.elementAt(0));
            b = new RCSymbol('?');
            b.addStroke((RCStroke)s.strokes.elementAt(1));
            this.whatIs(a);
            this.whatIs(b);
            if (a.symbol() == '-' && b.symbol() == '1' || b.symbol() == '-' && a.symbol() == '1') {
                minDistance = (float)((double)minDistance * 0.4);
            }
        } else if (s.numStrokes() == 2 && best == '=') {
            RCSymbol a = new RCSymbol('?');
            a.addStroke((RCStroke)s.strokes.elementAt(0));
            b = new RCSymbol('?');
            b.addStroke((RCStroke)s.strokes.elementAt(1));
            this.whatIs(a);
            this.whatIs(b);
            if (a.symbol() == '-' && b.symbol() == '-') {
                minDistance = (float)((double)minDistance * 0.01);
            }
        }
        s.setSymbol(best);
        return minDistance;
    }
}

