/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Vector;

public class RCSymbol
extends RCGraphObject
implements Serializable {
    Vector strokes = new Vector();
    boolean recognised = false;

    public RCSymbol(char s) {
        super((RCGraph)null);
        this.symbol = s;
    }

    public RCSymbol(char s, RCGraph g) {
        super(g);
        this.symbol = s;
    }

    public RCSymbol(RCSymbol s) {
        super(s);
        this.recognised = s.recognised;
    }

    public RCGraphObject copy() {
        return new RCSymbol(this);
    }

    public char drawSymbol() {
        if (this.symbol == '*') {
            return '\u00d7';
        }
        if (this.symbol == 'P') {
            return '\u03c0';
        }
        if (this.symbol == '-') {
            return '\u2212';
        }
        return this.symbol;
    }

    public void setSymbol(char s) {
        this.symbol = s;
    }

    public int numStrokes() {
        return this.strokes.size();
    }

    public void addStroke(RCStroke s) {
        this.strokes.addElement(s);
        this.unionWithRect(s);
    }

    public float distance(RCSymbol template) {
        float scaleFactor = template.width() > template.height() ? template.width() / this.width() : template.height() / this.height();
        return this.distance(this.strokes, template.strokes, scaleFactor);
    }

    public float distance(Vector a, Vector b, float scaleFactor) {
        float minDistance = 0.0f;
        for (int i = 0; i < a.size(); ++i) {
            RCStroke s = (RCStroke)a.elementAt(i);
            RCStroke t = (RCStroke)b.elementAt(i);
            minDistance += s.distance(t, scaleFactor);
        }
        return minDistance;
    }

    public void normalise() {
        for (int i = 0; i < this.strokes.size(); ++i) {
            RCStroke s = (RCStroke)this.strokes.elementAt(i);
            s.normalise(this.xcentre(), this.ycentre());
        }
    }

    public RCPoint graphicalCentre() {
        if (this.symbol == 'R') {
            float neww = 0.15f * this.height();
            return new RCPoint(neww + this.x, this.ycentre());
        }
        if (this.symbol == '.') {
            return new RCPoint(this.xcentre(), this.height() * 0.9f + this.y);
        }
        return new RCPoint(this.xcentre(), this.ycentre());
    }

    public void draw(Graphics2D g) {
        this.setColor(g);
        if (!this.recognised && !this.computer) {
            this.drawUser(g);
        } else if (this.symbol == '-') {
            this.drawLine(g);
        } else if (this.symbol == 'R') {
            this.drawRoot(g);
        } else {
            this.drawTypeset(g);
        }
    }

    public void setColor(Graphics2D g) {
        if (this.computer) {
            g.setColor(new Color(1.0f, 0.4f, 0.4f, this.alpha));
        } else {
            if (this.selected) {
                this.alpha = 0.0f;
            }
            g.setColor(new Color(0.0f, 0.0f, 1.0f - this.alpha, 1.0f));
        }
    }

    public void drawUser(Graphics2D g) {
        for (int i = 0; i < this.strokes.size(); ++i) {
            ((RCStroke)this.strokes.elementAt(i)).draw(g);
        }
    }

    public void drawTypeset(Graphics2D g) {
        if (this.w == 0.0f || this.h == 0.0f) {
            return;
        }
        AffineTransform at = g.getTransform();
        AffineTransform oldt = g.getTransform();
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = this.drawSymbol() == 'i' ? new TextLayout("" + this.drawSymbol(), drawItalicFont, frc) : new TextLayout("" + this.drawSymbol(), drawFont, frc);
        LineMetrics metrics = drawFont.getLineMetrics("" + this.drawSymbol(), frc);
        Rectangle2D bounds = layout.getBounds();
        float lineheight = metrics.getHeight();
        float ascent = metrics.getAscent();
        float drawy = 0.0f;
        if (this.symbol == '(' || this.symbol == ')') {
            drawy = -metrics.getDescent() / 2.0f;
        }
        at.translate(this.x, this.y);
        at.scale(this.w / layout.getAdvance(), this.h / ascent);
        at.translate(0.0, drawy);
        g.setTransform(at);
        layout.draw(g, 0.0f, ascent);
        bounds = layout.getBounds();
        g.setTransform(oldt);
    }

    public void drawLine(Graphics2D g) {
        float hh = this.h * 0.3f;
        if (hh < 1.0f) {
            hh = 1.0f;
        }
        Rectangle gbounds = new Rectangle((int)this.x, (int)((double)this.y + (double)this.h * 0.35), (int)this.w, (int)hh);
        g.fill(gbounds);
    }

    public void drawRoot(Graphics2D g) {
        float oldw = this.width();
        GeneralPath gp = new GeneralPath();
        float neww = 0.3f * this.height();
        gp.moveTo(this.x + this.w, this.y);
        gp.lineTo(this.x + neww, this.y);
        gp.moveTo(this.x + neww / 2.0f, this.y + this.h);
        gp.lineTo(this.x + neww / 4.0f, this.y + this.h * 0.75f);
        gp.lineTo(this.x, this.y + this.h * 0.8f);
        g.setStroke(new BasicStroke(this.h * 0.05f));
        g.draw(gp);
        gp = new GeneralPath();
        gp.moveTo(this.x + neww, this.y);
        gp.lineTo(this.x + neww / 2.0f, this.y + this.h);
        g.setStroke(new BasicStroke(this.h * 0.03f));
        g.draw(gp);
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        this.morphRect.h = fhin;
        this.morphRect.w = this.idealRatio(g) * fhin;
    }

    public float idealRatio(Graphics2D g) {
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout("" + this.drawSymbol(), drawFont, frc);
        LineMetrics metrics = drawFont.getLineMetrics("" + this.drawSymbol(), frc);
        Rectangle2D bounds = layout.getBounds();
        float lineheight = metrics.getHeight();
        float ascent = metrics.getAscent();
        return layout.getAdvance() / ascent;
    }

    public void syntaxParse() {
        RCSyntaxOperator op = null;
        if (this.symbol() < '0' || this.symbol() > '9') {
            switch (this.symbol()) {
                case '-': {
                    if (!RCPreferences.useDivisor) break;
                    boolean divisor = false;
                    for (int i = 0; i < this.graph.graphObjects.size(); ++i) {
                        RCGraphObject o = (RCGraphObject)this.graph.graphObjects.elementAt(i);
                        if (o == this || !(o.xcentre() < this.xmax()) || !(o.xcentre() > this.x())) continue;
                        divisor = true;
                    }
                    if (!divisor) break;
                    op = new RCDivisorSyntax(this);
                    break;
                }
                case 'R': {
                    op = new RCRootSyntax(this);
                }
            }
        }
        if (op != null) {
            this.graph.addObject(op);
            ((RCSyntaxOperator)op).syntaxParse();
        }
    }
}

