/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Vector;

class RCStroke
extends RCGraphObject
implements Serializable {
    private transient Rectangle2D clipRectangle = new Rectangle2D.Float();
    private transient boolean clipIsEmpty = true;
    static int normalisedLength = 20;
    transient GeneralPath path = new GeneralPath(1);
    Vector data;
    Vector originalData;
    float length;
    public float avrX;
    public float avrY;
    public float lastX;
    public float lastY;
    boolean normalised;
    char strokeClass;
    boolean isLoop = false;
    private final transient float[] dashPattern = new float[]{8.0f};
    private final transient BasicStroke bstroke = new BasicStroke(6.0f);
    private final transient int PEN_WID = 2;

    public RCStroke(RCGraph g, RCPoint start, char sClass) {
        super(g);
        this.originalData = this.data = new Vector();
        this.data.addElement(start);
        this.calculatePath();
        this.lastX = start.x();
        this.lastY = start.y();
        this.x = start.x();
        this.y = start.y();
        this.h = 0.0f;
        this.w = 0.0f;
        this.avrY = 0.0f;
        this.avrX = 0.0f;
        this.normalised = false;
        this.strokeClass = sClass;
        this.length = 0.0f;
    }

    RCStroke(RCStroke s) {
        super(s);
        this.data = new Vector(s.data);
        this.originalData = new Vector(s.originalData);
        this.length = s.length;
        this.avrX = s.avrX;
        this.avrY = s.avrY;
        this.normalised = s.normalised;
        this.strokeClass = s.strokeClass;
        this.calculatePath();
    }

    public RCGraphObject copy() {
        return new RCStroke(this);
    }

    public void setClass(char theclass) {
        this.strokeClass = theclass;
    }

    public char strokeClass() {
        return this.strokeClass;
    }

    public boolean isErase() {
        if ((double)this.h < 0.2 * (double)this.w) {
            this.strokeClass = (char)100;
            return true;
        }
        return false;
    }

    public float distance(RCStroke template, float scaleFactor) {
        float distance = 0.0f;
        for (int i = 0; i < normalisedLength; ++i) {
            RCPoint me = (RCPoint)this.data.elementAt(i);
            RCPoint them = (RCPoint)template.data().elementAt(i);
            distance += me.distance(them, scaleFactor);
        }
        return distance;
    }

    public float distance(int i, int j, RCStroke template, float scaleFactor) {
        RCPoint me = (RCPoint)this.data.elementAt(i);
        RCPoint them = (RCPoint)template.data().elementAt(j);
        float theDistance = me.distance(them, scaleFactor);
        if (i == 1) {
            return theDistance;
        }
        return theDistance += this.distance(i - 1, j - 1, template, scaleFactor);
    }

    public void normalise(float newxcentre, float newycentre) {
        RCPoint point;
        int i;
        Vector<RCPoint> newdata = new Vector<RCPoint>(normalisedLength);
        if (!this.normalised) {
            for (i = 0; i < normalisedLength; ++i) {
                point = this.getPointAtPercentage((float)i / (float)(normalisedLength - 1));
                newdata.addElement(point);
            }
            this.originalData = this.data;
            this.data = newdata;
        }
        for (i = 0; i < normalisedLength; ++i) {
            point = (RCPoint)this.data.elementAt(i);
            this.data.setElementAt(new RCPoint(point.x() + this.avrX - newxcentre, point.y() + this.avrY - newycentre, point.curve()), i);
        }
        this.avrX = newxcentre;
        this.avrY = newycentre;
        this.normalised = true;
    }

    void curve() {
        RCPoint point = (RCPoint)this.data.elementAt(0);
        for (int i = 1; i < this.data.size(); ++i) {
            RCPoint oldPoint = point;
            point = (RCPoint)this.data.elementAt(i);
            float addLen = (float)Math.sqrt((point.x() - oldPoint.x()) * (point.x() - oldPoint.x()) + (point.y() - oldPoint.y()) * (point.y() - oldPoint.y()));
            float curvature = (float)Math.acos((point.x() - oldPoint.x()) / addLen);
            point.setCurve(curvature);
        }
    }

    RCPoint getPointAtPercentage(float per) {
        per = this.length * per;
        float curLen = 0.0f;
        RCPoint point = (RCPoint)this.data.elementAt(0);
        for (int i = 1; i < this.data.size(); ++i) {
            RCPoint oldPoint = point;
            point = (RCPoint)this.data.elementAt(i);
            float oldLen = curLen;
            float addLen = (float)Math.sqrt((point.x() - oldPoint.x()) * (point.x() - oldPoint.x()) + (point.y() - oldPoint.y()) * (point.y() - oldPoint.y()));
            if (!((curLen += addLen) > per)) continue;
            per = (per - oldLen) / addLen;
            float curvature = (float)Math.acos((point.x() - oldPoint.x()) / addLen);
            return new RCPoint(oldPoint.x() * (1.0f - per) + point.x() * per, oldPoint.y() * (1.0f - per) + point.y() * per, curvature);
        }
        return point;
    }

    public boolean addPoint(RCPoint p) {
        RCPoint old = (RCPoint)this.data.elementAt(this.data.size() - 1);
        this.lastX = p.x();
        this.lastY = p.y();
        float addLen = (float)Math.sqrt((p.x() - old.x()) * (p.x() - old.x()) + (p.y() - old.y()) * (p.y() - old.y()));
        if (addLen < 2.0f) {
            return false;
        }
        this.isLoop = this.intersectsSelf(old, p) || this.almostLoop(p);
        this.length += addLen;
        if (p.x() < this.x) {
            this.w += this.x - p.x();
            this.x = p.x();
        }
        if (p.x() > this.x + this.w) {
            this.w = p.x() - this.x;
        }
        if (p.y() < this.y) {
            this.h += this.y - p.y();
            this.y = p.y();
        }
        if (p.y() > this.y + this.h) {
            this.h = p.y() - this.y;
        }
        this.data.addElement(p);
        this.calculatePath();
        return true;
    }

    public Vector data() {
        return this.data;
    }

    public boolean pointInside(RCPoint point) {
        if (this.path == null) {
            this.calculatePath();
        }
        return this.path.contains(new Point2D.Double(point.x(), point.y()));
    }

    public boolean intersectsSelf(RCPoint a, RCPoint b) {
        if (this.data.size() < 2) {
            return false;
        }
        RCPoint c = (RCPoint)this.data.elementAt(0);
        for (int i = 1; i < this.data.size() - 5; ++i) {
            RCPoint d = (RCPoint)this.data.elementAt(i);
            if (Line2D.linesIntersect(a.x(), a.y(), b.x(), b.y(), c.x(), c.y(), d.x(), d.y())) {
                return true;
            }
            c = d;
        }
        return false;
    }

    public boolean almostLoop(RCPoint a) {
        if (this.data.size() < 2) {
            return false;
        }
        boolean close = false;
        for (int i = 0; i < this.data.size(); ++i) {
            float dy;
            RCPoint b = (RCPoint)this.data.elementAt(i);
            float dx = a.x() - b.x();
            if (Math.sqrt(dx * dx + (dy = a.y() - b.y()) * dy) < 20.0) {
                close = true;
                continue;
            }
            if (!close) continue;
            return true;
        }
        return false;
    }

    public void calculatePath() {
        float py;
        float px;
        if (this.data.size() <= 0) {
            return;
        }
        RCPoint point = (RCPoint)this.data.elementAt(0);
        if (this.normalised) {
            px = point.x() + this.avrX;
            py = point.y() + this.avrY;
        } else {
            px = point.x();
            py = point.y();
        }
        this.path.moveTo(px, py);
        if (this.clipIsEmpty) {
            this.clipRectangle.setRect(px, py, 0.0, 0.0);
            this.clipIsEmpty = false;
        } else {
            this.clipRectangle.add(px, py);
        }
        for (int i = 1; i < this.data.size(); ++i) {
            point = (RCPoint)this.data.elementAt(i);
            if (this.normalised) {
                px = point.x() + this.avrX;
                py = point.y() + this.avrY;
            } else {
                px = point.x();
                py = point.y();
            }
            this.clipRectangle.add(px, py);
            this.path.lineTo(px, py);
        }
    }

    public void draw(Graphics2D g) {
        Rectangle2D bounds;
        if (this.path == null) {
            this.calculatePath();
        }
        if ((bounds = this.path.getBounds2D()).getWidth() < 2.0 && bounds.getHeight() < 2.0) {
            Rectangle rbounds = new Rectangle((int)this.lastX - 4, (int)this.lastY - 4, 8, 8);
            g.setColor(Color.blue);
            g.fill(rbounds);
        } else {
            g.setColor(Color.blue);
            g.setStroke(this.bstroke);
            g.draw(this.path);
        }
        this.clipIsEmpty = true;
    }
}

