/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.net.URL;

class RCSelect
extends RCStroke
implements Serializable {
    GeneralPath path = new GeneralPath(1);
    RCPoint dragFrom;
    RCPoint dragTo;
    boolean dragging;
    boolean posting;
    RCNote draggingNote = null;
    static AudioClip sound = null;

    public RCSelect(RCStroke s, RCNote n) {
        super(s.subgraph, (RCPoint)s.data.firstElement(), s.strokeClass);
        this.data.addAll(s.data);
        this.calculatePath();
        this.draggingNote = n;
        if (sound == null) {
            try {
                sound = Applet.newAudioClip(new URL(RCApplet.baseURL, "select.wav"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sound.play();
        if (this.draggingNote != null) {
            this.dragFrom((RCPoint)s.data.firstElement());
        }
    }

    public void dragFrom(RCPoint p) {
        this.dragFrom = p;
        this.dragTo = p;
        this.dragging = true;
    }

    public void dragTo(RCPoint p) {
        this.dragTo = p;
    }

    public void draw(Graphics2D g) {
        float px = 0.0f;
        float py = 0.0f;
        for (int i = 0; i < this.data.size(); ++i) {
            RCPoint point = (RCPoint)this.data.elementAt(i);
            if (this.normalised) {
                px = point.x() + this.avrX;
                py = point.y() + this.avrY;
            } else {
                px = point.x();
                py = point.y();
            }
            if (i > 0) {
                this.path.lineTo(px, py);
                continue;
            }
            this.path.moveTo(px, py);
        }
        g.setStroke(new BasicStroke(4.0f));
        g.setColor(new Color(0.0f, 0.25f, 0.5f, 0.2f));
        g.fill(this.path);
        g.setColor(new Color(0.0f, 0.25f, 0.5f));
        g.draw(this.path);
        g.fillOval((int)px - 5, (int)py - 5, 10, 10);
        if (this.dragging) {
            RCSelect.drawArrow(g, this.dragFrom, this.dragTo);
        }
    }

    static void drawArrow(Graphics2D g, RCPoint dragFrom, RCPoint dragTo) {
        GeneralPath arrow = new GeneralPath(1);
        float dx = dragTo.x() - dragFrom.x();
        float dy = dragTo.y() - dragFrom.y();
        float arrowSize = 0.1f;
        float arrowSizeX = 0.04f;
        float arrowSizeMid = 0.06f;
        arrow.moveTo(dragFrom.x(), dragFrom.y());
        arrow.lineTo(dragTo.x(), dragTo.y());
        arrow.lineTo(dragTo.x() + dy * arrowSizeX - dx * arrowSize, dragTo.y() + -dx * arrowSizeX - dy * arrowSize);
        arrow.lineTo(dragTo.x() + -dx * arrowSizeMid, dragTo.y() + -dy * arrowSizeMid);
        arrow.lineTo(dragTo.x() + -dy * arrowSizeX - dx * arrowSize, dragTo.y() + dx * arrowSizeX - dy * arrowSize);
        arrow.lineTo(dragTo.x(), dragTo.y());
        g.fill(arrow);
        g.draw(arrow);
    }
}

