/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.util.Stack;
import java.util.Vector;

public class RCSegmenter
implements Runnable {
    Vector strokes = new Vector();
    RCSymbolRecogniser recogniser = RCSymbolRecogniser.symbolRecogniser();
    CalculatePanel panel;

    public RCSegmenter() {
    }

    public RCSegmenter(RCSymbolRecogniser r) {
        this.recogniser = r;
    }

    public void setRecogniser(RCSymbolRecogniser r) {
        this.recogniser = r;
    }

    public void clear() {
        this.strokes.removeAllElements();
    }

    public void deleteSelection(RCStroke s) {
        for (int i = 0; i < this.strokes.size(); ++i) {
            RCStroke go = (RCStroke)this.strokes.elementAt(i);
            if (!s.pointInside(new RCPoint(go.xcentre(), go.ycentre()))) continue;
            this.strokes.removeElement(go);
            --i;
        }
    }

    public void addStroke(RCStroke s) {
        this.strokes.addElement(s);
    }

    public int numberOfStrokes() {
        return this.strokes.size();
    }

    public synchronized void run() {
        this.panel.hasRecognisedSymbol(this.segment());
    }

    public RCSymbol segment() {
        Stack segmentation = new Stack();
        if (this.numberOfStrokes() == 0) {
            return null;
        }
        this.segment(0, 0, segmentation);
        int numStrokes = (Integer)segmentation.firstElement();
        RCSymbol sym = new RCSymbol('?');
        for (int i = 0; i < numStrokes; ++i) {
            sym.addStroke((RCStroke)this.strokes.elementAt(0));
            this.strokes.removeElementAt(0);
        }
        sym.normalise();
        this.recogniser.whatIs(sym);
        return sym;
    }

    public float segment(int symbolNumber, int index, Stack segmentation) {
        RCSymbol sym = new RCSymbol('?');
        float minCost = -1.0f;
        int segmentIndex = -1;
        segmentIndex = segmentation.size();
        segmentation.push(new Integer(-1));
        int i = 0;
        while (i + index < 2 * this.recogniser.maxStrokes() && i + index < this.strokes.size()) {
            sym.addStroke((RCStroke)this.strokes.elementAt(index + i));
            sym.normalise();
            float cost = this.recogniser.whatIs(sym) + this.segment(symbolNumber + 1, index + i + 1, segmentation);
            if (minCost == -1.0f || cost < minCost) {
                segmentation.setElementAt(new Integer(i + 1), segmentIndex);
                minCost = cost;
            }
            ++i;
        }
        return minCost;
    }

    public void draw(Graphics2D g) {
        for (int i = 0; i < this.strokes.size(); ++i) {
            ((RCStroke)this.strokes.elementAt(i)).draw(g);
        }
    }
}

