/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCRightBracket
extends RCOperator
implements Serializable {
    public RCOperator left;

    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCOperator newLeft = RCAdd.rparse(symbols, g);
        RCGraphObject next = symbols.peek();
        if (next.symbol == ')') {
            return new RCRightBracket((RCSymbol)symbols.poll(), newLeft);
        }
        RCSymbol rcs = new RCSymbol(')', g);
        rcs.computer = true;
        g.addObject(rcs);
        return new RCRightBracket(rcs, newLeft);
    }

    public void check() {
        if (this.left != null) {
            this.left.check();
        }
        this.unfixed = this.left != null ? this.left.unfixed : false;
    }

    public RCRightBracket(RCSymbol s, RCOperator l) {
        super(s);
        this.left = l;
        RCOperator.parent = this;
    }

    public RCNumber value() {
        if (this.left != null) {
            return this.left.value();
        }
        return RCNumber.one;
    }

    public void setValue(RCNumber v) {
        if (v != null && this.left != null) {
            this.left.setValue(v);
        }
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.gSymbol.setFontHeight(fhin, g);
        this.morphRect.h = fhin;
        this.morphRect.w = this.gSymbol.morphWidth();
        if (this.left != null) {
            this.left.setFontHeight(fhin, g);
            this.morphRect.w += this.left.morphWidth();
        }
    }

    public float fontHeight() {
        if (this.left != null) {
            return this.left.fontHeight();
        }
        return this.gSymbol.fontHeight();
    }

    public void calculateSize() {
        this.morphRect.w = this.gSymbol.morphWidth();
        this.morphRect.h = this.gSymbol.morphHeight();
        if (this.left != null) {
            this.left.calculateSize();
            this.morphRect.w += this.left.morphWidth();
            this.morphRect.h = Math.max(this.morphRect.h, this.left.morphHeight());
        }
        this.gSymbol.morphRect.h = this.morphRect.h;
    }

    public void calculatePosition() {
        if (this.left != null) {
            this.left.morphToPosition(this.morphRect.x, this.morphRect.y);
            this.left.calculatePosition();
        }
        this.gSymbol.morphToPosition(this.morphRect.x + this.left.morphWidth(), this.morphRect.y);
    }

    public String toLatex() {
        if (this.gSymbol.computer) {
            return this.left.toLatex() + " \\computer \\right) \\user ";
        }
        return this.left.toLatex() + " \\right) ";
    }

    public String toDot() {
        return this.dotNode() + this.left.toDot() + this.dotID() + " -> " + this.left.dotID() + "\n";
    }
}

