/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class RCRect
implements Serializable {
    float x;
    float y;
    float w;
    float h;

    RCRect() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.w = 0.0f;
        this.h = 0.0f;
    }

    RCRect(float xi, float yi, float wi, float hi) {
        this.x = xi;
        this.y = yi;
        this.w = wi;
        this.h = hi;
    }

    void setRect(float xi, float yi, float wi, float hi) {
        this.x = xi;
        this.y = yi;
        this.w = wi;
        this.h = hi;
    }

    void setRect(RCRect r) {
        this.x = r.x;
        this.y = r.y;
        this.w = r.w;
        this.h = r.h;
    }

    void unionWithRect(RCRect go) {
        if (this.w + this.h == 0.0f) {
            this.setRect(go);
            return;
        }
        if (go.x < this.x) {
            this.w += this.x - go.x;
            this.x = go.x;
        }
        if (go.y < this.y) {
            this.h += this.y - go.y;
            this.y = go.y;
        }
        if (go.xmax() > this.xmax()) {
            this.w = go.xmax() - this.x;
        }
        if (go.ymax() > this.ymax()) {
            this.h = go.ymax() - this.y;
        }
    }

    float x() {
        return this.x;
    }

    float y() {
        return this.y;
    }

    float xmax() {
        return this.x + this.w;
    }

    float ymax() {
        return this.y + this.h;
    }

    float xcentre() {
        return this.x + this.w / 2.0f;
    }

    float ycentre() {
        return this.y + this.h / 2.0f;
    }

    float width() {
        return this.w;
    }

    float height() {
        return this.h;
    }

    float fontHeight() {
        return Math.max(this.h, this.w);
    }

    void splitVertically(float xValue, RCRect a, RCRect b) {
        if (this.x() >= xValue && this.xmax() <= xValue) {
            return;
        }
        a.setRect(this.x, this.y, xValue - this.x, this.h);
        b.setRect(xValue, this.y, this.w - (xValue - this.x), this.h);
    }

    void splitHorizontally(float yValue, RCRect a, RCRect b) {
        if (this.y() >= yValue && this.ymax() <= yValue) {
            return;
        }
        a.setRect(this.x, this.y, this.w, yValue - this.y);
        b.setRect(this.x, yValue, this.w, this.h - (yValue - this.y));
    }

    boolean inRect(RCRect r) {
        return this.xcentre() > r.x() && this.xcentre() < r.xmax() && this.ycentre() > r.y() && this.ycentre() < r.ymax();
    }

    boolean containsPoint(RCPoint p) {
        return p.x() > this.x() && p.x() < this.xmax() && p.y() > this.y() && p.y() < this.ymax();
    }

    boolean bounds(float a, float b, float c) {
        return a < b && b < c;
    }

    boolean containsRect(RCRect r) {
        if (this.bounds(this.x(), r.xcentre(), this.xmax()) && this.bounds(this.y(), r.ycentre(), this.ymax())) {
            return true;
        }
        if (this.bounds(r.x(), this.xcentre(), r.xmax()) && this.bounds(r.y(), this.ycentre(), r.ymax())) {
            return true;
        }
        if (r.x() < this.x() && r.xmax() > this.xmax() && this.bounds(this.y(), r.y(), this.ymax()) && this.bounds(this.y(), r.ymax(), this.ymax())) {
            return true;
        }
        return r.y() < this.y() && r.ymax() > this.ymax() && this.bounds(this.x(), r.x(), this.xmax()) && this.bounds(this.x(), r.xmax(), this.xmax());
    }

    boolean intersectsRect(RCRect r) {
        if (this.containsPoint(new RCPoint(r.x, r.y))) {
            return true;
        }
        if (this.containsPoint(new RCPoint(r.x, r.ymax()))) {
            return true;
        }
        if (this.containsPoint(new RCPoint(r.xmax(), r.y))) {
            return true;
        }
        if (this.containsPoint(new RCPoint(r.xmax(), r.ymax()))) {
            return true;
        }
        return r.containsPoint(new RCPoint(this.xcentre(), this.ycentre()));
    }

    boolean aboveOfRect(RCRect r) {
        return this.y() > r.y() && (this.bounds(r.x(), this.xcentre(), r.xmax()) || this.bounds(this.x(), r.xcentre(), this.xmax()));
    }

    public String toString() {
        return "(" + Integer.toString((int)this.x) + ", " + Integer.toString((int)this.y) + ") , (" + Integer.toString((int)this.w) + ", " + Integer.toString((int)this.h) + ")";
    }
}

