/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class RCPoint
implements Serializable {
    private float x;
    private float y;
    private float curve;

    RCPoint(float inx, float iny) {
        this.x = inx;
        this.y = iny;
    }

    RCPoint(float inx, float iny, float incurve) {
        this.x = inx;
        this.y = iny;
        this.curve = incurve;
    }

    float distance(RCPoint test, float scaleFactor) {
        float dx = this.x * scaleFactor - test.x();
        float dy = this.y * scaleFactor - test.y();
        float dc = this.curve - test.curve();
        if (dc < 0.0f) {
            dc *= -1.0f;
        }
        if ((double)dc > 3.1415) {
            dc = 6.283f - dc;
        }
        return dx * dx + dy * dy + 1000.0f * dc * dc;
    }

    float x() {
        return this.x;
    }

    float y() {
        return this.y;
    }

    float curve() {
        return this.curve;
    }

    void setCurve(float c) {
        this.curve = c;
    }
}

