/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class RCOrganiser {
    Vector notes = new Vector();
    CalculatePanel calculatePanel;
    float size;
    boolean enabled = true;
    boolean clickInDock;
    boolean dragSize;
    RCNote clickInNote = null;
    float grabWidth = 16.0f;
    float cX;
    float cY;
    float minSize = 80.0f;
    float maxSize;
    float saveSize = this.maxSize = 200.0f;

    RCOrganiser(CalculatePanel cp, float s) {
        this.calculatePanel = cp;
        this.size = 0.0f;
    }

    public void setup(Graphics2D g2d) {
        this.notes.removeAllElements();
        this.addNote(this.calculatePanel.graph, g2d);
        try {
            String eq;
            URL u = new URL(RCApplet.baseURL, "startEquations.txt");
            URLConnection conn = u.openConnection();
            conn.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((eq = br.readLine()) != null) {
                this.addNote(eq, g2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resize(float s) {
        this.size = s;
        for (int i = 0; i < this.notes.size(); ++i) {
            ((RCNote)this.notes.elementAt((int)i)).intermediateImage = null;
            if (!(this.size > 10.0f)) continue;
            ((RCNote)this.notes.elementAt(i)).image();
        }
    }

    public void addNote(String math, Graphics2D g) {
        RCGraph graph = new RCGraph(null);
        graph.parseString(math);
        graph.parse();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = RCApplet.isApplet ? 800 : (int)dim.getWidth();
        int h = RCApplet.isApplet ? 600 : (int)dim.getHeight();
        Rectangle b = this.calculatePanel.getBounds();
        graph.setupMorph(new RCRect((float)b.x + this.maxSize, b.y, (float)b.width - this.maxSize, b.height), g);
        graph.morphToEnd();
        graph.keyframe();
        graph.tick(1);
        this.addNote(graph, g);
    }

    public void addNote(RCGraph graph, Graphics2D g) {
        int bottom = 150;
        for (int i = 0; i < this.notes.size(); ++i) {
            Rectangle r = ((RCNote)this.notes.elementAt((int)i)).sbounds;
            if (!(r.getY() + r.getHeight() > (double)bottom)) continue;
            bottom = (int)(r.getY() + r.getHeight());
        }
        this.addNote(graph, 0, bottom + 20);
    }

    public RCNote insideNote(int px, int py) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (!((RCNote)this.notes.elementAt(i)).inside(px, py)) continue;
            return (RCNote)this.notes.elementAt(i);
        }
        return null;
    }

    public RCNote addNote(RCGraph graph, int x, int y) {
        RCNote note = new RCNote(graph, x, y, this);
        this.notes.addElement(note);
        return note;
    }

    public void deleteNote(RCNote n) {
        this.notes.remove(n);
    }

    public void draw(Graphics2D g) {
        int i;
        if (!this.enabled) {
            return;
        }
        Rectangle r = this.calculatePanel.getBounds();
        Rectangle2D.Float rbounds = new Rectangle2D.Float(0.0f, 0.0f, this.size, (float)r.getHeight());
        g.setColor(new Color(0.9f, 0.9f, 0.9f));
        g.fill(rbounds);
        float boundsHeight = (float)r.getHeight();
        rbounds = new Rectangle2D.Float(this.size, 0.0f, this.grabWidth, boundsHeight);
        g.setColor(new Color(0.6f, 0.6f, 0.6f));
        g.fill(rbounds);
        float handleSize = boundsHeight / 20.0f;
        rbounds = new Rectangle2D.Float(this.size + this.grabWidth * 0.25f, (boundsHeight - handleSize) / 2.0f, this.grabWidth * 0.5f, handleSize);
        g.setColor(new Color(0.2f, 0.2f, 0.2f));
        g.fill(rbounds);
        float height = 0.0f;
        for (int i2 = 0; i2 < this.notes.size(); ++i2) {
            height = (float)((double)height + (((RCNote)this.notes.elementAt((int)i2)).sbounds.getHeight() + 15.0));
        }
        float ypos = (float)(r.getHeight() - (double)height) / 2.0f;
        for (i = 0; i < this.notes.size(); ++i) {
            ((RCNote)this.notes.elementAt(i)).setY(ypos);
            ypos = (float)((double)ypos + (((RCNote)this.notes.elementAt((int)i)).sbounds.getHeight() + 15.0));
        }
        if (this.size == 0.0f) {
            return;
        }
        for (i = 0; i < this.notes.size(); ++i) {
            ((RCNote)this.notes.elementAt(i)).draw(g);
        }
        if (this.clickInDock && this.clickInNote != null) {
            AlphaComposite myAlpha = AlphaComposite.getInstance(3, 0.8f);
            g.setComposite(myAlpha);
            this.clickInNote.image();
            g.drawImage(this.clickInNote.image(), (int)this.calculatePanel.lastMouse.x(), (int)this.calculatePanel.lastMouse.y(), null);
            myAlpha = AlphaComposite.getInstance(3, 1.0f);
            g.setComposite(myAlpha);
        }
    }

    boolean click(float clickX, float clickY) {
        if (!this.enabled) {
            return false;
        }
        this.cX = clickX;
        this.cY = clickY;
        this.dragSize = false;
        this.clickInDock = false;
        this.clickInNote = null;
        if (clickX < this.size) {
            this.clickInNote = this.insideNote((int)clickX, (int)clickY);
            if (this.clickInNote != null) {
                this.clickInNote.update();
                this.clickInDock = true;
            }
            return true;
        }
        if (clickX < this.size + this.grabWidth) {
            this.dragSize = true;
            return true;
        }
        return false;
    }

    boolean drag(float clickX, float clickY) {
        if (!this.enabled) {
            return false;
        }
        if (this.clickInDock) {
            this.calculatePanel.repaint();
            return true;
        }
        if (this.dragSize) {
            if (clickX < this.minSize / 2.0f) {
                clickX = 0.0f;
            } else if (clickX < this.minSize) {
                clickX = this.minSize;
            } else if (clickX > this.maxSize) {
                clickX = this.maxSize;
            }
            this.resize(clickX);
            this.calculatePanel.repaint();
            return true;
        }
        return false;
    }

    boolean release(float clickX, float clickY) {
        if (!this.enabled) {
            return false;
        }
        if (this.dragSize) {
            if (clickX == this.cX && clickY == this.cY) {
                if (clickX > this.minSize) {
                    clickX = 0.0f;
                    this.saveSize = this.size;
                } else {
                    clickX = this.saveSize;
                }
                this.resize(clickX);
                this.calculatePanel.repaint();
            }
            return true;
        }
        if (!this.clickInDock || this.clickInNote == null) {
            return false;
        }
        RCNote n = this.insideNote((int)clickX, (int)clickY);
        Rectangle r = this.calculatePanel.getBounds();
        if (n != null && n == this.clickInNote) {
            this.calculatePanel.graph = n.graph;
            this.calculatePanel.select = null;
        } else if (clickX > (float)((int)r.getWidth()) - this.calculatePanel.trashX && clickY > (float)((int)r.getHeight()) - this.calculatePanel.trashY && clickX < (float)((int)r.getWidth()) - this.calculatePanel.trashX + 64.0f && clickY < (float)((int)r.getHeight()) - this.calculatePanel.trashY + 64.0f) {
            this.deleteNote(this.clickInNote);
        } else if (clickX > this.size && this.clickInNote.graph != this.calculatePanel.graph) {
            RCNote rcn = new RCNote(this.clickInNote, this);
            RCGraphNote rcgn = new RCGraphNote(this.calculatePanel.graph, rcn);
            rcgn.x = rcgn.morphRect.x = clickX;
            rcgn.y = rcgn.morphRect.y = clickY;
            this.calculatePanel.graph.addObject(rcgn);
            this.calculatePanel.recogniseGraph();
        } else if (clickX <= this.size) {
            boolean added = false;
            this.notes.removeElement(this.clickInNote);
            for (int i = 0; i < this.notes.size(); ++i) {
                if (!(((RCNote)this.notes.elementAt((int)i)).y > clickY)) continue;
                this.notes.insertElementAt(this.clickInNote, i);
                added = true;
                break;
            }
            if (!added) {
                this.notes.addElement(this.clickInNote);
            }
        }
        this.calculatePanel.repaint();
        this.clickInNote = null;
        return true;
    }
}

