/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCOperator
extends RCGraphObject
implements Comparable,
Serializable {
    static boolean rtol = true;
    static float minFontHeight = 14.0f;
    RCSymbol gSymbol;
    static RCOperator parent = null;

    public RCOperator(RCSymbol s) {
        super(s.graph());
        this.replace(s);
        this.gSymbol = s;
        this.unionWithRect(s);
        if (s.graph() != null) {
            s.graph().removeObject(s);
        }
        this.computer = true;
    }

    public RCOperator(RCGraph g) {
        super(g);
        this.computer = true;
    }

    public RCOperator addBrackets() {
        RCSymbol lbs = new RCSymbol('(', this.graph);
        lbs.computer = true;
        this.graph.addObject(lbs);
        RCSymbol rbs = new RCSymbol(')', this.graph);
        rbs.computer = true;
        this.graph.addObject(rbs);
        RCLeftBracket rightBracket = new RCLeftBracket(rbs, this);
        RCLeftBracket leftBracket = new RCLeftBracket(lbs, rightBracket);
        return leftBracket;
    }

    public RCOperator addNegate() {
        RCSymbol rcs = new RCSymbol('-', this.graph);
        rcs.computer = true;
        this.graph.addObject(rcs);
        RCMinus minus = new RCMinus(rcs, null, this);
        minus.left = null;
        minus.check();
        minus.unfixed = true;
        return minus;
    }

    public RCOperator addAdd() {
        RCSymbol rcs = new RCSymbol('+', this.graph);
        rcs.computer = true;
        this.graph.addObject(rcs);
        RCUnknown u = new RCUnknown(this.graph);
        this.graph.addNGObject(u);
        RCAdd add = new RCAdd(rcs, this, (RCOperator)u);
        add.check();
        add.unfixed = true;
        return add;
    }

    public RCOperator addSubtract() {
        RCSymbol rcs = new RCSymbol('-', this.graph);
        rcs.computer = true;
        this.graph.addObject(rcs);
        RCUnknown u = new RCUnknown(this.graph);
        this.graph.addNGObject(u);
        RCMinus add = new RCMinus(rcs, this, (RCOperator)u);
        add.check();
        add.unfixed = true;
        return add;
    }

    public String stringValue() {
        if (this.gSymbol != null) {
            return "" + this.gSymbol.symbol;
        }
        return "?";
    }

    public void check() {
    }

    public float fontHeight() {
        if (this.gSymbol != null) {
            return this.gSymbol.morphRect.h;
        }
        return 1.0f;
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.fh = this.morphRect.h = fhin;
        this.morphRect.w = this.idealRatio(g) * fhin;
        if (this.gSymbol != null) {
            this.gSymbol.setFontHeight(fhin, g);
        }
    }

    public float idealRatio(Graphics2D g) {
        return this.gSymbol.idealRatio(g);
    }

    public void calculateSize() {
        if (this.gSymbol == null) {
            return;
        }
        this.morphRect.w = this.gSymbol.morphWidth();
        this.morphRect.h = this.gSymbol.morphHeight();
    }

    public void calculatePosition() {
        if (this.gSymbol == null) {
            return;
        }
        this.x = this.gSymbol.x();
        this.y = this.gSymbol.y();
        this.gSymbol.morphToPosition(this.x, this.y);
    }

    public void draw(Graphics2D g) {
    }

    public String toString() {
        return "Op: " + this.stringValue() + "\\n(" + this.value() + ")";
    }

    public String dotID() {
        return "n" + this.hashCode();
    }

    public String dotNode() {
        return this.dotID() + " [label=\"" + this.toString() + "\" color=" + (this.gSymbol == null || this.gSymbol.computer ? "red" : "black") + "];\n";
    }

    public String toLatex() {
        if (this.gSymbol.computer) {
            return " \\computer " + this.stringValue() + " \\user ";
        }
        return " " + this.stringValue() + " ";
    }

    public String toDot() {
        return this.dotNode();
    }
}

