/*
 * Decompiled with CFR 0.152.
 */
public class RCNumberOp {
    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCGraphObject next = symbols.peek();
        if ('0' <= next.symbol && next.symbol <= '9') {
            return RCDigit.rparse(symbols, g);
        }
        if (next.symbol == '\u00f7') {
            RCDivisorSyntax ds = (RCDivisorSyntax)symbols.poll();
            ds.parse();
            return new RCDivisor(ds);
        }
        if (next.symbol == '_') {
            RCBaseLineSyntax bl = (RCBaseLineSyntax)symbols.poll();
            bl.parse();
            return new RCBaseLine(bl);
        }
        if (next.symbol == 'C') {
            return (RCOperator)symbols.poll();
        }
        if (next.symbol == 'R') {
            RCRootSyntax rs = (RCRootSyntax)symbols.poll();
            rs.parse();
            return new RCRoot(rs);
        }
        if (next.symbol == 'n') {
            return new RCNoteOp((RCSymbol)symbols.poll());
        }
        if (next.symbol == 'e') {
            return new RCConstant((RCSymbol)symbols.poll(), RCNumber.numberFromDouble(Math.E, true));
        }
        if (next.symbol == 'i') {
            return new RCConstant((RCSymbol)symbols.poll(), RCNumber.i);
        }
        if (next.symbol == 'P') {
            return new RCConstant((RCSymbol)symbols.poll(), RCNumber.numberFromDouble(Math.PI, true));
        }
        RCUnknown u = new RCUnknown(g);
        g.addNGObject(u);
        return u;
    }
}

