/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.text.DecimalFormat;

public class RCNumber
implements Serializable {
    private double real;
    private double imag;
    static double PI = Math.acos(-1.0);
    boolean fixed = false;
    boolean known = true;
    public static RCNumber zero = new RCNumber(0.0);
    public static RCNumber NaN = new RCNumber(Double.NaN);
    public static RCNumber one = new RCNumber(1.0);
    public static RCNumber something = new RCNumber(0.0, 0.0, false, false);
    public static RCNumber i = new RCNumber(0.0, 1.0, true, true);
    private static final double TINY = 0.0;
    private static final int DP = 6;
    private static final double LSD = -16.0;
    static DecimalFormat nfA = new DecimalFormat("0.###");
    static DecimalFormat nfB = new DecimalFormat("0.###E0");

    private RCNumber() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    private RCNumber(double v) {
        this.real = v;
        this.imag = 0.0;
    }

    private RCNumber(double v, double c) {
        this.real = v;
        this.imag = c;
    }

    private RCNumber(double v, double c, boolean f, boolean k) {
        this.real = v;
        this.imag = c;
        this.fixed = f;
        this.known = k;
    }

    public double re() {
        return this.real;
    }

    public double im() {
        return this.imag;
    }

    public boolean isNaN() {
        return Double.isInfinite(this.real) || Double.isNaN(this.real) || Double.isInfinite(this.imag) || Double.isNaN(this.imag);
    }

    public String format(double n) {
        if (n > 0.0 ? n > 100000.0 || n < 0.001 && n > 1.0E-10 : n < -100000.0 || n > -0.001 && n < -1.0E-10) {
            return nfB.format(n);
        }
        String s = nfA.format(n);
        if (s.equals("-0")) {
            return "0";
        }
        return s;
    }

    public boolean willDisplayAsZero() {
        String s = this.toString();
        return s.equals("0") || s.equals("-0");
    }

    public String toStringNB() {
        if (this.isNaN()) {
            return "?";
        }
        if (this.imag * this.imag < 1.0E-4) {
            return "" + this.format(this.real);
        }
        if (this.real * this.real < 1.0E-4) {
            String s = this.format(this.imag);
            if (s.equals("1")) {
                return "i";
            }
            return "" + s + "i";
        }
        if (this.imag > 0.0) {
            return this.format(this.real) + "+" + this.format(this.imag) + "i";
        }
        return this.format(this.real) + "-" + this.format(-1.0 * this.imag) + "i";
    }

    public String toString() {
        if (this.isNaN()) {
            return "?";
        }
        if (this.imag * this.imag < 1.0E-4) {
            return "" + this.format(this.real);
        }
        if (this.real * this.real < 1.0E-4) {
            if (this.imag != 1.0) {
                return "" + this.format(this.imag) + "i";
            }
            return "i";
        }
        if (this.imag > 0.0) {
            return "(" + this.format(this.real) + "+" + this.format(this.imag) + "i)";
        }
        return "(" + this.format(this.real) + "-" + this.format(-1.0 * this.imag) + "i)";
    }

    public boolean isZero() {
        return this.real == 0.0 && this.imag == 0.0;
    }

    public boolean isOne() {
        return this.real == 1.0 && this.imag == 0.0;
    }

    public static RCNumber numberFromDoubles(double f, double c) {
        return new RCNumber(f, c);
    }

    public static RCNumber numberFromDouble(double f) {
        return new RCNumber(f);
    }

    public static RCNumber numberFromDouble(double f, boolean fixed) {
        return new RCNumber(f, 0.0, fixed, true);
    }

    public static RCNumber numberFromNumber(RCNumber n) {
        return new RCNumber(n.re(), n.im());
    }

    public static RCNumber numberFromNumber(RCNumber n, boolean fixed) {
        return new RCNumber(n.re(), n.im(), fixed, true);
    }

    public static RCNumber numberFromString(String s) {
        return new RCNumber(new Double(s), 0.0, true, true);
    }

    public static RCNumber decimalFromString(String s) {
        return new RCNumber(new Double("." + s), 0.0, true, true);
    }

    public static RCNumber conj(RCNumber z) {
        RCNumber retval = new RCNumber(z.real, -z.imag);
        return retval;
    }

    public static double abs(RCNumber z) {
        double retval = Math.sqrt(z.real * z.real + z.imag * z.imag);
        return retval;
    }

    public static double arg(RCNumber z) {
        double retval = Math.atan2(z.imag, z.real);
        return retval;
    }

    public static double norm(RCNumber z) {
        double retval = z.real * z.real + z.imag * z.imag;
        return retval;
    }

    public static RCNumber add(RCNumber y, RCNumber z) {
        RCNumber retval = new RCNumber(y.real + z.real, y.imag + z.imag);
        return retval;
    }

    public static RCNumber add(RCNumber z, double a) {
        RCNumber retval = new RCNumber(z.real + a, z.imag);
        return retval;
    }

    public static RCNumber add(double a, RCNumber z) {
        RCNumber retval = new RCNumber(z.real + a, z.imag);
        return retval;
    }

    public static RCNumber negate(RCNumber z) {
        RCNumber retval = new RCNumber(-z.real, -z.imag);
        return retval;
    }

    public static RCNumber subtract(RCNumber y, RCNumber z) {
        RCNumber retval = new RCNumber(y.real - z.real, y.imag - z.imag);
        return retval;
    }

    public static RCNumber multiply(RCNumber y, RCNumber z) {
        RCNumber retval = new RCNumber(y.real * z.real - y.imag * z.imag, y.real * z.imag + y.imag * z.real);
        return retval;
    }

    public static RCNumber multiply(RCNumber z, double a) {
        RCNumber retval = new RCNumber(z.real * a, z.imag * a);
        return retval;
    }

    public static RCNumber divide(RCNumber y, RCNumber z) {
        RCNumber top = new RCNumber();
        double bottom = RCNumber.norm(z);
        top = RCNumber.multiply(y, RCNumber.conj(z));
        RCNumber retval = RCNumber.divide(top, bottom);
        return retval;
    }

    public static RCNumber divide(RCNumber z, double a) {
        RCNumber retval = new RCNumber(z.real / a, z.imag / a);
        return retval;
    }

    public static RCNumber exp(RCNumber z) {
        RCNumber j = new RCNumber(0.0, 1.0);
        RCNumber d = new RCNumber();
        double a = Math.exp(z.real);
        double b = Math.cos(z.imag);
        RCNumber c = RCNumber.multiply(j, Math.sin(z.imag));
        d = RCNumber.add(b, c);
        RCNumber retval = RCNumber.multiply(d, a);
        return retval;
    }

    public static RCNumber power(RCNumber y, RCNumber z) {
        RCNumber retval = new RCNumber();
        retval = RCNumber.exp(RCNumber.multiply(z, RCNumber.log(y)));
        return retval;
    }

    public static RCNumber log(RCNumber z) {
        RCNumber j = new RCNumber(0.0, 1.0);
        RCNumber retval = new RCNumber();
        retval = z.real < 0.0 && z.imag == 0.0 ? RCNumber.add(Math.log(RCNumber.abs(z)), RCNumber.multiply(j, PI)) : RCNumber.add(Math.log(RCNumber.abs(z)), RCNumber.multiply(j, RCNumber.arg(z)));
        return retval;
    }

    public static RCNumber factorial(RCNumber a) {
        float f = 1.0f;
        float v = (int)a.real;
        do {
            f *= v;
        } while ((v -= 1.0f) > 0.0f);
        return RCNumber.numberFromDouble(f, a.fixed());
    }

    public static RCNumber decimal(RCNumber a, RCNumber b) {
        return RCNumber.numberFromDouble(a.real + b.real, a.fixed() || b.fixed());
    }

    public static RCNumber intpart(RCNumber a) {
        return RCNumber.numberFromDouble((float)Math.floor(a.real + 1.0E-8));
    }

    public static RCNumber decimalpart(RCNumber a) {
        return RCNumber.numberFromDouble(a.real - (double)((float)Math.floor(a.real + 1.0E-8)));
    }

    public static RCNumber root(RCNumber a) {
        return RCNumber.power(a, new RCNumber(0.5));
    }

    public static boolean isEqual(RCNumber a, RCNumber b) {
        return a.isEqual(b);
    }

    public boolean isEqual(RCNumber z) {
        return this.real == z.real && this.imag == z.imag;
    }

    public boolean isLessThan(RCNumber a) {
        return this.real < a.real;
    }

    public boolean known() {
        return this.known;
    }

    public boolean unknown() {
        return !this.known;
    }

    public boolean fixed() {
        return this.fixed;
    }

    public boolean unfixed() {
        return !this.fixed;
    }
}

