/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class RCNote {
    public RCGraph graph = new RCGraph(null);
    float x;
    float y;
    public Rectangle sbounds;
    Color myColor;
    RCOrganiser organiser;
    Image intermediateImage;
    boolean wasgraph = true;

    RCNote(RCNote note, RCOrganiser o) {
        this.x = note.x;
        this.y = note.y;
        this.graph = note.graph;
        this.organiser = o;
        this.calcBounds();
    }

    RCNote(RCGraph g, int x, int y, RCOrganiser o) {
        this.graph = g;
        this.x = x;
        this.y = y;
        this.organiser = o;
        this.calcBounds();
    }

    public void setY(float y) {
        this.y = y;
        this.calcBounds();
    }

    public void calcBounds() {
        if (this.graph.root() == null) {
            this.sbounds = new Rectangle(0, 0, 200, 100);
            return;
        }
        float xx = this.graph.root().morphRect.x;
        float yy = this.graph.root().morphRect.y;
        float w = this.graph.root().morphRect.w;
        float h = this.graph.root().morphRect.h;
        float max = Math.max(w, h);
        this.sbounds = new Rectangle((int)this.x, (int)this.y, (int)(this.organiser.size / max * w), (int)(this.organiser.size / max * h));
    }

    public boolean inside(int px, int py) {
        return this.sbounds.inside(px, py);
    }

    public void update() {
        if (this.wasgraph || this.organiser.calculatePanel.graph == this.graph) {
            this.intermediateImage = null;
        }
        this.wasgraph = false;
    }

    public Image image() {
        if (this.intermediateImage == null) {
            GraphicsConfiguration gc = this.organiser.calculatePanel.getGraphicsConfiguration();
            this.intermediateImage = gc.createCompatibleImage((int)this.organiser.size, (int)this.organiser.size, 2);
            Graphics2D gImg = (Graphics2D)this.intermediateImage.getGraphics();
            gImg.setComposite(AlphaComposite.Src);
            gImg.setColor(new Color(0, 0, 0, 0));
            gImg.fillRect(0, 0, (int)this.organiser.size, (int)this.organiser.size);
            this.draw2(gImg);
            gImg.dispose();
        }
        return this.intermediateImage;
    }

    public void draw(Graphics2D g) {
        this.update();
        g.drawImage(this.image(), (int)this.x, (int)this.y, null);
    }

    public void draw2(Graphics2D g) {
        float size = this.organiser.size - 10.0f;
        AffineTransform at = new AffineTransform();
        AffineTransform oldt = g.getTransform();
        float xx = this.graph.root().morphRect.x;
        float yy = this.graph.root().morphRect.y;
        float w = this.graph.root().morphRect.w;
        float h = this.graph.root().morphRect.h;
        float max = Math.max(w, h);
        this.sbounds = new Rectangle((int)this.x, (int)this.y, (int)(size / max * w), (int)(size / max * h));
        at.translate(5.0, 0.0);
        at.scale(size / max, size / max);
        at.translate(-xx, -yy);
        g.transform(at);
        Rectangle rbounds = new Rectangle((int)xx, (int)yy, (int)w, (int)h);
        g.setColor(Color.white);
        g.fill(rbounds);
        g.setColor(Color.black);
        g.draw(rbounds);
        g.setClip(rbounds);
        this.graph.draw(g);
        if (this.organiser.calculatePanel.graph == this.graph) {
            this.wasgraph = true;
            AlphaComposite myAlpha = AlphaComposite.getInstance(3, 0.5f);
            g.setComposite(myAlpha);
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.8f));
            g.fill(rbounds);
            myAlpha = AlphaComposite.getInstance(3, 1.0f);
            g.setComposite(myAlpha);
        }
        g.setTransform(oldt);
    }
}

