/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCMinus
extends RCBinaryOperator
implements Serializable {
    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCOperator left = RCTimes.rparse(symbols, g);
        if (symbols.peek().symbol == '-') {
            return new RCMinus(symbols.poll(), left, RCMinus.rparse(symbols, g));
        }
        return left;
    }

    public RCMinus(RCGraphObject s, RCOperator l, RCOperator r) {
        super(s, l, r);
    }

    public RCNumber value() {
        RCNode n = new RCNode(null, this.left == null ? null : this.left.value(), this.right.value());
        if (this.left == null) {
            n.negateUp();
        } else {
            n.subtractUp();
        }
        return n.value();
    }

    public void setValue(RCNumber v) {
        if (v == null) {
            return;
        }
        if (this.left == null) {
            RCNode n = new RCNode(v, null, this.right.value());
            n.negateDown();
            this.right.setValue(n.right());
        } else {
            RCNode n = new RCNode(v, this.left.value(), this.right.value());
            n.subtractDown();
            this.left.setValue(n.left());
            this.right.setValue(n.right());
        }
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.fh = fhin;
        this.gSymbol.setFontHeight(0.2f * fhin, g);
        this.morphRect.h = fhin;
        this.gSymbol.morphRect.w = fhin * 0.6f;
        this.morphRect.w = fhin * 0.8f;
        if (this.left != null) {
            this.left.setFontHeight(fhin, g);
            this.morphRect.w += this.left.morphWidth();
        }
        if (this.right != null) {
            this.right.setFontHeight(fhin, g);
            this.morphRect.w += this.right.morphWidth();
        }
    }

    public void calculateSize() {
        super.calculateSize();
        this.morphRect.w += 0.2f * this.fh;
    }

    public void calculatePosition() {
        float xpos = this.morphRect.x;
        if (this.left != null) {
            this.left.morphToPosition(xpos, this.morphRect.y + this.morphBaseline() - this.left.morphBaseline());
            xpos += this.left.morphWidth();
        }
        if (this.gSymbol != null) {
            xpos = (float)((double)xpos + 0.1 * (double)this.fh);
            this.gSymbol.morphToPosition(xpos, this.morphRect.y + this.morphRect.h / 2.0f);
            xpos += this.gSymbol.morphWidth();
            xpos = (float)((double)xpos + 0.1 * (double)this.fh);
        }
        if (this.right != null) {
            this.right.morphToPosition(xpos, this.morphRect.y + this.morphBaseline() - this.right.morphBaseline());
        }
        if (this.left != null) {
            this.left.calculatePosition();
        }
        if (this.right != null) {
            this.right.calculatePosition();
        }
    }
}

