/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCLeftBracket
extends RCOperator
implements Serializable {
    public RCOperator right;
    static int inBrackets = 0;

    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCGraphObject next = symbols.peek();
        if (next.symbol == '(') {
            RCSymbol bracketSymbol = (RCSymbol)symbols.poll();
            ++inBrackets;
            RCOperator right = RCRightBracket.rparse(symbols, g);
            --inBrackets;
            return new RCLeftBracket(bracketSymbol, right);
        }
        RCOperator num = RCDecimal.rparse(symbols, g);
        if (symbols.peek().symbol == ')' && inBrackets == 0) {
            RCSymbol rcs = new RCSymbol('(', g);
            rcs.computer = true;
            g.addObject(rcs);
            return new RCLeftBracket(rcs, new RCRightBracket((RCSymbol)symbols.poll(), num));
        }
        return num;
    }

    public RCLeftBracket(RCSymbol s, RCOperator r) {
        super(s);
        this.right = r;
        RCOperator.parent = this;
    }

    public void check() {
        if (this.right != null) {
            this.right.check();
        }
        this.unfixed = this.right != null ? this.right.unfixed : false;
    }

    public RCNumber value() {
        if (this.right != null) {
            return this.right.value();
        }
        return RCNumber.one;
    }

    public void setValue(RCNumber v) {
        if (v != null && this.right != null) {
            this.right.setValue(v);
        }
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.gSymbol.setFontHeight(fhin, g);
        this.morphRect.h = fhin;
        this.morphRect.w = this.gSymbol.morphWidth();
        if (this.right != null) {
            this.right.setFontHeight(fhin, g);
            this.morphRect.w += this.right.morphWidth();
        }
    }

    public float fontHeight() {
        if (this.right != null) {
            return this.right.fontHeight();
        }
        return this.gSymbol.fontHeight();
    }

    public void calculateSize() {
        this.morphRect.w = this.gSymbol.morphWidth();
        this.morphRect.h = this.gSymbol.morphHeight();
        if (this.right != null) {
            this.right.calculateSize();
            this.morphRect.w += this.right.morphWidth();
            this.morphRect.h = Math.max(this.morphRect.h, this.right.morphHeight());
        }
        this.gSymbol.morphRect.h = this.morphRect.h;
    }

    public void calculatePosition() {
        this.gSymbol.morphToPosition(this.morphRect.x, this.morphRect.y);
        if (this.right != null) {
            this.right.morphToPosition(this.morphRect.x + this.gSymbol.morphWidth(), this.morphRect.y);
            this.right.calculatePosition();
        }
    }

    public String toLatex() {
        if (this.gSymbol.computer) {
            return " \\computer \\left( \\user " + this.right.toLatex();
        }
        return " \\left( " + this.right.toLatex();
    }

    public String toDot() {
        return this.dotNode() + this.right.toDot() + this.dotID() + " -> " + this.right.dotID() + "\n";
    }
}

