/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class RCGraphObject
extends RCRect
implements Serializable {
    transient float fh = 0.0f;
    Vector keyframes = new Vector();
    Date realDeathTime;
    transient float deathTime = -1.0f;
    transient float time = 0.0f;
    transient RCRect morphRect = new RCRect();
    transient boolean valid = true;
    transient RCGraph subgraph;
    transient RCGraph graph;
    public transient boolean computer = false;
    public transient boolean unfixed = false;
    public transient boolean selected = false;
    transient float alpha = 0.0f;
    char symbol;
    static Font drawFont = new Font("Times", 0, 500);
    static Font drawItalicFont = new Font("Times", 2, 500);

    RCGraphObject(RCGraph sg) {
        if (sg != null) {
            this.graph = sg.rootGraph();
        }
        this.subgraph = sg;
    }

    RCGraphObject(RCGraph g, RCGraph sg, float ix, float iy, float iw, float ih) {
        this.morphRect.x = this.x = ix;
        this.morphRect.y = this.y = iy;
        this.morphRect.w = this.w = iw;
        this.morphRect.h = this.h = ih;
        if (sg != null) {
            this.graph = sg.rootGraph();
        }
        this.subgraph = sg;
    }

    RCGraphObject(RCGraphObject go) {
        this.setRect(go);
        this.morphRect.setRect(go.morphRect);
        this.computer = go.computer;
        this.unfixed = go.unfixed;
        this.selected = go.selected;
        this.alpha = go.alpha;
        this.symbol = go.symbol;
    }

    public RCGraphObject copy() {
        return new RCGraphObject(this);
    }

    public char symbol() {
        return this.symbol;
    }

    public RCGraph subgraph() {
        return this.subgraph;
    }

    public RCGraph graph() {
        return this.graph;
    }

    public void setValue(RCNumber v) {
    }

    public RCNumber value() {
        return RCNumber.zero;
    }

    public RCNumber decimalValue() {
        return this.value();
    }

    public float baseline() {
        return this.height();
    }

    public float fontHeight() {
        return this.height();
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        this.fh = this.morphRect.h = fhin;
    }

    public void keyFrame(long clock) {
        this.keyframes.addElement(new RCGraphObjectKeyFrame(clock, this, this.morphRect, this.alpha));
    }

    public void dieRead() {
        this.realDeathTime = new Date();
    }

    public void die(long clock) {
        this.deathTime = clock;
        this.realDeathTime = new Date();
    }

    public void morphToPosition(float ix, float iy) {
        this.morphRect.x = ix;
        this.morphRect.y = iy;
    }

    public void morphToSize(float iw, float ih) {
        this.morphRect.w = iw;
        this.morphRect.h = ih;
    }

    public void morphTo(float d, RCRect a, RCRect b, float alphaA) {
        float ad = d / 30.0f;
        this.alpha = ad + alphaA * (1.0f - ad);
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
        }
        d *= 0.3f;
        if ((d = 1.0f - 1.0f / (1.0f + d * d)) > 1.0f || this.computer) {
            d = 1.0f;
        }
        this.x = b.x * d + a.x * (1.0f - d);
        this.y = b.y * d + a.y * (1.0f - d);
        this.w = b.w * d + a.w * (1.0f - d);
        this.h = b.h * d + a.h * (1.0f - d);
    }

    public void morphToEnd() {
        this.alpha = 1.0f;
        this.x = this.morphRect.x;
        this.y = this.morphRect.y;
        this.w = this.morphRect.w;
        this.h = this.morphRect.h;
    }

    public void morphToTime(float d) {
        this.time = d;
        if (this.deathTime > 0.0f && this.deathTime < d || this.keyframes.size() == 0) {
            this.w = 0.0f;
            this.h = 0.0f;
            return;
        }
        RCGraphObjectKeyFrame kf = (RCGraphObjectKeyFrame)this.keyframes.lastElement();
        if (d > (float)kf.time) {
            this.morphTo(d - (float)kf.time, kf.rect, kf.morphRect, kf.alpha);
        } else {
            try {
                int index = this.keyframes.size() - 1;
                while ((float)kf.time > d) {
                    kf = (RCGraphObjectKeyFrame)this.keyframes.elementAt(index--);
                }
                this.morphTo(d - (float)kf.time, kf.rect, kf.morphRect, kf.alpha);
            }
            catch (Exception e) {
                this.w = 0.0f;
                this.h = 0.0f;
            }
        }
    }

    public void timeTravel(float d) {
        this.morphToTime(d);
        try {
            int index = this.keyframes.size() - 1;
            RCGraphObjectKeyFrame kf = (RCGraphObjectKeyFrame)this.keyframes.elementAt(index);
            while ((float)kf.time > d) {
                this.keyframes.removeElementAt(index);
                kf = (RCGraphObjectKeyFrame)this.keyframes.elementAt(--index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.deathTime > d) {
            this.deathTime = -1.0f;
        }
    }

    public boolean valid() {
        return this.valid;
    }

    public void validate() {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void setSizeFrom(RCGraphObject go) {
        this.x = go.x;
        this.y = go.y;
        this.w = go.w;
        this.h = go.h;
    }

    public void calculateSize() {
        this.morphRect.x = this.x;
        this.morphRect.y = this.y;
    }

    public void calculatePositions() {
    }

    public void draw(Graphics2D g) {
    }

    float morphxcentre() {
        return this.morphRect.x + this.morphRect.w / 2.0f;
    }

    float morphBaseline() {
        return this.morphRect.h;
    }

    float morphycentre() {
        return this.morphRect.y + this.morphRect.h / 2.0f;
    }

    float morphxmax() {
        return this.morphRect.x + this.morphRect.w;
    }

    float morphymax() {
        return this.morphRect.y + this.morphRect.h;
    }

    float morphWidth() {
        return this.morphRect.w;
    }

    float morphHeight() {
        return this.morphRect.h;
    }

    void replace(RCGraphObject replace) {
        replace.valid = false;
        this.unionWithRect(replace);
    }

    public int compareTo(Object o) {
        RCGraphObject r = (RCGraphObject)o;
        return r.xcentre() > this.xcentre() ? -1 : 1;
    }
}

