/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class RCGraphNote
extends RCSymbol {
    float value;
    RCNote note;

    public RCGraphNote(RCGraph g, RCNote n) {
        super('n', g);
        this.note = n;
    }

    public RCGraphNote(RCGraphNote s) {
        super(s);
        this.note = s.note;
    }

    public RCGraphObject copy() {
        return new RCGraphNote(this);
    }

    public RCNumber value() {
        return this.note.graph.root().value();
    }

    public void setValue(float v) {
    }

    public float idealRatio(Graphics2D g) {
        return (float)this.note.sbounds.getWidth() / (float)this.note.sbounds.getHeight();
    }

    public void calculateSize() {
        this.morphRect.w = (float)this.note.sbounds.getWidth();
        this.morphRect.h = (float)this.note.sbounds.getHeight();
    }

    public void calculatePosition() {
        this.note.x = this.morphRect.x;
        this.note.y = this.morphRect.y;
    }

    public void draw(Graphics2D g) {
        this.note.draw(g);
        if (this.selected) {
            Rectangle gbounds = new Rectangle((int)this.morphRect.x, (int)this.morphRect.y, (int)this.morphRect.w, (int)this.morphRect.h);
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            g.fill(gbounds);
        }
    }

    public void morphToTime(float d) {
        super.morphToTime(d);
        this.calculatePosition();
    }

    public String toString() {
        return "note:" + this.value();
    }
}

