/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Vector;

public class RCGraph {
    public Vector allObjectsEver;
    Vector allObjectsEverEver;
    Vector allObjects;
    Vector graphObjects;
    RCOperator equation;
    RCGraph subgraph;
    float smallf = 1.0E-4f;
    long clock = 0L;
    long displayTime = 0L;
    RCRect morphBounds;
    RCRect deletedRect = new RCRect();

    RCGraph(RCGraph g) {
        this.subgraph = g;
        this.graphObjects = new Vector();
        this.allObjects = new Vector();
        this.allObjectsEver = new Vector();
        this.allObjectsEverEver = new Vector();
    }

    public void logToFile(String fn) {
        File theFile = new File(fn);
        try {
            FileOutputStream outStream = new FileOutputStream(theFile);
            ObjectOutputStream objoutStream = new ObjectOutputStream(outStream);
            Vector allForLog = (Vector)this.allObjectsEver.clone();
            for (int i = allForLog.size() - 1; i >= 0; --i) {
                RCGraphObject gobj = (RCGraphObject)allForLog.elementAt(i);
                if (!RCSyntaxOperator.class.isAssignableFrom(gobj.getClass())) continue;
                allForLog.removeElement(gobj);
            }
            objoutStream.writeObject(allForLog);
            objoutStream.writeLong(this.clock);
            objoutStream.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void openLogFile(String fn) {
        File theFile = new File(fn);
        try {
            FileInputStream inStream = new FileInputStream(theFile);
            ObjectInputStream objinStream = new ObjectInputStream(inStream);
            this.allObjectsEver = (Vector)objinStream.readObject();
            for (int i = this.allObjectsEver.size() - 1; i >= 0; --i) {
                RCGraphObject gobj = (RCGraphObject)this.allObjectsEver.elementAt(i);
                gobj.subgraph = this;
                gobj.graph = this;
            }
            long newclock = objinStream.readLong();
            this.timeTravel(newclock);
            objinStream.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.parse();
    }

    public RCGraph rootGraph() {
        if (this.subgraph != null) {
            return this.subgraph.rootGraph();
        }
        return this;
    }

    public void addObject(RCGraphObject obj) {
        if (obj.subgraph != null) {
            obj.subgraph.removeObject(obj);
        }
        obj.graph = this;
        obj.subgraph = this;
        if (!this.allObjects.contains(obj)) {
            this.graphObjects.addElement(obj);
        }
        this.addNGObject(obj);
    }

    public void addNGObject(RCGraphObject obj) {
        if (this.subgraph != null) {
            this.subgraph.addNGObject(obj);
        }
        if (!this.allObjects.contains(obj)) {
            this.allObjects.addElement(obj);
            this.allObjectsEver.addElement(obj);
            this.allObjectsEverEver.addElement(obj);
        }
    }

    public void removeObject(RCGraphObject obj) {
        this.graphObjects.removeElement(obj);
    }

    public void removeNGObject(RCGraphObject obj) {
        this.graphObjects.removeElement(obj);
        this.allObjects.removeElement(obj);
    }

    public void setupMorph(RCRect bounds, Graphics2D g) {
        this.deselectAll();
        this.morphBounds = bounds;
        if (this.allObjects.size() == 0 || this.equation == null) {
            return;
        }
        this.equation.setValue(this.equation.value());
        this.equation.setValue(this.equation.value());
        float fontHeight = this.equation.fontHeight();
        if (fontHeight < 200.0f) {
            fontHeight = 200.0f;
        }
        this.equation.setFontHeight(fontHeight, g);
        this.equation.calculateSize();
        float dw = bounds.width() * 0.7f / this.equation.morphWidth();
        float dh = bounds.height() * 0.7f / this.equation.morphHeight();
        if (dw < 1.0f && dw < dh) {
            this.equation.setFontHeight(fontHeight * dw, g);
        } else if (dh < 1.0f) {
            this.equation.setFontHeight(fontHeight * dh, g);
        }
        this.equation.calculateSize();
        this.equation.morphToPosition(bounds.xcentre() - this.equation.morphWidth() / 2.0f, bounds.ycentre() - this.equation.morphHeight() / 2.0f);
        this.equation.calculatePosition();
        this.keyframe();
    }

    public void keyframe() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject rco = (RCGraphObject)this.allObjects.elementAt(i);
            rco.keyFrame(this.clock);
        }
    }

    public void morph() {
        this.displayTime = this.clock;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            ((RCGraphObject)this.allObjects.elementAt(i)).morphToTime(this.clock);
        }
    }

    public void morphToTime(float m) {
        this.displayTime = (long)m;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            ((RCGraphObject)this.allObjects.elementAt(i)).morphToTime(m);
        }
    }

    public void morphAllToTime(float m) {
        this.displayTime = (long)m;
        for (int i = 0; i < this.allObjectsEver.size(); ++i) {
            ((RCGraphObject)this.allObjectsEver.elementAt(i)).morphToTime(m);
        }
    }

    public void timeTravel(float m) {
        int i;
        Vector<RCGraphObject> toRemove = new Vector<RCGraphObject>();
        this.graphObjects.removeAllElements();
        this.allObjects.removeAllElements();
        for (i = 0; i < this.allObjectsEver.size(); ++i) {
            RCGraphObject gobj = (RCGraphObject)this.allObjectsEver.elementAt(i);
            gobj.timeTravel(m);
            if (gobj.deathTime > 0.0f) continue;
            if (gobj.keyframes.size() <= 0 || (float)((RCGraphObjectKeyFrame)gobj.keyframes.firstElement()).time > m) {
                toRemove.addElement(gobj);
                continue;
            }
            this.graphObjects.addElement(gobj);
            this.allObjects.addElement(gobj);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            this.allObjectsEver.removeElement(toRemove.elementAt(i));
        }
        this.clock = (long)m;
    }

    public void tick() {
        ++this.clock;
    }

    public void tick(int add) {
        this.clock += (long)add;
    }

    public long clock() {
        return this.clock;
    }

    public void morphToEnd() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            ((RCGraphObject)this.allObjects.elementAt(i)).morphToEnd();
        }
    }

    public void clear() {
        this.allObjects.removeAllElements();
    }

    public int numberOfObjects() {
        return this.allObjects.size();
    }

    public RCOperator root() {
        return this.equation;
    }

    public RCNumber value() {
        return this.equation.value();
    }

    public void removeComputer() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject gobj = (RCGraphObject)this.allObjects.elementAt(i);
            if (!gobj.computer) continue;
            gobj.die(this.clock);
            this.allObjects.removeElement(gobj);
            --i;
        }
    }

    public void reset() {
        this.removeComputer();
        this.graphObjects = new Vector(this.allObjects);
        for (int j = 0; j < this.allObjects.size(); ++j) {
            RCGraphObject rco = (RCGraphObject)this.allObjects.elementAt(j);
            rco.subgraph = this;
            rco.graph = this;
        }
    }

    public void parseString(String expr) {
        this.clear();
        this.parseSubString(expr, 1, 10.0f, 800.0f, 300.0f);
        this.parse();
    }

    public void parseSubString(String expr, int depth, float x, float w, float y) {
        char[] symbols = expr.toCharArray();
        w /= (float)symbols.length;
        for (int i = 0; i < symbols.length; ++i) {
            int j;
            int bcount;
            if (symbols[i] == '{') {
                bcount = 0;
                for (j = i; j < symbols.length; ++j) {
                    if (symbols[j] == '{') {
                        ++bcount;
                    }
                    if (symbols[j] == '}') {
                        --bcount;
                    }
                    if (bcount == 0) break;
                }
                this.parseSubString(expr.substring(i + 1, j), depth + 1, x + (float)i * w, w, y - 100.0f / (float)depth);
                x -= w * (float)(j - i + 1);
                i = j;
                continue;
            }
            if (symbols[i] == '[') {
                bcount = 0;
                for (j = i; j < symbols.length; ++j) {
                    if (symbols[j] == '[') {
                        ++bcount;
                    }
                    if (symbols[j] == ']') {
                        --bcount;
                    }
                    if (bcount == 0) break;
                }
                this.parseSubString(expr.substring(i + 1, j), depth + 1, x + (float)i * w, w, y + 100.0f / (float)depth);
                x -= w * (float)(j - i + 1);
                i = j;
                continue;
            }
            if (symbols[i] == '}' || symbols[i] == ']') {
                x -= w;
                continue;
            }
            if (symbols[i] == ' ') continue;
            RCSymbol symbol = new RCSymbol(symbols[i]);
            symbol.setRect(x + (float)i * w, y, w, 10.0f);
            symbol.recognised = true;
            this.addObject(symbol);
        }
    }

    public void parse() {
        this.reset();
        if (this.graphObjects.size() == 0) {
            this.equation = new RCBlanker(new RCSymbol('?', this));
            this.addObject(this.equation);
            return;
        }
        this.syntacticParse();
        this.semanticParse();
        if (this.equation.getClass() == RCBaseLine.class) {
            this.removeObject(this.equation);
            this.equation = ((RCBaseLine)this.equation).above;
        }
        if (this.equation.getClass() != RCEquals.class) {
            RCSymbol rcs = new RCSymbol('=', this);
            rcs.computer = true;
            this.equation = new RCEquals(rcs, this.equation, null);
            this.addObject(rcs);
            this.addObject(this.equation);
        }
    }

    public void syntacticParse() {
        RCGraphObject rco;
        int j;
        if (this.graphObjects.size() == 0) {
            return;
        }
        Vector save = new Vector(this.graphObjects);
        Collections.sort(save, new SyntaxComparator());
        for (j = 0; j < save.size(); ++j) {
            rco = (RCGraphObject)save.elementAt(j);
            if (rco.subgraph != this || rco.getClass() != RCSymbol.class) continue;
            ((RCSymbol)rco).syntaxParse();
        }
        for (j = 0; j < this.graphObjects.size(); ++j) {
            rco = this.graphObjects.elementAt(j);
            if (rco.getClass() != RCSyntaxOperator.class) continue;
            ((RCSyntaxOperator)rco).syntaxParse();
        }
        if (RCPreferences.useExponentiation) {
            if (this.graphObjects.size() <= 1) {
                return;
            }
            Collections.sort(this.graphObjects, new ImplicitComparator());
            RCGraphObject first = (RCGraphObject)this.graphObjects.elementAt(0);
            RCBaseLineSyntax bline = new RCBaseLineSyntax(first.x(), 1000.0f, this);
            bline.addObject(first);
            this.baseLineParse(bline, first);
            this.addObject(bline);
        }
    }

    public void baseLineParse(RCBaseLineSyntax baseline, RCGraphObject lastrco) {
        if (this.graphObjects.size() == 0) {
            return;
        }
        Vector save = new Vector(this.graphObjects);
        Collections.sort(save, new ImplicitComparator());
        for (int j = 0; j < save.size(); ++j) {
            RCGraphObject rco = (RCGraphObject)save.elementAt(j);
            if (rco.subgraph == this && rco.xcentre() >= baseline.x()) {
                if (!RCBinaryOperator.class.isAssignableFrom(lastrco.getClass()) && (double)(rco.y() + rco.baseline()) <= (double)lastrco.y() + 0.25 * (double)lastrco.baseline()) {
                    RCBaseLineSyntax bl = new RCBaseLineSyntax(rco.xcentre() - this.smallf, lastrco.y() + lastrco.baseline() * 0.35f, baseline.graph);
                    bl.addObject(rco);
                    this.baseLineParse(bl, rco);
                    baseline.addObject(bl);
                } else {
                    if (rco.y() + rco.baseline() > baseline.ymax()) {
                        baseline.w = rco.xcentre() - this.smallf - baseline.x;
                        break;
                    }
                    baseline.addObject(rco);
                }
            }
            lastrco = rco;
        }
    }

    public void semanticParse() {
        if (this.graphObjects.size() == 0) {
            return;
        }
        for (int j = 0; j < this.graphObjects.size(); ++j) {
            RCGraphObject rCGraphObject = (RCGraphObject)this.graphObjects.elementAt(j);
        }
        Collections.sort(this.graphObjects, new ImplicitComparator());
        this.equation = RCEquals.rparse(new RCQueue(this.graphObjects), this);
    }

    public void draw(Graphics2D g) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            go.draw(g);
        }
    }

    public void drawAllEver(Graphics2D g) {
        for (int i = 0; i < this.allObjectsEver.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjectsEver.elementAt(i);
            if (!(go.w > 0.0f) || !(go.h > 0.0f)) continue;
            go.draw(g);
        }
    }

    public void deleteAll() {
        this.deletedRect.w = 0.0f;
        this.deletedRect.h = 0.0f;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            this.deletedRect.unionWithRect(go);
        }
        this.delete(this.deletedRect);
    }

    public void resetAll() {
        this.deletedRect.w = 0.0f;
        this.deletedRect.h = 0.0f;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            this.deletedRect.unionWithRect(go);
        }
        this.allObjects = new Vector();
        this.allObjectsEver = new Vector();
    }

    public void delete(RCRect r) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.inRect(r)) continue;
            go.die(this.clock);
            this.allObjects.removeElement(go);
            --i;
        }
    }

    public int selectionCount(RCStroke s) {
        int count = 0;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            if (this.allObjects.elementAt(i).getClass() != RCSymbol.class && this.allObjects.elementAt(i).getClass() != RCGraphNote.class) continue;
            RCSymbol go = (RCSymbol)this.allObjects.elementAt(i);
            if (s == null || !s.pointInside(go.graphicalCentre()) || go.computer) continue;
            ++count;
        }
        return count;
    }

    public void select(RCStroke s) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            if (this.allObjects.elementAt(i).getClass() != RCSymbol.class && this.allObjects.elementAt(i).getClass() != RCGraphNote.class) continue;
            RCSymbol go = (RCSymbol)this.allObjects.elementAt(i);
            if (s != null && s.pointInside(go.graphicalCentre())) {
                go.selected = true;
                continue;
            }
            go.selected = false;
            go.alpha = go.computer ? 0.1f : 1.0f;
        }
    }

    public void select(RCSymbol s) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            if (this.allObjects.elementAt(i).getClass() != RCSymbol.class && this.allObjects.elementAt(i).getClass() != RCGraphNote.class) continue;
            RCSymbol go = (RCSymbol)this.allObjects.elementAt(i);
            if (s != null && s.intersectsRect(go)) {
                go.selected = true;
                continue;
            }
            go.selected = false;
            go.alpha = go.computer ? 0.1f : 1.0f;
        }
    }

    public void selectAll() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            if (this.allObjects.elementAt(i).getClass() != RCSymbol.class && this.allObjects.elementAt(i).getClass() != RCGraphNote.class) continue;
            RCSymbol go = (RCSymbol)this.allObjects.elementAt(i);
            go.selected = true;
        }
    }

    public void deselectAll() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            if (this.allObjects.elementAt(i).getClass() != RCSymbol.class && this.allObjects.elementAt(i).getClass() != RCGraphNote.class) continue;
            RCSymbol go = (RCSymbol)this.allObjects.elementAt(i);
            go.selected = false;
        }
    }

    public void moveSelection(RCSelect s) {
        this.select(s);
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.selected) continue;
            go.morphRect.x = go.x();
            go.morphRect.y = go.y();
            go.morphRect.w = go.width();
            go.morphRect.h = go.height();
            go.x = s.dragTo.x() + go.x() / 1000.0f;
            go.y = s.dragTo.y() + go.y() / 1000.0f;
            go.w = go.width() / 1000.0f;
            go.h = go.height() / 1000.0f;
            go.selected = false;
        }
    }

    public void deleteSelection() {
        this.deletedRect.w = 0.0f;
        this.deletedRect.h = 0.0f;
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.selected) continue;
            this.deletedRect.unionWithRect(go);
            go.die(this.clock);
            this.allObjects.removeElement(go);
            --i;
        }
    }

    public RCGraph graphFromSelection() {
        RCGraph newgraph = new RCGraph(null);
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.selected) continue;
            newgraph.addObject(go.copy());
            go.selected = false;
            --i;
        }
        return newgraph;
    }

    public void resetSelection(RCSelect s) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.selected) continue;
            go.morphToEnd();
        }
    }

    public void hideComputers() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            RCGraphObject go = (RCGraphObject)this.allObjects.elementAt(i);
            if (!go.computer) continue;
            go.alpha = 0.1f;
        }
    }
}

