/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCExponent
extends RCBinaryOperator
implements Serializable {
    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCOperator left = RCFactorial.rparse(symbols, g);
        if (symbols.peek().symbol == '_') {
            return new RCExponent(g, left, RCNumberOp.rparse(symbols, g));
        }
        return left;
    }

    public RCExponent(RCGraph g, RCOperator l, RCOperator r) {
        super(g, l, r);
    }

    public RCNumber value() {
        RCNode n = new RCNode(null, this.left.value(), this.right.value());
        n.powerUp();
        return n.value();
    }

    public void setValue(RCNumber v) {
        if (v == null) {
            return;
        }
        RCNode n = new RCNode(v, this.left.value(), this.right.value());
        n.powerDown();
        this.left.setValue(n.left());
        this.right.setValue(n.right());
    }

    public float fontHeight() {
        return (float)((double)this.left.fontHeight() + 1.6666666666666667 * (double)this.right.fontHeight()) / 2.0f;
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        if (this.left != null) {
            this.left.setFontHeight(fhin, g);
        }
        if (this.right != null) {
            this.right.setFontHeight(0.6f * fhin, g);
        }
    }

    public float baseline() {
        return this.h - (this.left.height() - this.left.baseline());
    }

    public float morphBaseline() {
        return this.morphRect.h - (this.left.morphHeight() - this.left.morphBaseline());
    }

    public void calculateSize() {
        this.left.calculateSize();
        this.right.calculateSize();
        this.morphRect.w = this.left.morphWidth() + this.right.morphWidth();
        this.morphRect.h = this.left.morphHeight() * 0.8f + this.right.morphHeight();
    }

    public void calculatePosition() {
        this.left.morphToPosition(this.morphRect.x, this.morphRect.y + this.morphHeight() - this.left.morphHeight());
        this.right.morphToPosition(this.morphRect.x + this.left.morphWidth(), this.morphRect.y);
        this.left.calculatePosition();
        this.right.calculatePosition();
    }

    public String toString() {
        return "^\\n(" + this.value() + ")";
    }
}

