/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class RCEquals
extends RCBinaryOperator
implements Serializable {
    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCOperator left = RCAdd.rparse(symbols, g);
        if (symbols.peek().symbol == '=') {
            return new RCEquals(symbols.poll(), left, RCEquals.rparse(symbols, g));
        }
        return left;
    }

    public RCEquals(RCGraphObject s, RCOperator l, RCOperator r) {
        super(s, l, r);
    }

    public void check() {
        this.left.check();
        this.right.check();
        this.unfixed = this.left.unfixed && this.right.unfixed;
        this.setValue(this.value());
    }

    public RCNumber value() {
        RCNumber v1 = this.left.value();
        RCNumber v2 = this.right.value();
        RCNode n = new RCNode(null, v1, v2);
        n.equalsUp();
        RCNumber v = n.value();
        return v;
    }

    public void setValue(RCNumber v) {
        RCNumber v1 = this.left.value();
        RCNumber v2 = this.right.value();
        if (v == null) {
            this.left.setValue(v);
            this.right.setValue(v);
            return;
        }
        if (!(v1.unfixed() || RCNumber.isEqual(v1, v) || this.left.getClass() == RCEquals.class || RCNumber.subtract(v, v1).willDisplayAsZero())) {
            this.left = v1.re() > v.re() ? this.left.addSubtract() : this.left.addAdd();
        }
        if (!(v2.unfixed() || RCNumber.isEqual(v2, v) || this.right.getClass() == RCEquals.class || RCNumber.subtract(v, v2).willDisplayAsZero())) {
            this.right = v2.re() > v.re() ? this.right.addSubtract() : this.right.addAdd();
        }
        this.left.setValue(v);
        this.right.setValue(v);
    }
}

