/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCDivisor
extends RCOperator
implements Serializable {
    RCOperator above;
    RCOperator below;
    float opSize = 0.6f;

    public RCDivisor(RCDivisorSyntax s) {
        super(s.gSymbol);
        this.above = s.above.root();
        this.below = s.below.root();
    }

    public RCNumber value() {
        RCNode n = new RCNode(null, this.above.value(), this.below.value());
        n.divideUp();
        return n.value();
    }

    public void setValue(RCNumber v) {
        if (v == null) {
            return;
        }
        RCNode n = new RCNode(v, this.above.value(), this.below.value());
        n.divideDown();
        this.above.setValue(n.left());
        this.below.setValue(n.right());
    }

    public void check() {
        this.above.check();
        this.below.check();
        this.unfixed = this.above.unfixed || this.below.unfixed;
    }

    public float baseline() {
        return this.gSymbol.ycentre() - this.y();
    }

    public float morphBaseline() {
        return this.above.morphHeight() + this.gSymbol.morphRect.h * 5.0f / 2.0f;
    }

    float scaleFH(float fh) {
        return fh * this.opSize;
    }

    float descaleFH(float fh) {
        return this.opSize / fh;
    }

    public float fontHeight() {
        if (this.above != null && this.below != null) {
            return this.descaleFH((this.above.fontHeight() + this.below.fontHeight()) / 2.0f);
        }
        if (this.above != null) {
            return this.descaleFH(this.above.fontHeight());
        }
        if (this.below != null) {
            return this.descaleFH(this.below.fontHeight());
        }
        return this.gSymbol.fontHeight();
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        this.gSymbol.morphRect.h = fhin * 0.2f;
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        if (this.above != null) {
            this.above.setFontHeight(this.scaleFH(fhin), g);
        }
        if (this.below != null) {
            this.below.setFontHeight(this.scaleFH(fhin), g);
        }
    }

    public void calculateSize() {
        this.above.calculateSize();
        this.below.calculateSize();
        this.gSymbol.morphRect.w = this.morphRect.w = this.gSymbol.morphRect.h * 3.0f + Math.max(this.above.morphWidth(), this.below.morphWidth());
        this.morphRect.h = this.gSymbol.morphHeight() + this.above.morphHeight() + this.below.morphHeight();
    }

    public void calculatePosition() {
        this.above.morphToPosition(this.morphRect.x + (this.morphWidth() - this.above.morphWidth()) / 2.0f, this.morphRect.y);
        this.gSymbol.morphToPosition(this.morphRect.x, this.morphRect.y + this.above.morphHeight());
        this.below.morphToPosition(this.morphRect.x + (this.morphWidth() - this.below.morphWidth()) / 2.0f, this.morphRect.y + this.above.morphHeight() + this.gSymbol.morphHeight());
        this.above.calculatePosition();
        this.below.calculatePosition();
    }

    public String toLatex() {
        return "\\frac{" + this.above.toLatex() + "}{" + this.below.toLatex() + "}";
    }

    public String toDot() {
        return this.dotNode() + this.above.toDot() + this.below.toDot() + this.dotID() + " -> " + this.above.dotID() + "\n" + this.dotID() + " -> " + this.below.dotID() + "\n";
    }
}

