/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCDigit
extends RCOperator
implements Serializable {
    int digit;
    RCOperator right;

    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCGraphObject next = symbols.peek();
        if ('0' <= next.symbol && next.symbol <= '9') {
            return new RCDigit(symbols.poll(), next.symbol - 48, RCDigit.rparse(symbols, g));
        }
        return null;
    }

    public RCDigit(RCGraphObject s, int d, RCOperator r) {
        super((RCSymbol)s);
        this.digit = d;
        this.right = r;
    }

    public int digits() {
        if (this.right != null) {
            return 1 + ((RCDigit)this.right).digits();
        }
        return 1;
    }

    public RCNumber value() {
        return RCNumber.numberFromString(this.digitString());
    }

    public RCNumber decimalValue() {
        return RCNumber.decimalFromString(this.digitString());
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.gSymbol.setFontHeight(fhin, g);
        this.morphRect.w = this.gSymbol.morphWidth();
        if (this.right != null) {
            this.right.setFontHeight(fhin, g);
            this.morphRect.w += this.right.morphWidth();
        }
        this.morphRect.h = fhin;
    }

    public float fontHeight() {
        if (this.right != null) {
            return (this.gSymbol.height() + this.right.fontHeight()) / 2.0f;
        }
        return this.gSymbol.fontHeight();
    }

    public void calculateSize() {
        this.gSymbol.calculateSize();
        if (this.right != null) {
            this.right.calculateSize();
            this.morphRect.w = this.gSymbol.morphWidth() + this.right.morphWidth();
            this.morphRect.h = Math.max(this.gSymbol.morphHeight(), this.right.morphHeight());
        } else {
            this.morphRect.w = this.gSymbol.morphWidth();
            this.morphRect.h = this.gSymbol.morphHeight();
        }
    }

    public void calculatePosition() {
        if (this.right != null) {
            this.gSymbol.morphToPosition(this.morphRect.x, this.morphRect.y);
            this.right.morphToPosition(this.morphRect.x + this.gSymbol.morphWidth(), this.morphRect.y);
            this.right.calculatePosition();
        } else {
            this.gSymbol.morphToPosition(this.morphRect.x, this.morphRect.y);
        }
    }

    public String digitString() {
        return Integer.toString(this.digit) + (this.right != null ? ((RCDigit)this.right).digitString() : "");
    }

    public String toString() {
        return "Digit: " + Integer.toString(this.digit);
    }

    public String toLatex() {
        return "" + this.value();
    }

    public String toDot() {
        return this.dotID() + " [label=\"" + this.value() + "\"];\n";
    }
}

