/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class RCDecimal
extends RCBinaryOperator
implements Serializable {
    boolean fixed = false;

    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        RCOperator left = RCNumberOp.rparse(symbols, g);
        RCGraphObject next = symbols.peek();
        if ((left.getClass() == RCDigit.class || left.getClass() == RCUnknown.class) && next.symbol == '.') {
            return new RCDecimal(symbols.poll(), left, RCDigit.rparse(symbols, g));
        }
        return left;
    }

    public RCDecimal(RCGraphObject s, RCOperator l, RCOperator r) {
        super(s, l, r);
    }

    public void check() {
        if (this.fixed) {
            return;
        }
        boolean bl = this.unfixed = this.left.unfixed && this.right.unfixed;
        if (this.left.unfixed) {
            this.left.setValue(RCNumber.zero);
        } else if (this.right.unfixed) {
            this.right.setValue(RCNumber.zero);
        }
    }

    public RCNumber value() {
        RCNode n = new RCNode(null, this.left.value(), this.right.decimalValue());
        n.decimalUp();
        return RCNumber.numberFromNumber(n.value(), n.value().fixed || this.fixed);
    }

    public void setValue(RCNumber v) {
        if (v == null) {
            return;
        }
        this.fixed = true;
        RCNode n = new RCNode(v, this.left.value(), this.right.decimalValue());
        n.decimalDown();
        this.left.setValue(n.left());
        this.right.setValue(n.right());
        if (this.right.getClass() == RCUnknown.class) {
            ((RCUnknown)this.right).decimal();
        }
    }

    public String toString() {
        return ".";
    }

    public String toDot() {
        return this.dotID() + " [label=\"" + this.value() + "\"];\n";
    }
}

