/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.net.URL;
import javax.swing.ImageIcon;

public class RCClock {
    float clockSize = 130.0f;
    float clockSpeed = 0.029919906f;
    Image clockImage;
    CalculatePanel panel;
    float morphTime;
    float lastMouseX;
    float lastMouseY;

    public RCClock(CalculatePanel p) {
        this.panel = p;
        try {
            this.clockImage = new ImageIcon(new URL(RCApplet.baseURL, "clock.png")).getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void draw(Graphics2D g2d) {
        Rectangle bounds = this.panel.bounds();
        g2d.drawImage(this.clockImage, (int)(bounds.getWidth() - 10.0 - (double)this.clockSize), 10, (int)this.clockSize, (int)this.clockSize, this.panel);
        AffineTransform at = new AffineTransform();
        AffineTransform oldt = g2d.getTransform();
        at.translate((float)((int)bounds.getWidth() - 10) - this.clockSize / 2.0f, 10.0f + this.clockSize / 2.0f);
        g2d.transform(at);
        GeneralPath p = new GeneralPath(1);
        p.moveTo(0.0f, 0.0f);
        float angle = this.panel.reverseMorph ? this.morphTime : (float)this.panel.graph.clock;
        p.lineTo((float)Math.sin(angle *= this.clockSpeed) * 30.0f * this.clockSize / 64.0f, -((float)Math.cos(angle)) * 30.0f * this.clockSize / 64.0f);
        p.moveTo(0.0f, 0.0f);
        angle = (float)((double)angle / 12.56636);
        p.lineTo((float)Math.sin(angle) * 10.0f * this.clockSize / 64.0f, -((float)Math.cos(angle)) * 10.0f * this.clockSize / 64.0f);
        g2d.setColor(Color.blue);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(p);
        g2d.setTransform(oldt);
    }

    boolean click(float clickX, float clickY) {
        Rectangle bounds = this.panel.bounds();
        this.lastMouseX = clickX;
        this.lastMouseY = clickY;
        if ((double)clickX > bounds.getWidth() - 10.0 - (double)this.clockSize && clickY < this.clockSize + 10.0f) {
            if (!this.panel.reverseMorph) {
                this.morphTime = this.panel.graph.clock;
            }
            this.panel.reverseMorph = true;
            if (this.panel.recogniseTimer != null) {
                this.panel.recogniseTimer.stop();
            }
            if (this.panel.morphTimer != null) {
                this.panel.morphTimer.stop();
            }
            return true;
        }
        return false;
    }

    float angle(float x, float y) {
        Rectangle bounds = this.panel.bounds();
        float RX = x - ((float)((int)bounds.getWidth() - 10) - this.clockSize / 2.0f);
        float RY = y - (10.0f + this.clockSize / 2.0f);
        double H = Math.sqrt(RX * RX + RY * RY);
        float A = (float)Math.acos((double)RY / H);
        if (RX > 0.0f) {
            return A;
        }
        return -A;
    }

    void drag(float clickX, float clickY) {
        Rectangle bounds = this.panel.bounds();
        float diff = this.angle(this.lastMouseX, this.lastMouseY) - this.angle(clickX, clickY);
        if ((double)diff > 3.14159) {
            diff = 0.0f;
        } else if ((double)diff < -3.14159) {
            diff = 0.0f;
        }
        if (!Float.isNaN(diff /= this.clockSpeed)) {
            this.morphTime += diff;
        }
        if (this.morphTime < 0.0f) {
            this.morphTime = 0.0f;
        }
        if (this.morphTime > (float)this.panel.graph.clock) {
            this.morphTime = this.panel.graph.clock;
        }
        this.panel.graph.morphAllToTime(this.morphTime);
        this.panel.repaint();
        this.lastMouseX = clickX;
        this.lastMouseY = clickY;
    }
}

