/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.io.Serializable;

public class RCBinaryOperator
extends RCOperator
implements Serializable {
    RCOperator left;
    RCOperator right;
    float mBaseline;

    public static RCOperator rparse(RCQueue symbols, RCGraph g) {
        return null;
    }

    public RCBinaryOperator(RCGraphObject s, RCOperator l, RCOperator r) {
        super((RCSymbol)s);
        this.setChilds(l, r);
    }

    public RCBinaryOperator(RCGraph g, RCOperator l, RCOperator r) {
        super(g);
        this.setChilds(l, r);
    }

    public void setChilds(RCOperator l, RCOperator r) {
        if (l == null) {
            this.left = new RCUnknown(this.graph);
            this.graph.addNGObject(this.left);
        } else {
            this.left = l;
        }
        if (r == null) {
            this.right = new RCUnknown(this.graph);
            this.graph.addNGObject(this.right);
        } else {
            this.right = r;
        }
        RCOperator.parent = this;
        RCOperator.parent = this;
    }

    public void check() {
        if (this.left != null) {
            this.left.check();
        }
        if (this.right != null) {
            this.right.check();
        }
        this.unfixed = this.left != null && this.left.unfixed || this.right != null && this.right.unfixed;
    }

    public float fontHeight() {
        if (this.left != null && this.right != null) {
            return (this.gSymbol.fontHeight() + this.left.fontHeight() + this.right.fontHeight()) / 3.0f;
        }
        if (this.left != null) {
            return (this.gSymbol.fontHeight() + this.left.fontHeight()) / 2.0f;
        }
        if (this.right != null) {
            return (this.gSymbol.fontHeight() + this.right.fontHeight()) / 2.0f;
        }
        return this.gSymbol.fontHeight();
    }

    public void setFontHeight(float fhin, Graphics2D g) {
        if (fhin < minFontHeight) {
            fhin = minFontHeight;
        }
        this.gSymbol.setFontHeight(fhin, g);
        this.morphRect.h = fhin;
        this.morphRect.w = this.gSymbol.morphWidth();
        if (this.left != null) {
            this.left.setFontHeight(fhin, g);
            this.morphRect.w += this.left.morphWidth();
        }
        if (this.right != null) {
            this.right.setFontHeight(fhin, g);
            this.morphRect.w += this.right.morphWidth();
        }
    }

    public void calculateSize() {
        if (this.left != null) {
            this.left.calculateSize();
        }
        if (this.gSymbol != null) {
            this.gSymbol.calculateSize();
        }
        if (this.right != null) {
            this.right.calculateSize();
        }
        if (this.left != null && this.right != null) {
            this.morphRect.w = this.gSymbol.morphWidth() + this.left.morphWidth() + this.right.morphWidth();
            float min = Math.max(this.gSymbol.morphBaseline(), Math.max(this.left.morphBaseline(), this.right.morphBaseline()));
            float max = Math.max(this.gSymbol.morphHeight() - this.gSymbol.morphBaseline(), Math.max(this.left.morphHeight() - this.left.morphBaseline(), this.right.morphHeight() - this.right.morphBaseline()));
            this.morphRect.h = min + max;
            this.mBaseline = min;
        } else if (this.left != null) {
            this.morphRect.w = this.gSymbol.morphWidth() + this.left.morphWidth();
            float min = Math.max(this.gSymbol.morphBaseline(), this.left.morphBaseline());
            float max = Math.max(this.gSymbol.morphHeight() - this.gSymbol.morphBaseline(), this.left.morphHeight() - this.left.morphBaseline());
            this.morphRect.h = min + max;
            this.mBaseline = min;
        } else if (this.right != null) {
            this.morphRect.w = this.gSymbol.morphWidth() + this.right.morphWidth();
            float min = Math.max(this.gSymbol.morphBaseline(), this.right.morphBaseline());
            float max = Math.max(this.gSymbol.morphHeight() - this.gSymbol.morphBaseline(), this.right.morphHeight() - this.right.morphBaseline());
            this.morphRect.h = min + max;
            this.mBaseline = min;
        } else {
            this.morphRect.w = this.gSymbol.morphWidth();
            this.morphRect.h = this.gSymbol.morphHeight();
            this.mBaseline = this.gSymbol.morphBaseline();
        }
    }

    public float morphBaseline() {
        return this.mBaseline;
    }

    public void calculatePosition() {
        float xpos = this.morphRect.x;
        if (this.left != null) {
            this.left.morphToPosition(xpos, this.morphRect.y + this.morphBaseline() - this.left.morphBaseline());
            xpos += this.left.morphWidth();
        }
        if (this.gSymbol != null) {
            this.gSymbol.morphToPosition(xpos, this.morphRect.y + this.morphBaseline() - this.gSymbol.morphBaseline());
            xpos += this.gSymbol.morphWidth();
        }
        if (this.right != null) {
            this.right.morphToPosition(xpos, this.morphRect.y + this.morphBaseline() - this.right.morphBaseline());
        }
        if (this.left != null) {
            this.left.calculatePosition();
        }
        if (this.right != null) {
            this.right.calculatePosition();
        }
    }

    public String toString() {
        return this.gSymbol.symbol + "\\n(" + this.value() + ")";
    }

    public String toLatex() {
        if (this.gSymbol == null) {
            return "";
        }
        if (this.gSymbol.computer) {
            return (this.left == null ? "" : this.left.toLatex()) + " \\computer " + this.gSymbol.symbol + " \\user " + (this.right == null ? "" : this.right.toLatex());
        }
        return (this.left == null ? "" : this.left.toLatex()) + " " + this.gSymbol.symbol + " " + (this.right == null ? "" : this.right.toLatex());
    }

    public String toDot() {
        return this.dotNode() + (this.left != null ? this.left.toDot() + this.dotID() + " -> " + this.left.dotID() + "\n" : "") + (this.right != null ? this.right.toDot() + this.dotID() + " -> " + this.right.dotID() + "\n" : "");
    }
}

