/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuFrame
extends JFrame {
    JMenuBar mainMenuBar = new JMenuBar();

    MenuFrame(String name) {
        super(name);
        this.addMenus();
    }

    public void addMenus() {
        Menu m = new Menu("Preferences");
        m.simpleAdd("Show handwriting learning...");
        m.simpleAdd("Show preferences...");
        m.addSeparator();
        Menu s = new Menu("Format");
        s.simpleAdd("(see code in MenuFrame)");
        m.add(s);
        ButtonGroup group = new ButtonGroup();
        JMenuItem mi = new JCheckBoxMenuItem(new newActionClass("Create Dot File", new Dot()));
        group.add(mi);
        m.add(mi);
        group = new ButtonGroup();
        s = new Menu("Complexity");
        mi = new JRadioButtonMenuItem(new newActionClass("Very Simple (Addition, Multiplication)", new VerySimple()));
        group.add(mi);
        s.add(mi);
        mi = new JRadioButtonMenuItem(new newActionClass("Simple (Subtraction, Division, Decimals)", new Simple()));
        group.add(mi);
        s.add(mi);
        mi = new JRadioButtonMenuItem(new newActionClass("Medium (Factorial, Roots, Brackets)", new Medium()));
        group.add(mi);
        s.add(mi);
        mi = new JRadioButtonMenuItem(new newActionClass("Full (Exponentiation)", new Full()));
        group.add(mi);
        s.add(mi);
        m.add(s);
        m.addSeparator();
        this.mainMenuBar.add(m);
        m = new Menu("Edit");
        m.simpleAdd("Copy");
        m.simpleAdd("Paste");
        m.simpleAdd("Cut");
        m.simpleAdd("Clear");
        this.mainMenuBar.add(m);
        m = new Menu("Constants");
        m.simpleAdd("\u03c0 = 3.1...", "" + 4.0 * Math.atan(1.0));
        m.simpleAdd("\u03d5 = 1.6...", "" + (1.0 + Math.sqrt(5.0)) / 2.0);
        m.simpleAdd("e = 2.7...", "" + Math.exp(1.0));
        m.addSeparator();
        m.simpleAdd("g");
        m.simpleAdd("h");
        this.mainMenuBar.add(m);
        m = new Menu("Numbers");
        m.simpleAdd("Golden ratio", "{1+5{{1}[2]-}}[2]-");
        m.simpleAdd("4", "2+2=2*2");
        m.simpleAdd("25", "3*3+4*4=5*5");
        m.simpleAdd("50", "5{2} +5{2} =7{(} +1{2} =");
        m.simpleAdd("145", "1!+4!+5!");
        m.simpleAdd("432154", "");
        this.mainMenuBar.add(m);
        this.setJMenuBar(this.mainMenuBar);
    }

    class Dot
    implements MenuItem {
        Dot() {
        }

        public void run() {
            RCPreferences.createDotFile = !RCPreferences.createDotFile;
        }
    }

    class Full
    implements MenuItem {
        Full() {
        }

        public void run() {
            RCPreferences.useExponentiation = true;
            RCPreferences.useDivisor = true;
            RCPreferences.validSymbols = new char[]{'=', '+', '*', '-', '/', '(', ')', '!', 'R', '.'};
        }
    }

    class Medium
    implements MenuItem {
        Medium() {
        }

        public void run() {
            RCPreferences.useExponentiation = false;
            RCPreferences.useDivisor = true;
            RCPreferences.validSymbols = new char[]{'=', '+', '*', '-', '/', '(', ')', '!', 'R', '.'};
        }
    }

    class Simple
    implements MenuItem {
        Simple() {
        }

        public void run() {
            RCPreferences.useExponentiation = false;
            RCPreferences.useDivisor = false;
            RCPreferences.validSymbols = new char[]{'=', '+', '*', '/', '-', '.'};
        }
    }

    class VerySimple
    implements MenuItem {
        VerySimple() {
        }

        public void run() {
            RCPreferences.useExponentiation = false;
            RCPreferences.useDivisor = false;
            RCPreferences.validSymbols = new char[]{'=', '+', '*'};
        }
    }

    static interface MenuItem {
        public void run();
    }

    class Menu
    extends JMenu {
        Menu(String s) {
            super(s);
        }

        public void simpleAdd(String s) {
            super.add(new JMenuItem(new newActionClass(s)));
        }

        public void simpleAdd(String s, String v) {
            super.add(new JMenuItem(new newActionClass(s, v)));
        }

        public void simpleAdd(String s, MenuItem item) {
            super.add(new JMenuItem(new newActionClass(s, item)));
        }
    }

    public class newActionClass
    extends AbstractAction {
        String name;
        String value;
        MenuItem item;

        public newActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.name = text;
            this.putValue("AcceleratorKey", shortcut);
        }

        public newActionClass(String text) {
            super(text);
            this.name = text;
        }

        public newActionClass(String text, String v) {
            super(text);
            this.name = text;
            this.value = v;
        }

        public newActionClass(String text, MenuItem i) {
            super(text);
            this.name = text;
            this.item = i;
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Menu selection: " + this.name + " = " + this.value);
            if (this.item != null) {
                this.item.run();
            } else {
                RealCalc.cFrame.cPanel.graph.parseString(this.value);
                RealCalc.cFrame.cPanel.recogniseGraph();
            }
        }
    }
}

