/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CalculatePanel
extends JPanel
implements MouseMotionListener,
MouseListener,
KeyListener {
    static boolean record = false;
    static boolean demo = false;
    static boolean demoEvent = false;
    public Thread robotThread;
    public RCGraph graph = new RCGraph(null);
    float clickX;
    float clickY;
    RCPoint lastMouse;
    RCStroke stroke;
    RCSelect select;
    boolean selecting = false;
    RCSymbolRecogniser recogniser = RCSymbolRecogniser.symbolRecogniser();
    RCSegmenter segmenter = new RCSegmenter(this.recogniser);
    RCOrganiser organiser;
    Timer recogniseTimer;
    Timer morphTimer;
    Timer selectTimer;
    Timer robotTimer;
    int morphCounter;
    float morphTime;
    private final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    RCClock clock = new RCClock(this);
    RCReset reset = new RCReset(this);
    float trashX = 120.0f;
    float trashY = 120.0f;
    Image trashImage;
    Image trashhighlightImage;
    Image showBoxesImage;
    Image showNumbersImage;
    Image helphelpImage;
    Image helpmathImage;
    Image helpundoImage;
    Image helpdeleteImage;
    Image helpclearImage;
    Image helpImage;
    Image brandImage;
    boolean showingHelp = true;
    boolean showHelpButton = true;
    static String loginName = "test";
    static String loginAge = "?";
    static String loginGender = "?";
    Image changeUserImage;
    String latexLog = "";
    boolean clickInTrash;
    static CalculatePanel mainPanel;
    Action selectAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (CalculatePanel.this.stroke != null) {
                CalculatePanel.this.select = new RCSelect(CalculatePanel.this.stroke, null);
                CalculatePanel.this.stroke = CalculatePanel.this.select;
                CalculatePanel.this.selecting = true;
                CalculatePanel.this.selectTimer.stop();
                CalculatePanel.this.graph.select(CalculatePanel.this.select);
                CalculatePanel.this.repaint();
            }
        }
    };
    Action recogniseSymbolAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            CalculatePanel.this.recogniseSymbol();
        }
    };
    Action morphAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            CalculatePanel.this.morph();
        }
    };
    boolean setupdock = false;
    Image cachedImage;
    boolean caching = false;
    float counter = 0.0f;
    boolean lastActionDelete = false;
    boolean lastActionDrag = false;
    int mouseX;
    int mouseY;
    boolean reverseMorph = false;
    static SimpleDateFormat dateFormat;

    public CalculatePanel() {
        mainPanel = this;
        try {
            this.trashImage = new ImageIcon(new URL(RCApplet.baseURL, "trash.png")).getImage();
            this.trashhighlightImage = new ImageIcon(new URL(RCApplet.baseURL, "trashhighlight.png")).getImage();
            this.showBoxesImage = new ImageIcon(new URL(RCApplet.baseURL, "showBoxes.png")).getImage();
            this.showNumbersImage = new ImageIcon(new URL(RCApplet.baseURL, "showNumbers.png")).getImage();
            this.helphelpImage = new ImageIcon(new URL(RCApplet.baseURL, "help_help.png")).getImage();
            this.helpmathImage = new ImageIcon(new URL(RCApplet.baseURL, "help_math.png")).getImage();
            this.helpclearImage = new ImageIcon(new URL(RCApplet.baseURL, "help_clear.png")).getImage();
            this.helpundoImage = new ImageIcon(new URL(RCApplet.baseURL, "help_undo.png")).getImage();
            this.helpdeleteImage = new ImageIcon(new URL(RCApplet.baseURL, "help_delete.png")).getImage();
            this.helpImage = new ImageIcon(new URL(RCApplet.baseURL, "help.png")).getImage();
            this.brandImage = new ImageIcon(new URL(RCApplet.baseURL, "tc-logo.png")).getImage();
            this.changeUserImage = new ImageIcon(new URL(RCApplet.baseURL, "changeuser.png")).getImage();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.organiser = new RCOrganiser(this, 200.0f);
        this.setBackground(Color.white);
        this.recogniseTimer = new Timer(500, this.recogniseSymbolAction);
        this.recogniseTimer.setInitialDelay(1000);
        this.morphTimer = new Timer(50, this.morphAction);
        this.morphTimer.setInitialDelay(1000);
        this.selectTimer = new Timer(2000, this.selectAction);
        this.requestFocus();
        System.out.println(this.recogniser.count() + " symbols stored");
        try {
            this.recogniser.openUnipenFile(new URL(RCApplet.baseURL, "symbols.unipen"), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(this.recogniser.count() + " symbols stored");
        System.out.println(this.recogniser.maxStrokes() + " max strokes");
    }

    public boolean isFocusable() {
        return true;
    }

    public void setupDock(Graphics2D g2d) {
        this.graph.parseString("");
        this.graph.parse();
        Rectangle b = this.getBounds();
        this.graph.setupMorph(new RCRect((float)b.x + this.organiser.maxSize, b.y, (float)b.width - this.organiser.maxSize, b.height), (Graphics2D)this.getGraphics());
        this.graph.morphToEnd();
        this.graph.keyframe();
        this.graph.tick(1);
        this.organiser.setup(g2d);
        this.setupdock = true;
        this.organiser.enabled = RCPreferences.hasDock;
    }

    public Image image() {
        if (this.cachedImage == null) {
            Rectangle r = this.getBounds();
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            this.cachedImage = gc.createCompatibleImage((int)r.getWidth(), (int)r.getHeight(), 2);
            Graphics2D gImg = (Graphics2D)this.cachedImage.getGraphics();
            this.caching = true;
            this.paintComponent(gImg);
            this.caching = false;
            gImg.dispose();
        }
        return this.cachedImage;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (!RCPreferences.symbolIsValid(e.getKeyChar())) {
            return;
        }
        RCSymbol r = new RCSymbol(e.getKeyChar(), this.graph);
        r.x = (float)this.mouseX + this.counter;
        r.y = this.mouseY;
        r.w = 5.0E-4f;
        r.h = 5.0E-4f;
        this.graph.addObject(r);
        r.recognised = true;
        this.repaint();
        this.recogniseGraph();
        this.counter = (float)((double)this.counter + 0.001);
    }

    public boolean isOpaque() {
        return true;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (!this.setupdock) {
            this.setupDock(g2d);
        }
        Rectangle r = this.getBounds();
        Rectangle2D.Float rbounds = new Rectangle2D.Float(this.organiser.size, 0.0f, (float)r.getWidth(), (float)r.getHeight());
        g2d.setColor(Color.white);
        g2d.fill(rbounds);
        if (this.showHelpButton) {
            g2d.drawImage(this.helpImage, (int)this.organiser.size + 20, 10, 95, 136, this);
        }
        if (CalculateFrame.showBoxes) {
            g2d.drawImage(this.showBoxesImage, (int)this.organiser.size + 120, 10, 112, 112, this);
        } else {
            g2d.drawImage(this.showNumbersImage, (int)this.organiser.size + 120, 10, 112, 112, this);
        }
        this.clock.draw(g2d);
        this.reset.draw(g2d);
        this.organiser.draw(g2d);
        if (RCPreferences.hasLogin) {
            Font drawFont = new Font("Sans-Serif", 0, 100);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout layout = new TextLayout(loginName, drawFont, frc);
            Rectangle2D textBounds = layout.getBounds();
            float yval = 100.0f;
            if (textBounds.getWidth() > r.getWidth() - 500.0) {
                float scale = (float)((double)((float)(r.getWidth() - 500.0)) / textBounds.getWidth());
                yval = 50.0f + 50.0f * scale;
                drawFont = new Font("Sans-Serif", 0, (int)(100.0f * scale));
                frc = g2d.getFontRenderContext();
                layout = new TextLayout(loginName, drawFont, frc);
                textBounds = layout.getBounds();
            }
            g.setColor(new Color(0.0f, 0.0f, 0.0f));
            layout.draw(g2d, (float)(r.getWidth() / 2.0 - textBounds.getWidth() / 2.0), yval);
            g2d.drawImage(this.changeUserImage, (int)(r.getWidth() / 2.0 - textBounds.getWidth() / 2.0) - this.changeUserImage.getWidth(this) - 10, 10, 98, 118, this);
        }
        g2d.drawImage(this.brandImage, (int)(r.getWidth() / 2.0) - this.brandImage.getWidth(this) / 2, (int)r.getHeight() - 149, 221, 149, this);
        if (this.clickInTrash || this.select != null && this.select.dragging && this.select.dragTo.x() > (float)((int)r.getWidth()) - this.trashX && this.select.dragTo.y() > (float)((int)r.getHeight()) - this.trashY && this.select.dragTo.x() < (float)((int)r.getWidth()) - this.trashX + 100.0f && this.select.dragTo.y() < (float)((int)r.getHeight()) - this.trashY + 100.0f) {
            if (this.select != null) {
                this.select.posting = false;
            }
            g2d.drawImage(this.trashhighlightImage, (int)(r.getWidth() - (double)this.trashX), (int)(r.getHeight() - (double)this.trashY), 100, 100, this);
        } else {
            g2d.drawImage(this.trashImage, (int)(r.getWidth() - (double)this.trashX), (int)(r.getHeight() - (double)this.trashY), 100, 100, this);
        }
        if (this.reverseMorph) {
            this.graph.drawAllEver(g2d);
        } else {
            this.graph.draw(g2d);
        }
        this.segmenter.draw(g2d);
        if (this.stroke != null) {
            this.stroke.draw(g2d);
        } else if (this.select != null) {
            this.select.draw(g2d);
        }
        if (this.showingHelp) {
            this.paintHelp(g2d);
        }
    }

    void paintHelp(Graphics2D g2d) {
        Rectangle r = this.getBounds();
        g2d.drawImage(this.helpmathImage, (int)(r.getWidth() / 2.0 - (double)(this.helpmathImage.getWidth(this) / 2)), (int)(r.getHeight() / 2.0 - (double)(this.helpmathImage.getHeight(this) / 2)), this);
        g2d.drawImage(this.helpclearImage, (int)this.organiser.size + 70, (int)(r.getHeight() - (double)this.helpclearImage.getHeight(this)) - 70, this);
        g2d.drawImage(this.helpundoImage, (int)(r.getWidth() - (double)this.helpundoImage.getWidth(this)) - 70, 70, this);
        g2d.drawImage(this.helpdeleteImage, (int)(r.getWidth() - (double)this.helpdeleteImage.getWidth(this)) - 70, (int)(r.getHeight() - (double)this.helpdeleteImage.getHeight(this)) - 70, this);
        g2d.drawImage(this.helphelpImage, (int)this.organiser.size + 70, 70, this);
    }

    public void mousePressed(MouseEvent e) {
        if (this.showingHelp) {
            this.showingHelp = false;
            return;
        }
        Rectangle r = this.getBounds();
        this.cachedImage = null;
        this.clickInTrash = false;
        this.selecting = false;
        this.clickX = e.getX();
        this.clickY = e.getY();
        this.lastMouse = new RCPoint(this.clickX, this.clickY);
        if (this.clickX > (float)((int)r.getWidth()) - this.trashX && this.clickY > (float)((int)r.getHeight()) - this.trashY && this.clickX < (float)((int)r.getWidth()) - this.trashX + 100.0f && this.clickY < (float)((int)r.getHeight()) - this.trashY + 100.0f) {
            this.clickInTrash = true;
            return;
        }
        if (this.clock.click(this.clickX, this.clickY)) {
            this.latexLog = this.latexLog + dateFormat.format(new Date()) + "\t  REWIND\n\n";
            return;
        }
        if (this.reset.click(this.clickX, this.clickY)) {
            return;
        }
        if (this.clickX > this.organiser.size + 20.0f && this.clickX < this.organiser.size + 20.0f + 120.0f && this.clickY < 150.0f) {
            if (this.showHelpButton) {
                this.showingHelp = true;
                return;
            }
            CalculateFrame.showBoxes = !CalculateFrame.showBoxes;
            this.repaint();
            return;
        }
        if (this.clickX > this.organiser.size + 20.0f && this.clickX < this.organiser.size + 120.0f + 140.0f && this.clickY < 150.0f) {
            CalculateFrame.showBoxes = !CalculateFrame.showBoxes;
            this.repaint();
            return;
        }
        if (RCPreferences.hasLogin && this.clickY < 120.0f) {
            new LoginDialog();
            return;
        }
        if (this.organiser.click(this.clickX, this.clickY)) {
            return;
        }
        if (this.reverseMorph) {
            this.graph.timeTravel(this.graph.displayTime);
            this.reverseMorph = false;
        }
        this.graph.hideComputers();
        if (this.select != null) {
            if (this.select.pointInside(new RCPoint(this.clickX, this.clickY))) {
                this.select.dragFrom(new RCPoint(this.clickX, this.clickY));
            } else {
                this.select = null;
                this.recogniseTimer.restart();
            }
            this.repaint();
            return;
        }
        this.stroke = new RCStroke(null, new RCPoint(this.clickX, this.clickY), '?');
        if (this.recogniseTimer != null) {
            this.recogniseTimer.stop();
        }
        if (this.morphTimer != null) {
            this.morphTimer.stop();
        }
        this.selectTimer.restart();
    }

    public void mouseReleased(MouseEvent e) {
        Rectangle r = this.getBounds();
        this.lastActionDelete = false;
        this.lastActionDrag = false;
        if (this.clickInTrash) {
            return;
        }
        if (this.organiser.release(e.getX(), e.getY())) {
            return;
        }
        if (this.reset.release(e.getX(), e.getY())) {
            this.latexLog = this.latexLog + dateFormat.format(new Date()) + "\t  CLEAR\n\n";
            return;
        }
        if (!this.selecting && this.select != null) {
            if (this.select.dragTo.x() > (float)((int)r.getWidth()) - this.trashX && this.select.dragTo.y() > (float)((int)r.getHeight()) - this.trashY && this.select.dragTo.x() < (float)((int)r.getWidth()) - this.trashX + 100.0f && this.select.dragTo.y() < (float)((int)r.getHeight()) - this.trashY + 100.0f) {
                this.segmenter.deleteSelection(this.select);
                this.graph.select(this.select);
                this.deleteSelected();
                this.lastActionDelete = true;
            } else if (this.select.dragTo.x() < this.organiser.size) {
                RCGraph newgraph = this.graph.graphFromSelection();
                newgraph.parse();
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                newgraph.setupMorph(new RCRect(this.organiser.maxSize, 0.0f, (float)((int)dim.getWidth()) + this.organiser.maxSize, (int)dim.getHeight()), (Graphics2D)this.getGraphics());
                newgraph.morphToEnd();
                this.organiser.addNote(newgraph, 0, e.getY());
                this.graph.parse();
                this.select = null;
                this.repaint();
            } else {
                this.graph.moveSelection(this.select);
                this.graph.parse();
                this.graph.resetSelection(this.select);
                this.lastActionDrag = true;
            }
            this.beginMorph();
            this.morphCounter = 1;
            this.morphTimer.setInitialDelay(0);
            this.morphTimer.restart();
            this.select = null;
            return;
        }
        if (this.stroke == null) {
            return;
        }
        this.stroke.addPoint(new RCPoint(e.getX(), e.getY()));
        if (this.select != null) {
            this.stroke = null;
            return;
        }
        this.segmenter.addStroke(this.stroke);
        if (this.segmenter.numberOfStrokes() >= 2 * this.recogniser.maxStrokes()) {
            this.recogniseSymbol();
        }
        this.recogniseTimer.restart();
        this.stroke = null;
    }

    void deleteSelected() {
        this.graph.deleteSelection();
        if (this.segmenter.numberOfStrokes() > 0) {
            this.recogniseTimer.restart();
            this.select = null;
            return;
        }
        this.graph.parse();
        this.graph.addObject(new RCPoof(this.graph, this.graph.deletedRect));
    }

    public void mouseDragged(MouseEvent e) {
        boolean added = false;
        Rectangle r = this.getBounds();
        if (this.reverseMorph) {
            this.clock.drag(e.getX(), e.getY());
            return;
        }
        if (this.clickInTrash) {
            this.trashX -= (float)e.getX() - this.lastMouse.x();
            this.trashY -= (float)e.getY() - this.lastMouse.y();
            this.repaint();
            this.lastMouse = new RCPoint(e.getX(), e.getY());
            return;
        }
        this.lastMouse = new RCPoint(e.getX(), e.getY());
        if (this.reset.drag(e.getX(), e.getY())) {
            return;
        }
        if (this.organiser.drag(e.getX(), e.getY())) {
            return;
        }
        if (this.select != null && this.select.dragging) {
            this.select.dragTo(new RCPoint(e.getX(), e.getY()));
            this.repaint();
            return;
        }
        if (this.stroke != null) {
            Rectangle rr = new Rectangle((int)this.stroke.lastX - 5, (int)this.stroke.lastY - 5, 0, 0);
            rr.add(this.stroke.lastX + 5.0f, this.stroke.lastY + 5.0f);
            rr.add(e.getX() + 5, e.getY() + 5);
            rr.add(e.getX() - 5, e.getY() - 5);
            added = this.stroke.addPoint(new RCPoint(e.getX(), e.getY()));
            float dx = this.stroke.lastX - (float)e.getX();
            float dy = this.stroke.lastY - (float)e.getY();
            if (this.select == null) {
                this.repaint(rr);
            } else {
                this.repaint();
            }
        }
        if (this.graph.selectionCount(this.stroke) > 0 && this.stroke.isLoop) {
            this.selectAction.actionPerformed(null);
        }
        if (added) {
            this.selectTimer.restart();
        } else if (this.select != null) {
            this.graph.select(this.select);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }

    public void tabletProximity(MouseEvent e) {
    }

    public void tabletPoint(MouseEvent e) {
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }

    void recogniseSymbol() {
        this.segmenter.panel = this;
        new Thread(this.segmenter).start();
    }

    void hasRecognisedSymbol(RCSymbol symbol) {
        if (symbol != null) {
            if (symbol.symbol() == '#') {
                this.graph.select(symbol);
                this.deleteSelected();
                this.beginMorph();
                this.morphCounter = 1;
                if (this.segmenter.numberOfStrokes() == 0) {
                    this.recogniseTimer.stop();
                    this.morphTimer.setInitialDelay(0);
                    this.morphTimer.restart();
                    this.select = null;
                }
                return;
            }
            if (symbol.symbol() != '~') {
                this.graph.addObject(symbol);
                symbol.recognised = true;
            }
            this.repaint();
        }
        if (this.segmenter.numberOfStrokes() == 0) {
            this.recogniseGraph();
        }
    }

    void recogniseGraph() {
        this.recogniseTimer.stop();
        this.morphTimer.restart();
        this.morphCounter = 0;
    }

    void beginMorph() {
        Rectangle b = this.getBounds();
        this.graph.setupMorph(new RCRect((float)b.x + this.organiser.maxSize, b.y, (float)b.width - this.organiser.maxSize, b.height), (Graphics2D)this.getGraphics());
        this.reverseMorph = false;
        if (RCPreferences.createDotFile) {
            this.createDot();
        }
    }

    void morph() {
        this.morphTimer.setInitialDelay(1000);
        if (this.morphCounter == 0) {
            this.graph.parse();
            this.beginMorph();
        }
        this.graph.tick();
        this.graph.morph();
        if (this.morphCounter == 7) {
            this.latexLog = this.lastActionDelete ? this.latexLog + dateFormat.format(new Date()) + "\t  DELETE\n$$\n" + this.graph.root().toLatex() + "\n$$\n" : (this.lastActionDrag ? this.latexLog + dateFormat.format(new Date()) + "\t  DRAG\n$$\n" + this.graph.root().toLatex() + "\n$$\n" : this.latexLog + dateFormat.format(new Date()) + "\n$$\n" + this.graph.root().toLatex() + "\n$$\n");
        }
        if (this.morphCounter > 50) {
            this.morphTimer.stop();
        }
        ++this.morphCounter;
        this.repaint();
    }

    void createDot() {
        try {
            FileOutputStream out = new FileOutputStream("mygraph.dot");
            PrintStream p = new PrintStream(out);
            p.println("digraph L0 {\nsize = \"8,8\";\nordering=out;\nnode [shape = box];\n");
            p.println(this.graph.root().toDot());
            p.println("\n}");
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error writing to file");
            System.err.println(e);
        }
    }

    static {
        dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss");
    }
}

