// SimpleLed.cpp

#include "SimpleLed.h"
#include "EventManager.h"
#include <Arduino.h>

//////////////////////////////////////////////////////////////////////

extern EventManager* EVENTS;

//////////////////////////////////////////////////////////////////////

SimpleLed::SimpleLed(uint8_t pin)
{
	this->_pin = pin;
}

//////////////////////////////////////////////////////////////////////

void SimpleLed::init()
{
	_status = false;

	pinMode(_pin, OUTPUT);

    EVENTS->add(this);
}

//////////////////////////////////////////////////////////////////////

void SimpleLed::setStatus(bool value)
{
	this->_status = value;
	digitalWrite(_pin, _status ? HIGH : LOW);
}

//////////////////////////////////////////////////////////////////////

void SimpleLed::toggle()
{
	_status = !_status;
	digitalWrite(_pin, _status ? HIGH : LOW);
}

//////////////////////////////////////////////////////////////////////

void SimpleLed::flashOne(uint16_t millis)
{
	setStatus(true);
	delay(millis);
	setStatus(false);
}

//////////////////////////////////////////////////////////////////////

// EOF
