/*
 * Decompiled with CFR 0.152.
 */
package hotpotnetclient;

import hotpotnetclient.HpNetClientApp;
import hotpotnetclient.ThreadCreateDemo;
import hotpotnetclient.ThreadLogin;
import hotpotnetclient.ThreadPreamble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class HotPotNetLogin
extends JDialog {
    ArrayList arl_MimeTypes;
    boolean b_AssetsOK = true;
    boolean b_LoginOK = false;
    boolean b_PreambleOK = false;
    boolean b_fromServer = false;
    JButton btn_HotPotNetLoginCancel;
    JButton btn_HotPotNetLoginHelp;
    JButton btn_HotPotNetLoginLogout;
    JButton btn_HotPotNetLoginOK;
    ButtonGroup btngrp_HotPotNetUseAccount;
    ButtonGroup btngrp_ProxyUseSettings;
    JCheckBox cb_ProxyUseBasicAuthentication;
    JCheckBox cb_SaveHotPotNetPassword;
    JCheckBox cb_UseProxy;
    String crlf = "";
    JDialog dlg_ConfirmAssets;
    GridBagConstraints gbc;
    HpNetClientApp hpNetClientApp;
    int int_ExAssetCount = 0;
    int int_previousResults = -1;
    JLabel lbl_HotPotNetPassword;
    JLabel lbl_HotPotNetUserName;
    JLabel lbl_ProxyPassword;
    JLabel lbl_ProxyPort;
    JLabel lbl_ProxyServer;
    JLabel lbl_ProxyUserName;
    BorderLayout lom_ConfirmAssetsAll;
    BorderLayout lom_HotPotNetLoginAll;
    GridBagLayout lom_HotPotNetLoginAllButButtons;
    BoxLayout lom_HotPotNetLoginButtons;
    JPanel pnl_ConfirmAssetsAll;
    JPanel pnl_ConfirmAssetsAllButButtons;
    JPanel pnl_HotPotNetLoginAll = new JPanel();
    JPanel pnl_HotPotNetLoginAllButButtons;
    JPanel pnl_HotPotNetLoginButtons;
    JRadioButton rb_CreateDemoAcct;
    JRadioButton rb_ProxySetManually;
    JRadioButton rb_ProxyUseIe;
    JRadioButton rb_UseLogin;
    String str_AssetSummaryToUpload = "";
    String str_ExPageContents = "";
    String str_PreviousClass = "";
    String str_UCPageContents = "";
    JPasswordField tf_HotPotNetPassword;
    JTextField tf_HotPotNetUserName;
    JTextField tf_ProxyPassword;
    JTextField tf_ProxyPort;
    JTextField tf_ProxyServer;
    JTextField tf_ProxyUserName;
    Vector v_AssetPaths;
    Vector v_AssetsToConfirm;
    Vector v_AssetsToUpload;

    public HotPotNetLogin(HpNetClientApp hpNetClientApp_In) throws HeadlessException {
        this.lom_HotPotNetLoginAll = new BorderLayout();
        this.pnl_HotPotNetLoginAllButButtons = new JPanel();
        this.lom_HotPotNetLoginAllButButtons = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.rb_CreateDemoAcct = new JRadioButton("Create demo account");
        this.rb_UseLogin = new JRadioButton("Login to account");
        this.btngrp_HotPotNetUseAccount = new ButtonGroup();
        this.lbl_HotPotNetUserName = new JLabel("hotpotatoes.net user name: ");
        this.tf_HotPotNetUserName = new JTextField();
        this.lbl_HotPotNetPassword = new JLabel("Password");
        this.tf_HotPotNetPassword = new JPasswordField();
        this.cb_SaveHotPotNetPassword = new JCheckBox("Save HotPotatoes.net password");
        this.cb_UseProxy = new JCheckBox("Use Proxy Server to connect to internet");
        this.rb_ProxyUseIe = new JRadioButton("Use proxy server settings from IE");
        this.rb_ProxySetManually = new JRadioButton("Specify settings");
        this.btngrp_ProxyUseSettings = new ButtonGroup();
        this.lbl_ProxyUserName = new JLabel("User Name");
        this.tf_ProxyUserName = new JTextField();
        this.lbl_ProxyPassword = new JLabel("Password");
        this.tf_ProxyPassword = new JTextField();
        this.lbl_ProxyServer = new JLabel("Server");
        this.tf_ProxyServer = new JTextField();
        this.lbl_ProxyPort = new JLabel("Port");
        this.tf_ProxyPort = new JTextField();
        this.cb_ProxyUseBasicAuthentication = new JCheckBox("Use Basic Proxy Authentication");
        this.pnl_HotPotNetLoginButtons = new JPanel();
        this.lom_HotPotNetLoginButtons = new BoxLayout(this.pnl_HotPotNetLoginButtons, 0);
        this.btn_HotPotNetLoginOK = new JButton("OK");
        this.btn_HotPotNetLoginCancel = new JButton("Cancel");
        this.btn_HotPotNetLoginHelp = new JButton("Help");
        this.btn_HotPotNetLoginLogout = new JButton("Logout");
        this.arl_MimeTypes = new ArrayList(40);
        this.v_AssetPaths = new Vector();
        this.v_AssetsToUpload = new Vector();
        this.v_AssetsToConfirm = new Vector();
        this.pnl_ConfirmAssetsAllButButtons = new JPanel();
        this.hpNetClientApp = hpNetClientApp_In;
        this.initComponents();
        this.initVars();
        this.initLayout();
        this.updateLoginItems(this.rb_UseLogin.isSelected());
        this.rb_ProxyUseIe.setEnabled(this.cb_UseProxy.isSelected());
        this.rb_ProxySetManually.setEnabled(this.cb_UseProxy.isSelected());
        this.updateProxyItems(this.rb_ProxySetManually.isSelected());
        this.setSize(400, 400);
        this.validate();
    }

    String ExtractFileName(String str_PathIn) {
        int i = str_PathIn.lastIndexOf(System.getProperty("file.separator"));
        if (i < 0) {
            return str_PathIn;
        }
        return str_PathIn.substring(i, str_PathIn.length());
    }

    int GetMediaAssetList(String str_ExFile, String str_BaseForRelPaths, String str_OutputPath, boolean b_separateJavaScriptFile, String str_AssetPathPrefix) {
        this.v_AssetPaths.setSize(0);
        int i = 0;
        while (i < this.arl_MimeTypes.size()) {
            this.str_UCPageContents = str_ExFile.toUpperCase();
            this.str_UCPageContents = this.str_UCPageContents.replaceAll("'", "\"");
            this.processExtension((String)this.arl_MimeTypes.get(i), str_BaseForRelPaths, str_AssetPathPrefix);
            ++i;
        }
        return this.v_AssetPaths.size();
    }

    void assetLists() {
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Checking for media assets in exercise ...");
        this.hpNetClientApp.dlg_Status.setVisible(true);
        this.str_ExPageContents = this.hpNetClientApp.str_Exercise;
        boolean b_AssetsDone = true;
        int int_ExAssetCount = this.GetMediaAssetList(this.str_ExPageContents, this.hpNetClientApp.f_ExerciseFile.getAbsolutePath(), "", false, "assets/");
        System.out.println("HotPotNetLogin.assetLists # of assets in exercise : " + int_ExAssetCount);
        if (int_ExAssetCount > 0) {
            String str_FromServer = this.hpNetClientApp.hpNetInOut.getServerAssetList(this.hpNetClientApp.hpNetInOut.str_SessionID);
            this.receiveAssetListFromServer(str_FromServer);
        }
        this.hpNetClientApp.dlg_Status.setVisible(false);
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("");
    }

    void btn_ConfirmAssetOverwriteCancelActionPerformed() {
        this.b_AssetsOK = false;
    }

    void btn_ConfirmAssetOverwriteOKActionPerformed() {
        int int_cbInc = 0;
        int i = 0;
        while (i < this.pnl_ConfirmAssetsAllButButtons.getComponentCount()) {
            try {
                JCheckBox cb_Junk = (JCheckBox)this.pnl_ConfirmAssetsAllButButtons.getComponent(i);
                if (cb_Junk.isSelected()) {
                    this.v_AssetsToUpload.add(this.v_AssetsToConfirm.get(int_cbInc));
                }
                ++int_cbInc;
            }
            catch (Exception e) {}
            ++i;
        }
        this.b_AssetsOK = true;
    }

    void btn_HotPotNetLoginCancelActionPerformed() {
        this.setVisible(false);
    }

    void btn_HotPotNetLoginHelpActionPerformed() {
        Vector<String> v_Junk = new Vector<String>();
        v_Junk.add("bingo");
        v_Junk.add("bango");
        v_Junk.add("bongo");
        this.v_AssetsToConfirm = v_Junk;
        this.dlg_ConfirmAssets = this.createConfirmAssetsDialog(this.v_AssetsToConfirm);
        this.dlg_ConfirmAssets.setVisible(true);
    }

    void btn_HotPotNetLoginLogoutActionPerformed() {
        String str_FromServer = this.hpNetClientApp.hpNetInOut.logOut(this.hpNetClientApp.hpNetInOut.str_SessionID);
        int int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
        if (int_resultCode == 1) {
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false));
            this.hpNetClientApp.dlg_Status.setVisible(true);
            this.hpNetClientApp.hpNetInOut.str_SessionID = "";
            this.setVisible(false);
        } else {
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false));
        }
    }

    void btn_HotPotNetLoginOKActionPerformed() {
        if (this.tf_HotPotNetUserName.getText().length() < 1) {
            JOptionPane.showMessageDialog(this, "Please enter a user name.");
            return;
        }
        if (this.rb_UseLogin.isSelected() && this.tf_HotPotNetPassword.getPassword().length < 1) {
            JOptionPane.showMessageDialog(this, "Please enter a password.");
            return;
        }
        if (this.rb_ProxySetManually.isSelected() && (this.tf_ProxyUserName.getText().length() < 1 || this.tf_ProxyPassword.getText().length() < 1 || this.tf_ProxyServer.getText().length() < 1 || this.tf_ProxyPort.getText().length() < 1)) {
            JOptionPane.showMessageDialog(this, "Please fill in values for all proxy server settings.");
            return;
        }
        if (this.cb_UseProxy.isSelected()) {
            System.setProperty("proxySet", "true");
            if (this.rb_ProxySetManually.isSelected()) {
                System.setProperty("http.proxyHost", this.tf_ProxyServer.getText());
                System.setProperty("http.proxyPort", this.tf_ProxyPort.getText());
            }
        } else if (this.hpNetClientApp.dlgOwner.regSaxModel.getRegBoolean("hotpotnet6-use-proxy-server", false)) {
            System.setProperty("proxySet", "false");
        }
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-user-name", this.tf_HotPotNetUserName.getText());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegBoolean("hotpotnet6-save-password", this.cb_SaveHotPotNetPassword.isSelected());
        if (this.cb_SaveHotPotNetPassword.isSelected()) {
            StringBuffer sb_Junk = new StringBuffer();
            sb_Junk.append(this.tf_HotPotNetPassword.getPassword());
            this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-password", sb_Junk.toString());
        } else {
            this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-password", "");
        }
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegBoolean("hotpotnet6-use-proxy-server", this.cb_UseProxy.isSelected());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegBoolean("hotpotnet6-use-ie-proxy-settings", this.rb_ProxyUseIe.isSelected());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-proxy-user-name", this.tf_ProxyUserName.getText());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-proxy-password", this.tf_ProxyPassword.getText());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-proxy-server", this.tf_ProxyServer.getText());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegString("hotpotnet6-proxy-port", this.tf_ProxyPort.getText());
        this.hpNetClientApp.dlgOwner.regSaxModel.setRegBoolean("hotpotnet6-use-basic-proxy", this.cb_ProxyUseBasicAuthentication.isSelected());
        String str_Temp = this.hpNetClientApp.dlgOwner.regSaxModel.xmlHeader + this.hpNetClientApp.dlgOwner.regSaxModel.crlf + this.hpNetClientApp.dlgOwner.regSaxModel.toXml();
        if (!this.hpNetClientApp.dlgOwner.regSaxModel.writeStringToFile(str_Temp, this.hpNetClientApp.dlgOwner.regSaxModel.hbsRegFile)) {
            this.hpNetClientApp.dlgOwner.regSaxModel.writeErrorReport("HotPotNetLogin calling HotPotRegSaxModel.writeStringToFile() Failed to write Registration file.");
        }
        if (this.rb_UseLogin.isSelected()) {
            this.loginUserUI();
        } else {
            this.createDemoUI();
        }
    }

    void btngrp_HotPotNetUseAccountActionPerformed() {
        this.updateLoginItems(this.rb_UseLogin.isSelected());
    }

    void btngrp_ProxyUseSettingsActionPerformed() {
        this.updateProxyItems(this.rb_ProxySetManually.isSelected());
    }

    void cb_UseProxyActionPerformed() {
        int int_temp = 1;
        if (this.cb_UseProxy.isSelected()) {
            int_temp = JOptionPane.showConfirmDialog(null, "Setting Proxy server settings may affect other programs. Do you wish to continue?", "Set Proxy Server Manually", 0, 2);
        }
        if (int_temp == 0) {
            this.updateProxyItems(this.rb_ProxySetManually.isSelected() && this.rb_ProxySetManually.isEnabled());
        } else {
            this.cb_UseProxy.setSelected(false);
        }
        this.rb_ProxyUseIe.setEnabled(this.cb_UseProxy.isSelected());
        this.rb_ProxySetManually.setEnabled(this.cb_UseProxy.isSelected());
    }

    JDialog createConfirmAssetsDialog(Vector v_AssetsToConfirm) {
        this.pnl_ConfirmAssetsAll = new JPanel();
        BorderLayout lom_ConfirmAssetsAll = new BorderLayout();
        this.pnl_ConfirmAssetsAllButButtons = new JPanel();
        GridBagLayout lom_ConfirmAssetsAllButButtons = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel pnl_ConfirmAssetsButtons = new JPanel();
        BoxLayout lom_ConfirmAssetsButtons = new BoxLayout(pnl_ConfirmAssetsButtons, 0);
        JDialog dlg = new JDialog(this);
        dlg.setTitle("Overwrite Assets on Server");
        dlg.getContentPane().setLayout(new BorderLayout());
        this.pnl_ConfirmAssetsAll.setLayout(lom_ConfirmAssetsAll);
        this.pnl_ConfirmAssetsAllButButtons.setLayout(lom_ConfirmAssetsAllButButtons);
        this.pnl_ConfirmAssetsAll.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pnl_ConfirmAssetsAllButButtons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        dlg.getContentPane().add(this.pnl_ConfirmAssetsAll);
        this.pnl_ConfirmAssetsAll.add((Component)this.pnl_ConfirmAssetsAllButButtons, "Center");
        this.pnl_ConfirmAssetsAll.add((Component)pnl_ConfirmAssetsButtons, "South");
        JTextArea ta_ConfirmAssetOverwrite = new JTextArea();
        ta_ConfirmAssetOverwrite.setText("Assets with these names exist in your exercise and on the server. \nCheck the box beside each asset you want to overwrite.");
        ta_ConfirmAssetOverwrite.setEditable(false);
        ta_ConfirmAssetOverwrite.setLineWrap(true);
        ta_ConfirmAssetOverwrite.setWrapStyleWord(true);
        JLabel lbl_ConfirmAssetOverwrite2 = new JLabel();
        lbl_ConfirmAssetOverwrite2.setText("Check the box beside each asset you want to overwrite.");
        JButton btn_ConfirmAssetOverwriteOK = new JButton("OK");
        btn_ConfirmAssetOverwriteOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_ConfirmAssetOverwriteOKActionPerformed();
            }
        });
        JButton btn_ConfirmAssetOverwriteCancel = new JButton("Cancel");
        btn_ConfirmAssetOverwriteCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_ConfirmAssetOverwriteCancelActionPerformed();
            }
        });
        gbc.insets = new Insets(1, 2, 1, 2);
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.pnl_ConfirmAssetsAllButButtons.add((Component)ta_ConfirmAssetOverwrite, gbc);
        int i = 0;
        while (i < v_AssetsToConfirm.size()) {
            ++gbc.gridy;
            JCheckBox cb_Temp = new JCheckBox();
            cb_Temp.setText(v_AssetsToConfirm.get(i).toString());
            cb_Temp.setName("cb-confirm-overwrite-" + i);
            this.pnl_ConfirmAssetsAllButButtons.add((Component)cb_Temp, gbc);
            ++i;
        }
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.pnl_ConfirmAssetsAllButButtons.add(Box.createVerticalStrut(1), gbc);
        pnl_ConfirmAssetsButtons.add(Box.createHorizontalGlue());
        pnl_ConfirmAssetsButtons.add(btn_ConfirmAssetOverwriteOK);
        pnl_ConfirmAssetsButtons.add(Box.createHorizontalGlue());
        pnl_ConfirmAssetsButtons.add(btn_ConfirmAssetOverwriteCancel);
        pnl_ConfirmAssetsButtons.add(Box.createHorizontalGlue());
        dlg.setLocationRelativeTo(this);
        dlg.setSize(400, 400);
        dlg.validate();
        return dlg;
    }

    void createDemoUI() {
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Logging in to hotpotatoes.net server...");
        this.hpNetClientApp.dlg_Status.setVisible(true);
        ThreadCreateDemo threadCreateDemo = new ThreadCreateDemo(this);
        Thread t = new Thread(threadCreateDemo);
        t.start();
    }

    Vector createServerAssetVector(String str_FromServer) {
        String str_Temp = str_FromServer;
        Vector<String> v_Temp = new Vector<String>();
        int int_endOfNextHitIndex = 0;
        while (int_endOfNextHitIndex > -1) {
            int_endOfNextHitIndex = str_Temp.indexOf("</assetname>") + "</assetname>".length();
            v_Temp.add(this.hpNetClientApp.hpNetInOut.getTextBetween(str_Temp, "<assetname>", "</assetname>", false));
            str_Temp = str_Temp.substring(int_endOfNextHitIndex);
        }
        return v_Temp;
    }

    void initComponents() {
        this.setTitle("Login to hotpotatoes.net");
        this.btngrp_HotPotNetUseAccount.add(this.rb_CreateDemoAcct);
        this.btngrp_HotPotNetUseAccount.add(this.rb_UseLogin);
        this.rb_CreateDemoAcct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btngrp_HotPotNetUseAccountActionPerformed();
            }
        });
        this.rb_UseLogin.setSelected(true);
        this.rb_UseLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btngrp_HotPotNetUseAccountActionPerformed();
            }
        });
        this.tf_HotPotNetUserName.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-user-name", ""));
        this.cb_SaveHotPotNetPassword.setSelected(this.hpNetClientApp.dlgOwner.regSaxModel.getRegBoolean("hotpotnet6-save-password", false));
        if (this.cb_SaveHotPotNetPassword.isSelected()) {
            this.tf_HotPotNetPassword.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-password", ""));
        } else {
            this.tf_HotPotNetPassword.setText("");
        }
        this.tf_HotPotNetPassword.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String str_Temp = HotPotNetLogin.this.tf_HotPotNetPassword.getPassword().toString();
                if (str_Temp.indexOf("-") > 0 && str_Temp.length() == 13 | str_Temp.length() == 14) {
                    JOptionPane.showMessageDialog(null, "A hot potatoes registration key does not work as a password for a Hotpotatoes.net account.");
                }
            }
        });
        this.cb_UseProxy.setSelected(this.hpNetClientApp.dlgOwner.regSaxModel.getRegBoolean("hotpotnet6-use-proxy-server", false));
        this.cb_UseProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.cb_UseProxyActionPerformed();
            }
        });
        this.btngrp_ProxyUseSettings.add(this.rb_ProxyUseIe);
        this.btngrp_ProxyUseSettings.add(this.rb_ProxySetManually);
        this.rb_ProxyUseIe.setSelected(this.hpNetClientApp.dlgOwner.regSaxModel.getRegBoolean("hotpotnet6-use-ie-proxy-settings", true));
        this.rb_ProxyUseIe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btngrp_ProxyUseSettingsActionPerformed();
            }
        });
        this.rb_ProxySetManually.setSelected(!this.rb_ProxyUseIe.isSelected());
        this.rb_ProxySetManually.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btngrp_ProxyUseSettingsActionPerformed();
            }
        });
        this.tf_ProxyUserName.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-proxy-user-name", ""));
        this.tf_ProxyPassword.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-proxy-password", ""));
        this.tf_ProxyServer.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-proxy-server", ""));
        this.tf_ProxyPort.setText(this.hpNetClientApp.dlgOwner.regSaxModel.getRegString("hotpotnet6-proxy-port", ""));
        this.cb_ProxyUseBasicAuthentication.setSelected(this.hpNetClientApp.dlgOwner.regSaxModel.getRegBoolean("hotpotnet6-use-basic-proxy", false));
        this.btn_HotPotNetLoginOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_HotPotNetLoginOKActionPerformed();
            }
        });
        this.btn_HotPotNetLoginCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_HotPotNetLoginCancelActionPerformed();
            }
        });
        this.btn_HotPotNetLoginHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_HotPotNetLoginHelpActionPerformed();
            }
        });
        this.btn_HotPotNetLoginLogout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetLogin.this.btn_HotPotNetLoginLogoutActionPerformed();
            }
        });
    }

    void initLayout() {
        this.pnl_HotPotNetLoginAll.setLayout(this.lom_HotPotNetLoginAll);
        this.pnl_HotPotNetLoginAllButButtons.setLayout(this.lom_HotPotNetLoginAllButButtons);
        this.pnl_HotPotNetLoginButtons.setLayout(this.lom_HotPotNetLoginButtons);
        this.pnl_HotPotNetLoginAllButButtons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(this.pnl_HotPotNetLoginAll);
        this.pnl_HotPotNetLoginAll.add((Component)this.pnl_HotPotNetLoginAllButButtons, "Center");
        this.pnl_HotPotNetLoginAll.add((Component)this.pnl_HotPotNetLoginButtons, "South");
        this.gbc.insets = new Insets(1, 2, 1, 2);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridwidth = 2;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_HotPotNetUserName, this.gbc);
        this.gbc.gridx += 2;
        this.gbc.weightx = 1.0;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_HotPotNetUserName, this.gbc);
        this.gbc.weightx = 0.0;
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 4;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.rb_CreateDemoAcct, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 4;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.rb_UseLogin, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.pnl_HotPotNetLoginAllButButtons.add(Box.createHorizontalStrut(10), this.gbc);
        ++this.gbc.gridx;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_HotPotNetPassword, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_HotPotNetPassword, this.gbc);
        this.gbc.weightx = 0.0;
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.pnl_HotPotNetLoginAllButButtons.add(Box.createHorizontalStrut(10), this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridwidth = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.cb_SaveHotPotNetPassword, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 4;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.cb_UseProxy, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 7;
        this.gbc.gridwidth = 1;
        this.pnl_HotPotNetLoginAllButButtons.add(Box.createHorizontalStrut(20), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 1;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.rb_ProxyUseIe, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.rb_ProxySetManually, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.gridx = 1;
        this.gbc.gridheight = 5;
        this.pnl_HotPotNetLoginAllButButtons.add(Box.createHorizontalStrut(20), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridheight = 1;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_ProxyUserName, this.gbc);
        this.gbc.gridx = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_ProxyUserName, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 2;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_ProxyPassword, this.gbc);
        this.gbc.gridx = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_ProxyPassword, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 2;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_ProxyServer, this.gbc);
        this.gbc.gridx = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_ProxyServer, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 2;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.lbl_ProxyPort, this.gbc);
        this.gbc.gridx = 3;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.tf_ProxyPort, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 2;
        this.pnl_HotPotNetLoginAllButButtons.add((Component)this.cb_ProxyUseBasicAuthentication, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 4;
        this.gbc.gridx = 0;
        this.gbc.weighty = 1.0;
        this.pnl_HotPotNetLoginAllButButtons.add(Box.createVerticalStrut(1), this.gbc);
        this.pnl_HotPotNetLoginButtons.add(Box.createHorizontalGlue());
        this.pnl_HotPotNetLoginButtons.add(this.btn_HotPotNetLoginOK);
        this.pnl_HotPotNetLoginButtons.add(this.btn_HotPotNetLoginCancel);
        this.pnl_HotPotNetLoginButtons.add(Box.createHorizontalGlue());
        this.pnl_HotPotNetLoginButtons.add(this.btn_HotPotNetLoginHelp);
        this.pnl_HotPotNetLoginButtons.add(this.btn_HotPotNetLoginLogout);
        this.pnl_HotPotNetLoginButtons.add(Box.createHorizontalGlue());
    }

    void initVars() {
        this.crlf = this.hpNetClientApp.dlgOwner.regSaxModel.crlf;
        this.arl_MimeTypes.add("GIF");
        this.arl_MimeTypes.add("JPG");
        this.arl_MimeTypes.add("JPEG");
        this.arl_MimeTypes.add("PNG");
        this.arl_MimeTypes.add("MP3");
        this.arl_MimeTypes.add("RM");
        this.arl_MimeTypes.add("RA");
        this.arl_MimeTypes.add("SWF");
        this.arl_MimeTypes.add("WMA");
        this.arl_MimeTypes.add("QT");
        this.arl_MimeTypes.add("MOV");
        this.arl_MimeTypes.add("MPG");
        this.arl_MimeTypes.add("MPEG");
        this.arl_MimeTypes.add("ZIP");
        this.arl_MimeTypes.add("JS");
        this.arl_MimeTypes.add("WAV");
        this.arl_MimeTypes.add("AVI");
        this.arl_MimeTypes.add("CSS");
        this.arl_MimeTypes.add("DOC");
        this.arl_MimeTypes.add("XLS");
        this.arl_MimeTypes.add("PPT");
        this.arl_MimeTypes.add("PDF");
        this.arl_MimeTypes.add("XML");
        this.arl_MimeTypes.add("XSL");
        this.arl_MimeTypes.add("ASF");
        this.arl_MimeTypes.add("ASX");
        this.arl_MimeTypes.add("WAX");
        this.arl_MimeTypes.add("WMV");
        this.arl_MimeTypes.add("WVX");
        this.arl_MimeTypes.add("WM");
        this.arl_MimeTypes.add("WMX");
        this.arl_MimeTypes.add("WMZ");
        this.arl_MimeTypes.add("WMD");
    }

    void loginUserUI() {
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Logging in to hotpotatoes.net server...");
        this.hpNetClientApp.dlg_Status.setVisible(true);
        ThreadLogin threadLogin = new ThreadLogin(this);
        Thread t = new Thread(threadLogin);
        t.start();
    }

    void preambleUI() {
        ThreadPreamble threadPreamble = new ThreadPreamble(this);
        Thread t = new Thread(threadPreamble);
        t.start();
    }

    void processExtension(String str_Extension, String str_BaseForRelPaths, String str_AssetPathPrefix) {
        str_Extension = "." + str_Extension;
        int i_ExtLen = str_Extension.length();
        Vector<Integer> v_OneExtList = new Vector<Integer>();
        String str_OriginalLink = "";
        String str_FullPath = "";
        String str_ReducedPath = "";
        int i = this.str_UCPageContents.indexOf(str_Extension);
        while (i > 0) {
            System.out.println("HotPotNetUpload.processExtension() " + str_Extension + " " + this.str_UCPageContents.substring(i, i + i_ExtLen + 5));
            if (this.str_UCPageContents.substring(i + i_ExtLen, i + i_ExtLen + 1).equals("\"") || this.str_UCPageContents.substring(i + i_ExtLen, i + i_ExtLen + 2).equals("\\\"") || this.str_UCPageContents.substring(i + i_ExtLen, i + i_ExtLen + 1).equals(")")) {
                v_OneExtList.add(new Integer(i + i_ExtLen));
                i += i_ExtLen;
            }
            if (!v_OneExtList.isEmpty()) continue;
            return;
        }
        v_OneExtList.trimToSize();
        i = v_OneExtList.size() - 1;
        while (i >= 0) {
            int i_lastChar = (Integer)v_OneExtList.get(i);
            int i_firstChar = i_lastChar - 1;
            while (!(this.str_UCPageContents.substring(i_firstChar, 1).equals("\"") || this.str_UCPageContents.substring(i_firstChar, 1).equals("=") || this.str_UCPageContents.substring(i_firstChar, 1).equals("("))) {
                --i_firstChar;
            }
            str_OriginalLink = this.str_ExPageContents.substring(i_firstChar, i_lastChar - i_firstChar);
            if (str_OriginalLink.indexOf("://") <= 0) {
                str_FullPath = this.hpNetClientApp.dlgOwner.getAbsolutePathFromRelative(str_BaseForRelPaths, str_OriginalLink);
                File t_File = new File(str_FullPath);
                if (t_File.exists()) {
                    this.v_AssetPaths.add(str_FullPath);
                }
                str_ReducedPath = str_AssetPathPrefix + this.ExtractFileName(str_FullPath);
                this.str_ExPageContents = this.str_ExPageContents.substring(0, i_firstChar - 1) + str_ReducedPath + this.str_ExPageContents.substring(i_lastChar, this.str_ExPageContents.length() + 1 - i_lastChar);
            }
            --i;
        }
    }

    void receiveAssetListFromServer(String str_FromServer) {
        int int_resultCode = 0;
        int int_ServerAssetCount = 0;
        try {
            int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
            int_ServerAssetCount = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<noofassets>", "</noofassets>", false));
        }
        catch (Exception e) {
            this.b_AssetsOK = false;
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, "Get Assets from Server returned an unknown error. Upload stopped. " + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID, "Get Assets from Server Error", 0);
            return;
        }
        if (int_resultCode == 1) {
            this.b_AssetsOK = true;
            this.v_AssetsToUpload.setSize(0);
            this.v_AssetsToConfirm.setSize(0);
            boolean b_foundOnServer = false;
            int int_AssetsToUploadCount = 0;
            if (int_ServerAssetCount != 1) {
                this.b_AssetsOK = false;
                this.hpNetClientApp.dlg_Status.setVisible(false);
                JOptionPane.showMessageDialog(this, "Get Assets from Server returned an unknown code (" + int_ServerAssetCount + ") Upload stopped. " + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID, "Get Assets from Server Unknown code", 0);
                return;
            }
            Vector v_AssetsOnServer = this.createServerAssetVector(str_FromServer);
            this.int_ExAssetCount = this.v_AssetPaths.size();
            int i = 0;
            while (i < this.int_ExAssetCount) {
                b_foundOnServer = false;
                int j = 0;
                while (j < v_AssetsOnServer.size()) {
                    if (this.ExtractFileName(this.v_AssetPaths.get(i).toString()).equals(v_AssetsOnServer.get(j).toString())) {
                        b_foundOnServer = true;
                        this.v_AssetsToConfirm.add(this.v_AssetPaths.get(i).toString());
                        break;
                    }
                    ++j;
                }
                if (!b_foundOnServer) {
                    this.v_AssetsToUpload.add(this.v_AssetPaths.get(i).toString());
                }
                ++i;
            }
            if (this.v_AssetsToConfirm.size() > 0) {
                this.dlg_ConfirmAssets = this.createConfirmAssetsDialog(this.v_AssetsToConfirm);
                this.dlg_ConfirmAssets.setVisible(false);
                if (!this.b_AssetsOK) {
                    return;
                }
            }
            if ((int_AssetsToUploadCount = this.v_AssetsToUpload.size()) > 0) {
                this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Uploading assets ...");
                this.hpNetClientApp.dlg_Status.setVisible(true);
                StringBuffer sb_Temp = new StringBuffer();
                sb_Temp.append(this.tagElement(Integer.toString(int_AssetsToUploadCount), "noofassets") + this.crlf);
                sb_Temp.append("<assetlist>");
                int i2 = 0;
                while (i2 < int_AssetsToUploadCount) {
                    sb_Temp.append("<asset>");
                    sb_Temp.append(this.ExtractFileName(this.v_AssetsToUpload.get(i2).toString()));
                    sb_Temp.append("</asset>");
                    ++i2;
                }
                sb_Temp.append("</assetlist>" + this.crlf);
                this.str_AssetSummaryToUpload = sb_Temp.toString();
            } else {
                this.str_AssetSummaryToUpload = this.tagElement("0", "noofassets") + this.crlf;
            }
        }
    }

    void receiveCreateDemoFromServer(String str_FromServer) {
        String str_PW = "";
        int int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
        if (int_resultCode == 1) {
            this.b_LoginOK = true;
            this.hpNetClientApp.hpNetInOut.str_ScriptRoot = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<script-root>", "</script-root>", false);
            this.hpNetClientApp.hpNetInOut.setScriptUrls();
            this.hpNetClientApp.hpNetInOut.str_SessionID = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<sessionid>", "</sessionid>", false);
            str_PW = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<password>", "</password>", false);
            this.hpNetClientApp.dlg_Login.rb_CreateDemoAcct.setSelected(false);
            this.hpNetClientApp.dlg_Login.rb_UseLogin.setSelected(true);
            this.hpNetClientApp.dlg_Login.tf_HotPotNetPassword.setText(str_PW);
            JOptionPane.showMessageDialog(this, "Your hotpotatoes.net password is " + str_PW);
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false));
            this.hpNetClientApp.dlg_Status.setVisible(true);
        } else {
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, "Unknown error " + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID);
        }
        if (this.b_LoginOK) {
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Doing setup with hotpotatoes.net server...");
            this.hpNetClientApp.dlg_Status.setVisible(true);
            this.preambleUI();
        }
    }

    void receiveLoginFromServer(String str_FromServer) {
        int int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
        if (int_resultCode == 1) {
            this.b_LoginOK = true;
            this.hpNetClientApp.hpNetInOut.str_ScriptRoot = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<script-root>", "</script-root>", false);
            this.hpNetClientApp.hpNetInOut.setScriptUrls();
            this.hpNetClientApp.hpNetInOut.str_SessionID = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<sessionid>", "</sessionid>", false);
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false));
            this.hpNetClientApp.dlg_Status.setVisible(true);
            this.setVisible(false);
        } else if (int_resultCode == 2) {
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID);
        } else {
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, "Unknown error " + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID);
        }
        if (this.b_LoginOK) {
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Doing setup with hotpotatoes.net server...");
            this.hpNetClientApp.dlg_Status.setVisible(true);
            this.preambleUI();
        }
    }

    void receivePreambleFromServer(String str_FromServer) {
        int int_resultCode = 0;
        this.int_previousResults = -1;
        this.str_PreviousClass = "";
        try {
            int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
        }
        catch (Exception e) {
            int_resultCode = 0;
        }
        this.hpNetClientApp.dlg_Upload.cb_MergeResults.setEnabled(false);
        switch (int_resultCode) {
            case 0: {
                this.hpNetClientApp.dlg_Status.setVisible(false);
                JOptionPane.showMessageDialog(this, "Upload Preamble returned an unkwown error. Upload stopped. " + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID, "Upload Preamble Error", 0);
                break;
            }
            case 1: {
                this.b_PreambleOK = true;
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this, "Upload Preamble detected an error with login information. Upload stopped. Please try logging in again.", "Upload Preamble Error", 0);
                break;
            }
            case 3: {
                this.hpNetClientApp.hpNetInOut.str_HousekeepingScript = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<url-to-open>", "</url-to-open>", false);
                this.hpNetClientApp.hpNetInOut.setScriptUrls();
                int int_selectedValue = JOptionPane.showConfirmDialog(null, "Upload Preamble detected that Housekeeping is needed on your account before upload can occur. Upload stopped. Do you want to do houskeeping now? ", "Housekeeping Needed", 0, 3);
                if (int_selectedValue != 0) break;
                this.hpNetClientApp.dlgOwner.viewAbsolutePathOrURLInBrowser(this.hpNetClientApp.hpNetInOut.str_HousekeepingURL);
                break;
            }
            case 4: {
                this.int_previousResults = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<results>", "</results>", false));
                this.str_PreviousClass = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<current-class>", "</current-class>", false);
                int int_selectedValue = JOptionPane.showConfirmDialog(null, "Upload Preamble detected that an exercise with same name already exists on the server. Do you want to overwrite the existing exercise? ", "Exercise Already Exists", 0, 3);
                if (int_selectedValue == 1) {
                    int_selectedValue = JOptionPane.showConfirmDialog(null, "Housekeeping is needed on your account before upload can occur. Upload stopped. Do you want to do houskeeping now? ", "Housekeeping Needed", 0, 3);
                    if (int_selectedValue != 0) break;
                    this.hpNetClientApp.dlgOwner.viewAbsolutePathOrURLInBrowser(this.hpNetClientApp.hpNetInOut.str_HousekeepingURL);
                    break;
                }
                int_resultCode = 1;
                if (this.int_previousResults <= 0) break;
                this.hpNetClientApp.dlg_Upload.cb_MergeResults.setEnabled(true);
                int_selectedValue = JOptionPane.showConfirmDialog(null, "There are results in the database for the old exercise. Do you want to keep those (\"yes\") or discard them (\"no\")", "Results Already Exist", 0, 3);
                if (int_selectedValue == 0) {
                    this.hpNetClientApp.dlg_Upload.cb_MergeResults.setSelected(true);
                    break;
                }
                this.hpNetClientApp.dlg_Upload.cb_MergeResults.setSelected(false);
                break;
            }
            case 97: {
                JOptionPane.showMessageDialog(this, "Upload Preample returned a Feature Not Supported error. Upload stopped.", "Upload Preamble error", 0);
                break;
            }
            case 98: {
                JOptionPane.showMessageDialog(this, "Upload Preample returned a Language Not Supported error. Upload stopped.", "Upload Preamble error", 0);
                break;
            }
            case 99: {
                JOptionPane.showMessageDialog(this, "Upload Preample returned a Session Expired error. Upload stopped. Please try logging in again.", "Upload Preamble error", 0);
                break;
            }
            default: {
                this.hpNetClientApp.dlg_Status.setVisible(false);
                JOptionPane.showMessageDialog(this, "Upload Preamble returned an unkwown error. Upload stopped. " + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID);
            }
        }
        if (int_resultCode != 1) {
            this.hpNetClientApp.dlg_Status.setVisible(false);
            return;
        }
        String responseMessidge = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false);
        this.hpNetClientApp.hpNetInOut.str_UploadScript = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<uploadurl>", "</uploadurl>", false);
        this.hpNetClientApp.hpNetInOut.setScriptUrls();
        System.out.println("HotPotNetLogin.receivePreambleFromServer : " + str_FromServer);
        Vector<String> v_Temp = new Vector<String>();
        String str_ListOfClassesFromServer = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<classlist>", "</classlist>", false);
        int i = 0;
        while (i < 100) {
            String str_ThisClass = this.hpNetClientApp.hpNetInOut.getTextBetween(str_ListOfClassesFromServer, "<class>", "</class>", false);
            if (str_ThisClass.equals(str_ListOfClassesFromServer)) break;
            int int_indexOfNextSearch = str_ListOfClassesFromServer.indexOf("</class>") + "</class>".length();
            v_Temp.add(str_ThisClass);
            str_ListOfClassesFromServer = str_ListOfClassesFromServer.substring(int_indexOfNextSearch);
            ++i;
        }
        if (v_Temp.size() < 1) {
            v_Temp.add("no classes available");
        }
        this.hpNetClientApp.dlg_Upload.updateComboBox(v_Temp);
        this.assetLists();
        if (this.b_AssetsOK) {
            this.hpNetClientApp.dlg_Upload.setVisible(true);
        }
    }

    String tagElement(String str_Contents, String str_Tag) {
        return "<" + str_Tag + ">" + str_Contents + "</" + str_Tag + ">";
    }

    void updateLoginItems(boolean b_in) {
        this.lbl_HotPotNetPassword.setEnabled(b_in);
        this.tf_HotPotNetPassword.setEnabled(b_in);
        this.cb_SaveHotPotNetPassword.setEnabled(b_in);
    }

    void updateProxyItems(boolean b_in) {
        this.lbl_ProxyUserName.setEnabled(b_in);
        this.tf_ProxyUserName.setEnabled(b_in);
        this.lbl_ProxyPassword.setEnabled(b_in);
        this.tf_ProxyPassword.setEnabled(b_in);
        this.lbl_ProxyServer.setEnabled(b_in);
        this.tf_ProxyServer.setEnabled(b_in);
        this.lbl_ProxyPort.setEnabled(b_in);
        this.tf_ProxyPort.setEnabled(b_in);
        this.cb_ProxyUseBasicAuthentication.setEnabled(b_in);
        this.lbl_ProxyUserName.setVisible(b_in);
        this.tf_ProxyUserName.setVisible(b_in);
        this.lbl_ProxyPassword.setVisible(b_in);
        this.tf_ProxyPassword.setVisible(b_in);
        this.lbl_ProxyServer.setVisible(b_in);
        this.tf_ProxyServer.setVisible(b_in);
        this.lbl_ProxyPort.setVisible(b_in);
        this.tf_ProxyPort.setVisible(b_in);
        this.cb_ProxyUseBasicAuthentication.setVisible(b_in);
    }
}

