/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

final class SplashScreen
extends Frame
implements Runnable {
    private Image fImage;
    private String fImageId;
    private MediaTracker fMediaTracker;

    SplashScreen(String aImageId) {
        this.fImageId = aImageId;
    }

    private void initImageAndTracker() {
        this.fMediaTracker = new MediaTracker(this);
        this.fImage = Toolkit.getDefaultToolkit().createImage(this.fImageId);
    }

    public void run() {
    }

    void splash() {
        this.initImageAndTracker();
        this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null));
        this.fMediaTracker.addImage(this.fImage, 0);
        try {
            this.fMediaTracker.waitForID(0);
            SplashWindow splashWindow = new SplashWindow(this, this.fImage);
        }
        catch (InterruptedException ie) {
            System.out.println("Cannot track image load.");
        }
    }

    private class SplashWindow
    extends Window {
        private Image fImage;

        SplashWindow(Frame aParent, Image aImage) {
            super(aParent);
            this.fImage = aImage;
            this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null));
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle window = this.getBounds();
            this.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
            this.setVisible(true);
        }

        public void paint(Graphics graphics) {
            if (this.fImage != null) {
                graphics.drawImage(this.fImage, 0, 0, this);
            }
        }
    }
}

