/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import hotpot6.GenericSaxModel;
import hotpot6.HotPotPrefsSaxHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HotPotPrefsSaxModel
extends GenericSaxModel {
    File configFile;
    File configFileDefault;
    String hotpot6PrefsPath;
    File hotpotPrefsFile;
    File hotpotPrefsFileDefault;
    HotPotPrefsSaxHandler hotpotPrefsSaxHandler;
    Hashtable ht_PrefsGlobal = new Hashtable();
    Hashtable ht_PrefsJCloze;
    Hashtable ht_PrefsJCross;
    Hashtable ht_PrefsJMatch;
    Hashtable ht_PrefsJMix;
    Hashtable ht_PrefsJQuiz;
    Hashtable ht_PrefsMasher;
    Hashtable ht_PrefsSpecific = new Hashtable();
    int int_temp;
    File interfaceFile;
    File interfaceFileDefault;
    File interfaceFolderDefault;
    File recentDataFolder;
    File recentExerciseFolder;
    File sourceFolder;
    File sourceFolderDefault;
    String str_Temp;
    Vector v_RecentDataFiles;
    Vector v_RecentProjectFiles;
    XMLReader xmlReader;

    public HotPotPrefsSaxModel(String potXmlTag, boolean b_updatePrefsPathInDefaultFromProjectPathsWd) {
        this.ht_PrefsJMatch = new Hashtable();
        this.ht_PrefsJQuiz = new Hashtable();
        this.ht_PrefsJCloze = new Hashtable();
        this.ht_PrefsJCross = new Hashtable();
        this.ht_PrefsJMix = new Hashtable();
        this.ht_PrefsMasher = new Hashtable();
        this.v_RecentDataFiles = new Vector();
        this.v_RecentProjectFiles = new Vector();
        this.hotpot6PrefsPath = System.getProperty("user.home") + System.getProperty("file.separator") + "Library" + System.getProperty("file.separator") + "Preferences" + System.getProperty("file.separator") + "com.halfbakedsoftware" + System.getProperty("file.separator");
        this.hotpotPrefsFile = new File(this.hotpot6PrefsPath + "hotpot6prefs.xml");
        this.hotpotPrefsFileDefault = new File(this.hotpot6PrefsPath + "hotpot6prefs.xml");
        this.interfaceFileDefault = new File(this.hotpotAppPath + "interface" + System.getProperty("file.separator") + "JHP6English.xml");
        this.interfaceFolderDefault = new File(this.hotpotAppPath + "interface");
        this.configFileDefault = new File(this.hotpotAppPath + "config" + System.getProperty("file.separator") + "English6.cfg");
        this.sourceFolderDefault = new File(this.hotpotAppPath + "source" + System.getProperty("file.separator"));
        this.recentExerciseFolder = new File(System.getProperty("user.home") + System.getProperty("file.separator"));
        this.recentDataFolder = new File(System.getProperty("user.home") + System.getProperty("file.separator"));
        if (!this.hotpotPrefsFile.exists()) {
            this.createPrefsFile();
        }
        this.int_temp = this.initPrefsModel(this.hotpotPrefsFileDefault, potXmlTag);
        if (!b_updatePrefsPathInDefaultFromProjectPathsWd) {
            this.useCurrentPrefFile(potXmlTag);
            this.fromPrefFileToPaths();
        }
    }

    public HotPotPrefsSaxModel(String potXmlTag) {
        this(potXmlTag, false);
    }

    boolean createPrefsFile() {
        StringBuffer sb_Temp = new StringBuffer();
        sb_Temp.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + this.crlf);
        sb_Temp.append("<v6>" + this.crlf);
        sb_Temp.append("<global>" + this.crlf);
        sb_Temp.append("<prefs-path-file></prefs-path-file>" + this.crlf);
        sb_Temp.append("<input-font-face>Lucida Grande,Arial</input-font-face>" + this.crlf);
        sb_Temp.append("<input-font-size>14</input-font-size>" + this.crlf);
        sb_Temp.append("<interface-font-face>Lucida Grande,Arial</interface-font-face>" + this.crlf);
        sb_Temp.append("<interface-font-size>12</interface-font-size>" + this.crlf);
        sb_Temp.append("<read-config-with-data>1</read-config-with-data>" + this.crlf);
        sb_Temp.append("<show-tooltips>1</show-tooltips>" + this.crlf);
        sb_Temp.append("<user-interface-beginner>1</user-interface-beginner>" + this.crlf);
        sb_Temp.append("<linux-browser>Mozilla</linux-browser>" + this.crlf);
        sb_Temp.append("</global>" + this.crlf);
        sb_Temp.append(this.createPrefsPotBlock("jcloze"));
        sb_Temp.append(this.createPrefsPotBlock("jcross"));
        sb_Temp.append(this.createPrefsPotBlock("jmatch"));
        sb_Temp.append(this.createPrefsPotBlock("jmix"));
        sb_Temp.append(this.createPrefsPotBlock("jquiz"));
        sb_Temp.append(this.createPrefsPotBlock("masher"));
        sb_Temp.append("</v6>" + this.crlf);
        File parent = new File(this.hotpotPrefsFile.getParent());
        boolean newRegWritten = parent.mkdirs();
        return this.writeStringToFile(sb_Temp.toString(), this.hotpotPrefsFile);
    }

    String createPrefsPotBlock(String potXmlTag) {
        StringBuffer sb_PotBlock = new StringBuffer();
        sb_PotBlock.append("<" + potXmlTag + ">" + this.crlf);
        if (potXmlTag.equals("masher")) {
            sb_PotBlock.append("<interface-file></interface-file>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-1></recent-data-file-1>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-2></recent-data-file-2>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-3></recent-data-file-3>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-4></recent-data-file-4>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-5></recent-data-file-5>" + this.crlf);
        } else {
            sb_PotBlock.append("<interface-file></interface-file>" + this.crlf);
            sb_PotBlock.append("<config-file></config-file>" + this.crlf);
            sb_PotBlock.append("<source-folder></source-folder>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-1></recent-data-file-1>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-2></recent-data-file-2>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-3></recent-data-file-3>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-4></recent-data-file-4>" + this.crlf);
            sb_PotBlock.append("<recent-data-file-5></recent-data-file-5>" + this.crlf);
            sb_PotBlock.append("<recent-exercise-folder></recent-exercise-folder>" + this.crlf);
            if (potXmlTag.equals("jmix")) {
                sb_PotBlock.append("<alt-sentence-warn>0</alt-sentence-warn>" + this.crlf);
            }
            if (potXmlTag.equals("jcross")) {
                sb_PotBlock.append("<case-sensitive-grid>0</case-sensitive-grid>" + this.crlf);
            }
        }
        sb_PotBlock.append("</" + potXmlTag + ">" + this.crlf);
        return sb_PotBlock.toString();
    }

    void fromPrefFileToPaths() {
        String str_Default = "";
        String str_Temp = "";
        str_Default = System.getProperty("user.home") + System.getProperty("file.separator");
        str_Temp = this.getPrefsSaxValue("specific", "recent-exercise-folder", str_Default);
        this.recentExerciseFolder = new File(str_Temp);
        if (!this.recentExerciseFolder.exists() && !str_Temp.equals(str_Default)) {
            this.recentExerciseFolder = new File(str_Default);
            if (this.recentExerciseFolder.exists()) {
                // empty if block
            }
        }
        str_Default = System.getProperty("user.home") + System.getProperty("file.separator");
        str_Temp = this.getPrefsSaxValue("specific", "recent-data-folder", str_Default);
        this.recentDataFolder = new File(str_Temp);
        if (!this.recentDataFolder.exists() && !str_Temp.equals(str_Default)) {
            this.recentDataFolder = new File(str_Default);
            if (this.recentDataFolder.exists()) {
                // empty if block
            }
        }
        str_Default = System.getProperty("user.home") + System.getProperty("file.separator") + "unnamed";
        int i = 0;
        while (i < 5) {
            str_Temp = this.getPrefsSaxValue("specific", "recent-data-file-" + (i + 1), str_Default);
            if (str_Temp.length() < 2) {
                str_Temp = "";
            }
            this.v_RecentDataFiles.add(i, new File(str_Temp));
            str_Temp = this.getPrefsSaxValue("masher", "recent-data-file-" + (i + 1), str_Default);
            if (str_Temp.length() < 2) {
                str_Temp = "";
            }
            this.v_RecentProjectFiles.add(i, new File(str_Temp));
            ++i;
        }
        str_Default = this.hotpot6PrefsPath + "hotpot6prefs.xml";
        str_Temp = this.getPrefsSaxValue("global", "prefs-path-file", str_Default);
        this.hotpotPrefsFile = new File(str_Temp);
        if (!this.hotpotPrefsFile.exists() && !str_Temp.equals(str_Default)) {
            this.hotpotPrefsFile = new File(str_Default);
            if (this.hotpotPrefsFile.exists()) {
                // empty if block
            }
        }
        str_Default = this.hotpotAppPath + "interface" + System.getProperty("file.separator") + "JHP6English.xml";
        str_Temp = this.getPrefsSaxValue("specific", "interface-file", str_Default);
        this.interfaceFile = new File(str_Temp);
        if (!this.interfaceFile.exists() && !str_Temp.equals(str_Default)) {
            this.interfaceFile = new File(str_Default);
            if (this.interfaceFile.exists()) {
                // empty if block
            }
        }
        str_Default = this.hotpotAppPath + "config" + System.getProperty("file.separator") + "English6.cfg";
        str_Temp = this.getPrefsSaxValue("specific", "config-file", str_Default);
        this.configFile = new File(str_Temp);
        if (!this.configFile.exists() && !str_Temp.equals(str_Default)) {
            this.configFile = new File(str_Default);
            if (this.configFile.exists()) {
                // empty if block
            }
        }
        str_Default = this.hotpotAppPath + "source" + System.getProperty("file.separator");
        str_Temp = this.getPrefsSaxValue("specific", "source-folder", str_Default);
        this.sourceFolder = new File(str_Temp);
        if (!this.sourceFolder.exists() && !str_Temp.equals(str_Default)) {
            this.sourceFolder = new File(str_Default);
            if (this.sourceFolder.exists()) {
                // empty if block
            }
        }
    }

    public String getInterfaceFilePath() {
        if (this.interfaceFile instanceof File) {
            return this.interfaceFile.getPath();
        }
        return "";
    }

    public boolean getPrefsSaxBoolean(String keyPath, String keyName, String defaultValue) {
        return this.strToBool(this.getPrefsSaxValue(keyPath, keyName, defaultValue));
    }

    public String getPrefsSaxValue(String keyPath, String keyName, String defaultValue) {
        String str_Out = "";
        if (keyPath.indexOf("global") >= 0) {
            if (this.ht_PrefsGlobal.containsKey(keyName)) {
                str_Out = (String)this.ht_PrefsGlobal.get(keyName);
            } else {
                this.ht_PrefsGlobal.put(keyName, defaultValue);
            }
        } else if (this.ht_PrefsSpecific.containsKey(keyName)) {
            str_Out = (String)this.ht_PrefsSpecific.get(keyName);
        } else {
            this.ht_PrefsSpecific.put(keyName, defaultValue);
        }
        if (str_Out.equals("")) {
            str_Out = defaultValue;
        }
        return str_Out;
    }

    public int initPrefsModel(File prefsFile, String potXmlTag) {
        String str_tempKey = "";
        String str_tempValue = "";
        String str_FileText = "";
        String str_Temp = "";
        String str_FileOneParse = "";
        StringReader sr_ParsedOnce = null;
        try {
            str_FileText = GenericSaxModel.readFile(prefsFile);
            str_FileOneParse = str_FileOneParse + this.replaceStuff(str_FileText, "&amp;", "&");
        }
        catch (IOException ioe) {
            this.writeErrorReport("HotPotPrefsSaxModel.initPrefsModel().readFile()" + this.crlf + ioe.getMessage() + this.crlf + ioe.toString());
            return 1;
        }
        try {
            sr_ParsedOnce = new StringReader(str_FileOneParse);
            InputSource inputSource = new InputSource(sr_ParsedOnce);
            inputSource.setEncoding(this.charEncoding);
            this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.hotpotPrefsSaxHandler = new HotPotPrefsSaxHandler();
            this.xmlReader.setContentHandler(this.hotpotPrefsSaxHandler);
            this.xmlReader.parse(inputSource);
            this.ht_PrefsGlobal.putAll(this.hotpotPrefsSaxHandler.ht_PrefsGlobal);
            this.ht_PrefsJCloze.putAll(this.hotpotPrefsSaxHandler.ht_PrefsJCloze);
            this.ht_PrefsJCross.putAll(this.hotpotPrefsSaxHandler.ht_PrefsJCross);
            this.ht_PrefsJMatch.putAll(this.hotpotPrefsSaxHandler.ht_PrefsJMatch);
            this.ht_PrefsJMix.putAll(this.hotpotPrefsSaxHandler.ht_PrefsJMix);
            this.ht_PrefsJQuiz.putAll(this.hotpotPrefsSaxHandler.ht_PrefsJQuiz);
            this.ht_PrefsMasher.putAll(this.hotpotPrefsSaxHandler.ht_PrefsMasher);
            this.hotpotPrefsSaxHandler.ht_PrefsGlobal.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsJCloze.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsJCross.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsJMatch.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsJMix.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsJQuiz.clear();
            this.hotpotPrefsSaxHandler.ht_PrefsMasher.clear();
            Enumeration e = this.ht_PrefsGlobal.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsGlobal.get(str_tempKey));
                this.ht_PrefsGlobal.put(str_tempKey, str_tempValue);
            }
            Enumeration e2 = this.ht_PrefsJCloze.keys();
            while (e2.hasMoreElements()) {
                str_tempKey = (String)e2.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsJCloze.get(str_tempKey));
                this.ht_PrefsJCloze.put(str_tempKey, str_tempValue);
            }
            Enumeration e3 = this.ht_PrefsJCross.keys();
            while (e3.hasMoreElements()) {
                str_tempKey = (String)e3.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsJCross.get(str_tempKey));
                this.ht_PrefsJCross.put(str_tempKey, str_tempValue);
            }
            Enumeration e4 = this.ht_PrefsJMatch.keys();
            while (e4.hasMoreElements()) {
                str_tempKey = (String)e4.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsJMatch.get(str_tempKey));
                this.ht_PrefsJMatch.put(str_tempKey, str_tempValue);
            }
            Enumeration e5 = this.ht_PrefsJMix.keys();
            while (e5.hasMoreElements()) {
                str_tempKey = (String)e5.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsJMix.get(str_tempKey));
                this.ht_PrefsJMix.put(str_tempKey, str_tempValue);
            }
            Enumeration e6 = this.ht_PrefsJQuiz.keys();
            while (e6.hasMoreElements()) {
                str_tempKey = (String)e6.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsJQuiz.get(str_tempKey));
                this.ht_PrefsJQuiz.put(str_tempKey, str_tempValue);
            }
            Enumeration e7 = this.ht_PrefsMasher.keys();
            while (e7.hasMoreElements()) {
                str_tempKey = (String)e7.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_PrefsMasher.get(str_tempKey));
                this.ht_PrefsMasher.put(str_tempKey, str_tempValue);
            }
            this.ht_PrefsSpecific = potXmlTag == "jcloze" ? this.ht_PrefsJCloze : (potXmlTag == "jcross" ? this.ht_PrefsJCross : (potXmlTag == "jmatch" ? this.ht_PrefsJMatch : (potXmlTag == "jmix" ? this.ht_PrefsJMix : (potXmlTag == "jquiz" ? this.ht_PrefsJQuiz : (potXmlTag == "masher" ? this.ht_PrefsMasher : this.ht_PrefsJQuiz)))));
            return 0;
        }
        catch (IOException ioe) {
            this.writeErrorReport("HotPotPrefsSaxModel.initPrefsModel()" + this.crlf + ioe.toString());
            return 1;
        }
        catch (SAXException saxe) {
            this.writeErrorReport("HotPotPrefsSaxModel.initPrefsModel()" + this.crlf + saxe.toString());
            return 2;
        }
    }

    public boolean putPrefsSaxBoolean(String keyPath, String keyName, boolean valueBoolean) {
        this.putPrefsSaxValue(keyPath, keyName, this.boolToStr(valueBoolean));
        return true;
    }

    public boolean putPrefsSaxValue(String keyPath, String keyName, String valueText) {
        boolean b_Out = true;
        if (keyPath.indexOf("global") >= 0) {
            this.ht_PrefsGlobal.put(keyName, valueText);
        } else {
            this.ht_PrefsSpecific.put(keyName, valueText);
        }
        return b_Out;
    }

    public String toXml() {
        String str_tempValue;
        String str_tempKey;
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append("<v6>" + this.crlf);
        sb_Out.append("<global>" + this.crlf);
        Enumeration e = this.ht_PrefsGlobal.keys();
        while (e.hasMoreElements()) {
            str_tempKey = (String)e.nextElement();
            str_tempValue = (String)this.ht_PrefsGlobal.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</global>" + this.crlf);
        sb_Out.append("<jcloze>" + this.crlf);
        Enumeration e2 = this.ht_PrefsJCloze.keys();
        while (e2.hasMoreElements()) {
            str_tempKey = (String)e2.nextElement();
            str_tempValue = (String)this.ht_PrefsJCloze.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</jcloze>" + this.crlf);
        sb_Out.append("<jcross>" + this.crlf);
        Enumeration e3 = this.ht_PrefsJCross.keys();
        while (e3.hasMoreElements()) {
            str_tempKey = (String)e3.nextElement();
            str_tempValue = (String)this.ht_PrefsJCross.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</jcross>" + this.crlf);
        sb_Out.append("<jmatch>" + this.crlf);
        Enumeration e4 = this.ht_PrefsJMatch.keys();
        while (e4.hasMoreElements()) {
            str_tempKey = (String)e4.nextElement();
            str_tempValue = (String)this.ht_PrefsJMatch.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</jmatch>" + this.crlf);
        sb_Out.append("<jmix>" + this.crlf);
        Enumeration e5 = this.ht_PrefsJMix.keys();
        while (e5.hasMoreElements()) {
            str_tempKey = (String)e5.nextElement();
            str_tempValue = (String)this.ht_PrefsJMix.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</jmix>" + this.crlf);
        sb_Out.append("<jquiz>" + this.crlf);
        Enumeration e6 = this.ht_PrefsJQuiz.keys();
        while (e6.hasMoreElements()) {
            str_tempKey = (String)e6.nextElement();
            str_tempValue = (String)this.ht_PrefsJQuiz.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</jquiz>" + this.crlf);
        sb_Out.append("<masher>" + this.crlf);
        Enumeration e7 = this.ht_PrefsMasher.keys();
        while (e7.hasMoreElements()) {
            str_tempKey = (String)e7.nextElement();
            str_tempValue = (String)this.ht_PrefsMasher.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</masher>" + this.crlf);
        sb_Out.append("</v6>" + this.crlf);
        String str_Out = sb_Out.toString();
        return str_Out;
    }

    void useCurrentPrefFile(String potXmlTag) {
        if (this.hotpotPrefsFile.canRead()) {
            File f_Temp;
            this.str_Temp = this.getPrefsSaxValue("global", "prefs-path-file", this.hotpotPrefsFileDefault.getPath());
            if (!this.str_Temp.equals(this.hotpotPrefsFileDefault.getPath()) && (f_Temp = new File(this.str_Temp)).exists() && f_Temp.canRead()) {
                this.hotpotPrefsFile = f_Temp;
                this.int_temp = this.initPrefsModel(this.hotpotPrefsFile, potXmlTag);
            }
        }
    }

    public boolean writeMeToFile() {
        boolean b_temp = false;
        String str_Temp = this.xmlHeader + this.crlf + this.toXml();
        if (this.writeStringToFile(str_Temp, this.hotpotPrefsFile)) {
            b_temp = true;
        } else {
            this.writeErrorReport("HotPotPrefsSaxModel.writeMeToFile() Failed to write Preferences file.");
        }
        return b_temp;
    }
}

