/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.JDomTreeObject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;

public class JDomTreePanel
extends JPanel {
    ResourceBridge rb;
    TreeSelectionListener treeSelectionListener;
    ListSelectionListener listSelectionListener;
    JDomTreeObject current;
    DefaultMutableTreeNode currentNode;
    FileSystem fs;
    String fileName;
    Element element;
    private DefaultMutableTreeNode clip;
    private boolean cut;
    private JButton copyBtn;
    private JButton cutBtn;
    private JButton delAttributeBtn;
    private JButton delElementBtn;
    private JButton newAttributeBtn;
    private JButton newElementBtn;
    private JButton pasteBtn;
    private JButton saveBtn;
    private JTable table;
    private JTree tree;

    public JDomTreePanel(Element element, ResourceBridge resourceBridge, FileSystem fileSystem, String string) {
        this.rb = resourceBridge;
        this.fs = fileSystem;
        this.fileName = string;
        this.element = element;
        this.initComponents();
        this.initMembers();
        this.tree.setModel(new DefaultTreeModel(JDomTreeObject.processNode(null, element, resourceBridge.getOptions())));
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    private void initMembers() {
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JDomTreePanel.this.checkEnabled();
            }
        };
        this.listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JDomTreePanel.this.delAttributeBtn.setEnabled(listSelectionEvent.getFirstIndex() >= 0);
                }
            }
        };
    }

    private void checkEnabled() {
        this.current = null;
        this.currentNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.currentNode == null) {
            this.newElementBtn.setEnabled(false);
            this.delElementBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.cutBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
        } else {
            this.current = (JDomTreeObject)this.currentNode.getUserObject();
            this.setTableModel();
            String string = this.current.getElement().getText();
            boolean bl = string == null || string.length() == 0;
            boolean bl2 = this.current.getElement().isRootElement();
            this.newElementBtn.setEnabled(bl);
            this.delElementBtn.setEnabled(!bl2);
            this.copyBtn.setEnabled(!bl2);
            this.cutBtn.setEnabled(!bl2);
            this.pasteBtn.setEnabled(this.clip != null && bl && this.clip != this.currentNode && !this.clip.isNodeChild(this.currentNode));
        }
    }

    private void setTableModel() {
        AbstractTableModel abstractTableModel = this.current;
        if (abstractTableModel == null) {
            abstractTableModel = new DefaultTableModel();
        }
        this.table.setModel(abstractTableModel);
        abstractTableModel.fireTableStructureChanged();
        this.newAttributeBtn.setEnabled(this.current != null);
        this.delAttributeBtn.setEnabled(false);
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.tree = new JTree();
        JPanel jPanel2 = new JPanel();
        this.newElementBtn = new JButton();
        this.delElementBtn = new JButton();
        this.copyBtn = new JButton();
        this.pasteBtn = new JButton();
        this.cutBtn = new JButton();
        this.saveBtn = new JButton();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        JPanel jPanel4 = new JPanel();
        this.newAttributeBtn = new JButton();
        this.delAttributeBtn = new JButton();
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jScrollPane.setMinimumSize(new Dimension(150, 22));
        jScrollPane.setViewportView(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        this.newElementBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/new_element.gif")));
        this.newElementBtn.setToolTipText(this.rb.getMsg("XML_NEW_ELEMENT"));
        this.newElementBtn.setEnabled(false);
        this.newElementBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.newElementBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.newElementBtn);
        this.delElementBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.delElementBtn.setToolTipText(this.rb.getMsg("XML_DEL_ELEMENT"));
        this.delElementBtn.setEnabled(false);
        this.delElementBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.delElementBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.delElementBtn);
        this.copyBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/copy.gif")));
        this.copyBtn.setToolTipText(this.rb.getMsg("COPY"));
        this.copyBtn.setEnabled(false);
        this.copyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.copyBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.copyBtn);
        this.pasteBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/paste.gif")));
        this.pasteBtn.setToolTipText(this.rb.getMsg("PASTE"));
        this.pasteBtn.setEnabled(false);
        this.pasteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.pasteBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.pasteBtn);
        this.cutBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/cut.gif")));
        this.cutBtn.setToolTipText(this.rb.getMsg("CUT"));
        this.cutBtn.setEnabled(false);
        this.cutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.cutBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.cutBtn);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_save.gif")));
        this.saveBtn.setToolTipText(this.rb.getMsg("FILE_SAVE"));
        this.saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.saveBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.saveBtn);
        jPanel.add((Component)jPanel2, "South");
        jSplitPane.setLeftComponent(jPanel);
        jPanel3.setLayout(new BorderLayout());
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        jScrollPane2.setViewportView(this.table);
        jPanel3.add((Component)jScrollPane2, "Center");
        this.newAttributeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/new_attribute.gif")));
        this.newAttributeBtn.setToolTipText(this.rb.getMsg("XML_NEW_ATTRIBUTE"));
        this.newAttributeBtn.setEnabled(false);
        this.newAttributeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.newAttributeBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(this.newAttributeBtn);
        this.delAttributeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.delAttributeBtn.setToolTipText(this.rb.getMsg("XML_DEL_ATTRIBUTE"));
        this.delAttributeBtn.setEnabled(false);
        this.delAttributeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDomTreePanel.this.delAttributeBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(this.delAttributeBtn);
        jPanel3.add((Component)jPanel4, "South");
        jSplitPane.setRightComponent(jPanel3);
        this.add((Component)jSplitPane, "Center");
    }

    private void cutBtnActionPerformed(ActionEvent actionEvent) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            this.clip = this.currentNode;
            this.cut = true;
            this.checkEnabled();
        }
    }

    private void pasteBtnActionPerformed(ActionEvent actionEvent) {
        if (this.currentNode != null && this.current != null && this.clip != null && this.clip != this.currentNode && !this.clip.isNodeChild(this.currentNode)) {
            Element element = ((JDomTreeObject)this.clip.getUserObject()).getElement();
            Element element2 = (Element)element.clone();
            this.current.getElement().addContent(element2);
            DefaultMutableTreeNode defaultMutableTreeNode = JDomTreeObject.processNode(this.currentNode, element2, this.rb.getOptions());
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.currentNode);
            if (this.cut) {
                element.detach();
                ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(this.clip);
                this.clip = null;
            }
            this.setTableModel();
            this.checkEnabled();
        }
    }

    private void copyBtnActionPerformed(ActionEvent actionEvent) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            this.clip = this.currentNode;
            this.cut = false;
            this.checkEnabled();
        }
    }

    private void saveBtnActionPerformed(ActionEvent actionEvent) {
        if (this.fs == null) {
            this.fs = new FileSystem(this.rb);
        }
        int[] nArray = new int[]{0};
        String string = this.fs.chooseFile(this.fileName + ".jclic", true, nArray, this.rb.getOptions(), null, this, false);
        if (string != null) {
            String string2 = this.fs.getFullFileNamePath(string);
            try {
                FileOutputStream fileOutputStream = this.fs.createSecureFileOutputStream(string2);
                JDomUtility.saveDocument((OutputStream)fileOutputStream, new Document(this.element));
                fileOutputStream.close();
            }
            catch (Exception exception) {
                this.rb.getOptions().getMessages().showErrorWarning((Component)this, "FILE_ERR_SAVING", string2, exception, null);
            }
        }
    }

    private void delElementBtnActionPerformed(ActionEvent actionEvent) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            if (this.clip == this.currentNode) {
                this.clip = null;
            }
            this.current.getElement().detach();
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(this.currentNode);
            this.setTableModel();
        }
    }

    private void newElementBtnActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.currentNode != null && this.current != null && ((string = this.current.getElement().getText()) == null || string.length() == 0)) {
            String string2;
            JComponent[] jComponentArray = new JTextField[]{new JTextField()};
            Dimension dimension = new Dimension(100, 20);
            for (int i = 0; i < jComponentArray.length; ++i) {
                jComponentArray[i].setPreferredSize(dimension);
            }
            String[] stringArray = new String[]{"XML_NAME"};
            if (this.rb.getOptions().getMessages().showInputDlg((Component)this, null, stringArray, jComponentArray, "XML_NEW_ELEMENT") && (string2 = ((JTextComponent)jComponentArray[0]).getText()) != null && string2.length() > 0) {
                Element element = new Element(string2);
                this.current.getElement().addContent(element);
                JDomTreeObject jDomTreeObject = new JDomTreeObject(element, this.rb.getOptions());
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(jDomTreeObject);
                ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(defaultMutableTreeNode, this.currentNode, this.currentNode.getChildCount());
                this.setTableModel();
            }
        }
    }

    private void delAttributeBtnActionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.current != null && (n = this.table.getSelectedRow()) >= 0) {
            if (n == 0) {
                List list = this.current.getElement().getContent();
                Iterator iterator = list.iterator();
                Vector vector = new Vector();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Text)) continue;
                    vector.add(e);
                }
                list.removeAll(vector);
            } else {
                String string = (String)this.current.getValueAt(n, 0);
                if (string != null) {
                    this.current.getElement().removeAttribute(string);
                }
            }
            this.setTableModel();
        }
    }

    private void newAttributeBtnActionPerformed(ActionEvent actionEvent) {
        if (this.current != null) {
            JComponent[] jComponentArray = new JTextField[]{new JTextField(), new JTextField()};
            Dimension dimension = new Dimension(100, 20);
            for (int i = 0; i < jComponentArray.length; ++i) {
                jComponentArray[i].setPreferredSize(dimension);
            }
            String[] stringArray = new String[]{"XML_ATTRIBUTE", "XML_VALUE"};
            if (this.rb.getOptions().getMessages().showInputDlg((Component)this, null, stringArray, jComponentArray, "XML_NEW_ATTRIBUTE")) {
                String string = ((JTextComponent)jComponentArray[0]).getText();
                String string2 = ((JTextComponent)jComponentArray[1]).getText();
                if (string != null && string2 != null && string.length() > 0) {
                    this.current.getElement().setAttribute(string, string2);
                    this.setTableModel();
                }
            }
        }
    }

    public static Element editElement(Component component, Element element, ResourceBridge resourceBridge, FileSystem fileSystem, String string, String string2) {
        Element element2 = (Element)element.clone();
        boolean bl = resourceBridge.getOptions().getMessages().showInputDlg(component, new JDomTreePanel(element2, resourceBridge, fileSystem, string), string2);
        return bl ? element2 : null;
    }
}

