/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Options;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Attribute;
import org.jdom.Element;

public class JDomTreeObject
extends AbstractTableModel {
    Element element;
    Options options;

    JDomTreeObject(Element element, Options options) {
        this.element = element;
        this.options = options;
    }

    public String getColumnName(int n) {
        return this.options.getMsg(n == 0 ? "XML_ATTRIBUTE" : "XML_VALUE");
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        if (n == 0) {
            if (this.element.getChildren().isEmpty()) {
                this.element.setText(object.toString());
            } else {
                this.options.getMessages().showAlert(this.options.getMainComponent(), "XML_NOT_EDITABLE");
            }
        } else {
            Attribute attribute = (Attribute)this.element.getAttributes().get(n - 1);
            attribute.setValue(object.toString());
        }
    }

    public int getRowCount() {
        return 1 + this.element.getAttributes().size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        if (n == 0) {
            return n2 == 0 ? this.options.getMsg("XML_TEXT") : this.element.getText();
        }
        Attribute attribute = (Attribute)this.element.getAttributes().get(n - 1);
        return n2 == 0 ? attribute.getName() : attribute.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.element.getName());
        Attribute attribute = this.element.getAttribute("name");
        if (attribute != null) {
            stringBuffer.append(" ").append(attribute.getValue());
        }
        if ((attribute = this.element.getAttribute("id")) != null) {
            stringBuffer.append(" - ").append(attribute.getValue());
        }
        if ((attribute = this.element.getAttribute("type")) != null) {
            stringBuffer.append(" - ").append(attribute.getValue());
        }
        return stringBuffer.substring(0);
    }

    public static DefaultMutableTreeNode processNode(DefaultMutableTreeNode defaultMutableTreeNode, Element element, Options options) {
        JDomTreeObject jDomTreeObject = new JDomTreeObject(element, options);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jDomTreeObject);
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            JDomTreeObject.processNode(defaultMutableTreeNode2, (Element)iterator.next(), options);
        }
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode2;
    }

    public Element getElement() {
        return this.element;
    }
}

