/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.JigSaw;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JigSawEditorPanel
extends JPanel {
    Options options;
    JigSaw shaper;
    Image img;
    Rectangle previewArea;
    BoxBase previewBb;
    boolean modified;
    static final int MARGIN = 40;
    private JCheckBox randomChk;
    private JSlider toothHeightSlider;
    private JPanel controlPanel;
    private JPanel previewPanel;
    private JSlider toothWidthSlider;

    public JigSawEditorPanel(Options options, JigSaw jigSaw, Dimension dimension, Image image, BoxBase boxBase) {
        this.options = options;
        this.shaper = jigSaw;
        this.img = image;
        this.previewArea = new Rectangle(image == null ? dimension : new Dimension(image.getWidth(this), image.getHeight(this)));
        this.previewBb = boxBase;
        this.initComponents();
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.toothHeightSlider = new JSlider();
        JLabel jLabel2 = new JLabel();
        this.toothWidthSlider = new JSlider();
        this.randomChk = new JCheckBox();
        this.previewPanel = new PreviewPanel();
        this.setLayout(new BorderLayout());
        this.controlPanel.setLayout(new GridBagLayout());
        jLabel.setText(this.options.getMsg("edit_act_toothHeightFactor"));
        jLabel.setLabelFor(this.toothHeightSlider);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)jLabel, gridBagConstraints);
        this.toothHeightSlider.setMinorTickSpacing(5);
        this.toothHeightSlider.setPaintLabels(true);
        this.toothHeightSlider.setPaintTicks(true);
        this.toothHeightSlider.setMajorTickSpacing(25);
        this.toothHeightSlider.setMaximum(50);
        this.toothHeightSlider.setValue((int)(this.shaper.toothHeightFactor * 50.0 / (double)this.shaper.getBaseFactor() * 100.0));
        this.toothHeightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JigSawEditorPanel.this.toothHeightSliderStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.toothHeightSlider, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_act_toothWidthFactor"));
        jLabel2.setLabelFor(this.toothWidthSlider);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)jLabel2, gridBagConstraints);
        this.toothWidthSlider.setMinorTickSpacing(5);
        this.toothWidthSlider.setPaintLabels(true);
        this.toothWidthSlider.setPaintTicks(true);
        this.toothWidthSlider.setMajorTickSpacing(25);
        this.toothWidthSlider.setValue((int)(this.shaper.baseWidthFactor * 100.0));
        this.toothWidthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JigSawEditorPanel.this.toothWidthSliderStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.toothWidthSlider, gridBagConstraints);
        this.randomChk.setSelected(this.shaper.randomLines);
        this.randomChk.setText(this.options.getMsg("edit_act_toothRandom"));
        this.randomChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JigSawEditorPanel.this.randomChkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.randomChk, gridBagConstraints);
        this.add((Component)this.controlPanel, "North");
        this.previewPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_preview")));
        this.previewPanel.setPreferredSize(new Dimension(this.previewArea.width + 40, this.previewArea.height + 40));
        this.add((Component)this.previewPanel, "Center");
    }

    private void toothHeightSliderStateChanged(ChangeEvent changeEvent) {
        this.shaper.toothHeightFactor = (double)this.toothHeightSlider.getValue() * (double)this.shaper.getBaseFactor() / 50.0 / 100.0;
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void toothWidthSliderStateChanged(ChangeEvent changeEvent) {
        this.shaper.baseWidthFactor = (double)this.toothWidthSlider.getValue() / 100.0;
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void randomChkActionPerformed(ActionEvent actionEvent) {
        this.shaper.randomLines = this.randomChk.isSelected();
        ((PreviewPanel)this.previewPanel).updateView();
    }

    public static Shaper getShaper(Shaper shaper, Component component, Options options, Dimension dimension, Image image, BoxBase boxBase) {
        Messages messages = options.getMessages();
        if (shaper == null || !(shaper instanceof JigSaw)) {
            return null;
        }
        JigSaw jigSaw = null;
        try {
            jigSaw = (JigSaw)shaper.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            messages.showErrorWarning(component, "edit_act_shaper_err", cloneNotSupportedException);
            return null;
        }
        JigSawEditorPanel jigSawEditorPanel = new JigSawEditorPanel(options, jigSaw, dimension, image, boxBase);
        boolean bl = messages.showInputDlg(component, jigSawEditorPanel, "edit_act_shaper_properties");
        return bl ? jigSaw : null;
    }

    class PreviewPanel
    extends JPanel {
        Vector shapes = new Vector();

        PreviewPanel() {
        }

        public void updateView() {
            this.shapes.removeAllElements();
            JigSawEditorPanel.this.shaper.reset();
            for (int i = 0; i < JigSawEditorPanel.this.shaper.getNumCells(); ++i) {
                this.shapes.add(JigSawEditorPanel.this.shaper.getShape(i, JigSawEditorPanel.this.previewArea));
            }
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            Color color = graphics2D.getBackground();
            Color color2 = graphics2D.getColor();
            graphics2D.setColor(JigSawEditorPanel.this.previewBb.backColor);
            graphics2D.fill(JigSawEditorPanel.this.previewArea);
            graphics2D.setBackground(JigSawEditorPanel.this.previewBb.backColor);
            graphics2D.setColor(JigSawEditorPanel.this.previewBb.borderColor);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(JigSawEditorPanel.this.previewBb.getBorder());
            if (JigSawEditorPanel.this.img != null) {
                graphics2D.drawImage(JigSawEditorPanel.this.img, JigSawEditorPanel.this.previewArea.x, JigSawEditorPanel.this.previewArea.y, this);
            }
            for (int i = 0; i < this.shapes.size(); ++i) {
                graphics2D.draw((Shape)this.shapes.get(i));
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color2);
            graphics2D.setBackground(color);
            graphics2D.setRenderingHints(renderingHints);
        }

        public void doLayout() {
            JigSawEditorPanel.this.previewArea.x = (this.getBounds().width - JigSawEditorPanel.this.previewArea.width) / 2;
            JigSawEditorPanel.this.previewArea.y = (this.getBounds().height - JigSawEditorPanel.this.previewArea.height) / 2;
            this.updateView();
        }
    }
}

