/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.GradientButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxBaseEditor
extends JPanel {
    Options options;
    BoxBase bb;
    public static final String PROP_BOX_BASE = "boxBase";
    ActionListener cfListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BoxBase boxBase = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.createFont();
            BoxBaseEditor.this.checkAndFirePropertyChange(boxBase);
        }
    };
    PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BoxBase boxBase = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.backColor = BoxBaseEditor.this.bgColorBtn.getColor();
            BoxBaseEditor.this.bb.bgGradient = BoxBaseEditor.this.gradientButton.getGradient();
            BoxBaseEditor.this.bb.textColor = BoxBaseEditor.this.textColorBtn.getColor();
            BoxBaseEditor.this.bb.shadowColor = BoxBaseEditor.this.shadowColorBtn.getColor();
            BoxBaseEditor.this.bb.shadow = BoxBaseEditor.this.shadowChk.isSelected();
            BoxBaseEditor.this.bb.transparent = BoxBaseEditor.this.transparentChk.isSelected();
            BoxBaseEditor.this.bb.borderColor = BoxBaseEditor.this.borderColorBtn.getColor();
            BoxBaseEditor.this.bb.inactiveColor = BoxBaseEditor.this.inactiveColorBtn.getColor();
            BoxBaseEditor.this.bb.alternativeColor = BoxBaseEditor.this.altColorBtn.getColor();
            BoxBaseEditor.this.bb.textMargin = BoxBaseEditor.this.textMarginInt.getValue();
            BoxBaseEditor.this.checkAndFirePropertyChange(boxBase);
        }
    };
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BoxBase boxBase = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.shadow = BoxBaseEditor.this.shadowChk.isSelected();
            BoxBaseEditor.this.bb.transparent = BoxBaseEditor.this.transparentChk.isSelected();
            BoxBaseEditor.this.checkAndFirePropertyChange(boxBase);
        }
    };
    ChangeListener borderListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            BoxBase boxBase = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.borderStroke = new BasicStroke((float)BoxBaseEditor.this.borderWidthSlider.getValue() / 10.0f);
            BoxBaseEditor.this.bb.markerStroke = new BasicStroke((float)BoxBaseEditor.this.markerWidthSlider.getValue() / 10.0f);
            BoxBaseEditor.this.checkAndFirePropertyChange(boxBase);
        }
    };
    private static HashMap panels = new HashMap(1);
    private ColorButton altColorBtn;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private ColorButton borderColorBtn;
    private JSlider borderWidthSlider;
    private JComboBox fontFaceCombo;
    private JComboBox fontSizeCombo;
    private GradientButton gradientButton;
    private ColorButton inactiveColorBtn;
    private JToggleButton italicBtn;
    private JSlider markerWidthSlider;
    private JCheckBox shadowChk;
    private ColorButton shadowColorBtn;
    private ColorButton textColorBtn;
    private SmallIntEditor textMarginInt;
    private JCheckBox transparentChk;
    private JPanel typefacePanel;

    public BoxBaseEditor(Options options, BoxBase boxBase) {
        this.options = options;
        this.initComponents();
        this.setBoxBase(boxBase);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel jLabel2 = new JLabel();
        this.gradientButton = new GradientButton();
        this.gradientButton.setOptions(this.options);
        this.transparentChk = new JCheckBox();
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel3 = new JLabel();
        this.typefacePanel = new JPanel();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        JLabel jLabel4 = new JLabel();
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        JSeparator jSeparator2 = new JSeparator();
        JLabel jLabel5 = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel jLabel6 = new JLabel();
        this.altColorBtn = new ColorButton();
        this.altColorBtn.setOptions(this.options);
        JLabel jLabel7 = new JLabel();
        this.textMarginInt = new SmallIntEditor();
        this.shadowChk = new JCheckBox();
        JLabel jLabel8 = new JLabel();
        this.shadowColorBtn = new ColorButton();
        this.shadowColorBtn.setOptions(this.options);
        JLabel jLabel9 = new JLabel();
        this.borderColorBtn = new ColorButton();
        this.borderColorBtn.setOptions(this.options);
        JLabel jLabel10 = new JLabel();
        this.borderWidthSlider = new JSlider();
        JLabel jLabel11 = new JLabel();
        this.inactiveColorBtn = new ColorButton();
        this.inactiveColorBtn.setOptions(this.options);
        JLabel jLabel12 = new JLabel();
        this.markerWidthSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        jLabel.setLabelFor(this.bgColorBtn);
        jLabel.setText(this.options.getMsg("edit_act_bgColor"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.bgColorBtn, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_act_gradient"));
        jLabel2.setLabelFor(this.gradientButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel2, gridBagConstraints);
        this.gradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.gradientButton.addPropertyChangeListener("gradient", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.gradientButton, gridBagConstraints);
        this.transparentChk.setToolTipText(this.options.getMsg("edit_act_transparent_tooltip"));
        this.transparentChk.setText(this.options.getMsg("edit_act_transparent"));
        this.transparentChk.addActionListener(this.actionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.transparentChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jSeparator, gridBagConstraints);
        jLabel3.setLabelFor(this.fontFaceCombo);
        jLabel3.setText(this.options.getMsg("edit_font_face"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel3, gridBagConstraints);
        this.typefacePanel.setLayout(new GridBagLayout());
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(125, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.fontFaceCombo, gridBagConstraints);
        jLabel4.setText(this.options.getMsg("edit_font_size"));
        jLabel4.setLabelFor(this.fontSizeCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)jLabel4, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setPreferredSize(new Dimension(27, 27));
        this.boldBtn.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setPreferredSize(new Dimension(27, 27));
        this.italicBtn.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.italicBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.typefacePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jSeparator2, gridBagConstraints);
        jLabel5.setText(this.options.getMsg("edit_act_textColor"));
        jLabel5.setLabelFor(this.textColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel5, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorBtn, gridBagConstraints);
        jLabel6.setText(this.options.getMsg("edit_act_altColor"));
        jLabel6.setLabelFor(this.altColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel6, gridBagConstraints);
        this.altColorBtn.setToolTipText(this.options.getMsg("edit_act_altColor_tooltip"));
        this.altColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.altColorBtn, gridBagConstraints);
        jLabel7.setLabelFor(this.textMarginInt);
        jLabel7.setText(this.options.getMsg("edit_cell_textMargin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel7, gridBagConstraints);
        this.textMarginInt.setToolTipText(this.options.getMsg("edit_cell_textMargin_tooltip"));
        this.textMarginInt.setMax(50);
        this.textMarginInt.addPropertyChangeListener("value", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.textMarginInt, gridBagConstraints);
        this.shadowChk.setToolTipText(this.options.getMsg("edit_act_shadow_tooltip"));
        this.shadowChk.setText(this.options.getMsg("edit_act_shadow"));
        this.shadowChk.addActionListener(this.actionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shadowChk, gridBagConstraints);
        jLabel8.setText(this.options.getMsg("edit_act_shadowColor"));
        jLabel8.setLabelFor(this.shadowColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel8, gridBagConstraints);
        this.shadowColorBtn.setToolTipText(this.options.getMsg("edit_act_shadowColor_tooltip"));
        this.shadowColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shadowColorBtn, gridBagConstraints);
        jLabel9.setText(this.options.getMsg("edit_act_borderColor"));
        jLabel9.setLabelFor(this.borderColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel9, gridBagConstraints);
        this.borderColorBtn.setToolTipText(this.options.getMsg("edit_act_borderColor_tooltip"));
        this.borderColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderColorBtn, gridBagConstraints);
        jLabel10.setText(this.options.getMsg("edit_cell_borderWidth"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel10, gridBagConstraints);
        this.borderWidthSlider.setMinorTickSpacing(10);
        this.borderWidthSlider.setPaintTicks(true);
        this.borderWidthSlider.setMajorTickSpacing(50);
        this.borderWidthSlider.setToolTipText(this.options.getMsg("edit_cell_borderWidth_tooltip"));
        this.borderWidthSlider.setPreferredSize(new Dimension(100, 27));
        this.borderWidthSlider.addChangeListener(this.borderListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderWidthSlider, gridBagConstraints);
        jLabel11.setText(this.options.getMsg("edit_act_inactiveColor"));
        jLabel11.setLabelFor(this.inactiveColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel11, gridBagConstraints);
        this.inactiveColorBtn.setToolTipText(this.options.getMsg("edit_act_inactiveColor_tooltip"));
        this.inactiveColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.inactiveColorBtn, gridBagConstraints);
        jLabel12.setText(this.options.getMsg("edit_cell_markerWidth"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel12, gridBagConstraints);
        this.markerWidthSlider.setMinorTickSpacing(10);
        this.markerWidthSlider.setPaintTicks(true);
        this.markerWidthSlider.setMajorTickSpacing(50);
        this.markerWidthSlider.setToolTipText(this.options.getMsg("edit_cell_markerWidth_tooltip"));
        this.markerWidthSlider.setPreferredSize(new Dimension(100, 27));
        this.borderWidthSlider.addChangeListener(this.borderListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.markerWidthSlider, gridBagConstraints);
    }

    public void setBoxBase(BoxBase boxBase) {
        if (boxBase == null) {
            boxBase = new BoxBase();
        }
        this.bb = (BoxBase)boxBase.clone();
        Font font = this.bb.getOriginalFont();
        this.fontFaceCombo.setSelectedItem(font.getFamily());
        this.fontSizeCombo.setSelectedItem(Integer.toString(font.getSize()));
        this.boldBtn.setSelected(font.isBold());
        this.italicBtn.setSelected(font.isItalic());
        this.bgColorBtn.setColor(boxBase.backColor);
        this.gradientButton.setGradient(boxBase.bgGradient);
        this.textColorBtn.setColor(boxBase.textColor);
        this.shadowColorBtn.setColor(boxBase.shadowColor);
        this.shadowChk.setSelected(boxBase.shadow);
        this.transparentChk.setSelected(boxBase.transparent);
        this.borderColorBtn.setColor(boxBase.borderColor);
        this.inactiveColorBtn.setColor(boxBase.inactiveColor);
        this.altColorBtn.setColor(boxBase.alternativeColor);
        this.textMarginInt.setValue(boxBase.textMargin);
        this.borderWidthSlider.setValue((int)(boxBase.borderStroke.getLineWidth() * 10.0f));
        this.markerWidthSlider.setValue((int)(boxBase.markerStroke.getLineWidth() * 10.0f));
    }

    protected void createFont() {
        Font font = this.bb.getFont();
        int n = font.getSize();
        try {
            n = Integer.parseInt((String)this.fontSizeCombo.getSelectedItem());
        }
        catch (Exception exception) {
            n = font.getSize();
        }
        n = Math.min(Math.max(n, 6), 140);
        int n2 = 0;
        if (this.boldBtn.isSelected()) {
            n2 |= 1;
        }
        if (this.italicBtn.isSelected()) {
            n2 |= 2;
        }
        this.bb.setFont(new Font((String)this.fontFaceCombo.getSelectedItem(), n2, n));
    }

    private void checkAndFirePropertyChange(BoxBase boxBase) {
        boolean bl;
        BoxBase boxBase2 = this.getBoxBase();
        boolean bl2 = bl = boxBase == null && boxBase2 == null || boxBase != null && boxBase.equals(boxBase2);
        if (!bl) {
            this.firePropertyChange(PROP_BOX_BASE, boxBase, boxBase2);
        }
    }

    public BoxBase getBoxBase() {
        return this.bb;
    }

    public BoxBase getBoxBaseClone() {
        if (this.bb != null) {
            return (BoxBase)this.bb.clone();
        }
        return null;
    }

    public static BoxBase getBoxBase(BoxBase boxBase, Component component, Options options, final AbstractBox abstractBox) {
        Messages messages = options.getMessages();
        BoxBaseEditor boxBaseEditor = (BoxBaseEditor)panels.get(options);
        if (boxBaseEditor == null) {
            boxBaseEditor = new BoxBaseEditor(options, boxBase);
            panels.put(options, boxBaseEditor);
        } else {
            boxBaseEditor.setBoxBase(boxBase);
        }
        PropertyChangeListener propertyChangeListener = null;
        final BoxBaseEditor boxBaseEditor2 = boxBaseEditor;
        if (abstractBox != null) {
            propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (abstractBox != null) {
                        abstractBox.setBoxBase(boxBaseEditor2.getBoxBase());
                    }
                }
            };
            boxBaseEditor.addPropertyChangeListener(PROP_BOX_BASE, propertyChangeListener);
        }
        BoxBase boxBase2 = abstractBox != null ? boxBaseEditor.getBoxBaseClone() : null;
        boolean bl = messages.showInputDlg(component, boxBaseEditor, "edit_style_title");
        if (propertyChangeListener != null) {
            boxBaseEditor.removePropertyChangeListener(PROP_BOX_BASE, propertyChangeListener);
        }
        if (!bl && abstractBox != null) {
            abstractBox.setBoxBase(boxBase2);
        }
        return bl ? boxBaseEditor.bb : null;
    }
}

