/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.util.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlphaColorChooserPanel
extends AbstractColorChooserPanel {
    protected JColorChooser currentChooser = null;
    protected Options options;
    private JSlider alphaSlider;
    private JTextField alphaTxt;
    static JColorChooser chooser;
    static AlphaColorChooserPanel accp;
    static ActionListener okListener;
    static ActionListener cancelListener;
    static Object[] result;

    public AlphaColorChooserPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.alphaSlider = new JSlider();
        JLabel jLabel = new JLabel();
        this.alphaTxt = new JTextField();
        this.setLayout(new GridBagLayout());
        this.alphaSlider.setMajorTickSpacing(50);
        this.alphaSlider.setMaximum(255);
        this.alphaSlider.setMinorTickSpacing(10);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setToolTipText(this.options.getMsg("edit_color_opacity_tooltip"));
        this.alphaSlider.setValue(0);
        this.alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AlphaColorChooserPanel.this.alphaSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.alphaSlider, gridBagConstraints);
        jLabel.setText(this.options.getMsg("edit_color_opacity"));
        jLabel.setLabelFor(this.alphaTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jLabel, gridBagConstraints);
        this.alphaTxt.setText("0");
        this.alphaTxt.setToolTipText(this.options.getMsg("edit_color_opacity_tooltip"));
        this.alphaTxt.setPreferredSize(new Dimension(40, 21));
        this.alphaTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.alphaTxt, gridBagConstraints);
    }

    private void alphaSliderStateChanged(ChangeEvent changeEvent) {
        int n = this.alphaSlider.getValue();
        this.alphaTxt.setText(Integer.toString(n));
        ColorSelectionModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null) {
            Color color = colorSelectionModel.getSelectedColor();
            Color color2 = null;
            color2 = n < 255 ? new Color(color.getRed(), color.getGreen(), color.getBlue(), n) : new Color(color.getRed(), color.getGreen(), color.getBlue());
            colorSelectionModel.setSelectedColor(color2);
        }
    }

    public String getDisplayName() {
        return this.options.getMsg("edit_color_opacity");
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
        this.currentChooser = jColorChooser;
        this.setColor(jColorChooser.getColor());
    }

    protected void setColor(Color color) {
        int n = color.getAlpha();
        this.alphaSlider.setValue(n);
        this.alphaTxt.setText(Integer.toString(n));
    }

    public void updateChooser() {
    }

    protected void buildChooser() {
    }

    public static Color chooseColor(Options options, Component component, Color color) {
        if (chooser == null) {
            chooser = new JColorChooser(color);
            accp = new AlphaColorChooserPanel(options);
            chooser.addChooserPanel(accp);
            result = new Object[1];
            okListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AlphaColorChooserPanel.result[0] = chooser.getColor();
                }
            };
            cancelListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AlphaColorChooserPanel.result[0] = null;
                }
            };
        }
        AlphaColorChooserPanel.result[0] = null;
        chooser.setColor(color);
        accp.setColor(color);
        JColorChooser.createDialog(component, options.getMsg("edit_color_dlgTitle"), true, chooser, okListener, cancelListener).setVisible(true);
        return (Color)result[0];
    }
}

