/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.beans.ImgPanel;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MediaPreviewPanel
extends JPanel {
    public static final int PREFERRED_CMP_WIDTH = 600;
    public static final int PREFERRED_CMP_HEIGHT = 400;
    public static final String SAMPLE_TEXT = "ABCDEFGHIJ\nKLMNOPQRST\nUVWXYZ\nabcdefghij\nklmnopqrst\nuvwxyz\n0123456789\n";
    MediaBagElementEditor mbed;
    Options options;
    PlayStation ps;
    int mediaType;

    public MediaPreviewPanel(MediaBagElementEditor mediaBagElementEditor, Options options) {
        this.mbed = mediaBagElementEditor;
        this.options = options;
        this.setLayout(new BoxLayout(this, 1));
        if (mediaBagElementEditor != null) {
            JComponent jComponent = null;
            this.mediaType = Utils.getFileType(mediaBagElementEditor.getMediaBagElement().getFileName());
            switch (this.mediaType) {
                case 0: {
                    jComponent = this.buildImgComponent();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    jComponent = this.buildMediaComponent();
                    break;
                }
                case 6: {
                    jComponent = this.buildFontComponent();
                    break;
                }
            }
            if (jComponent != null) {
                this.add(jComponent);
            }
        }
    }

    public void end() {
        if (this.ps != null) {
            this.ps.stopMedia(1);
        }
    }

    protected JComponent buildImgComponent() {
        Image image = null;
        JScrollPane jScrollPane = null;
        try {
            image = this.mbed.getMediaBagElement().prepareAndGetImage(this.mbed.getMediaBag().getProject().getFileSystem());
        }
        catch (Exception exception) {
            System.err.println("Error loading image " + this.mbed.getMediaBagElement().getFileName());
        }
        if (image != null) {
            jScrollPane = new JScrollPane(new ImgPanel(new ImageIcon(image)));
            jScrollPane.setPreferredSize(new Dimension(600, 400));
        }
        return jScrollPane;
    }

    protected JComponent buildFontComponent() {
        Object object = this.mbed.getMediaBagElement().getData();
        JTextArea jTextArea = new JTextArea();
        if (object instanceof Font) {
            jTextArea.setFont(((Font)object).deriveFont(0, 48.0f));
            jTextArea.setText(SAMPLE_TEXT);
        } else {
            jTextArea.setText(this.options.getMsg("edit_media_font_error"));
        }
        return new JScrollPane(jTextArea);
    }

    protected JComponent buildMediaComponent() {
        ActiveBoxContent activeBoxContent = new ActiveBoxContent();
        activeBoxContent.mediaContent = new MediaContent();
        int n = 0;
        switch (this.mediaType) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: 
            case 4: {
                n = 2;
            }
        }
        activeBoxContent.mediaContent.mediaType = n;
        activeBoxContent.mediaContent.mediaFileName = this.mbed.getMediaBagElement().getFileName();
        activeBoxContent.mediaContent.stretch = true;
        activeBoxContent.mediaContent.free = false;
        activeBoxContent.dimension = new Dimension(600, 400);
        JPanelActiveBox jPanelActiveBox = new JPanelActiveBox(null, null, this);
        JClicProjectEditor jClicProjectEditor = (JClicProjectEditor)this.mbed.getFirstParent(JClicProjectEditor.class);
        if (jClicProjectEditor != null && jClicProjectEditor.getTestPlayerContainer() != null) {
            this.ps = jClicProjectEditor.getTestPlayerContainer().getTestPlayer();
            jPanelActiveBox.setPlayStation(this.ps);
        }
        jPanelActiveBox.setActiveBoxContent(activeBoxContent);
        try {
            activeBoxContent.realizeContent(this.mbed.getMediaBag());
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanelActiveBox);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        return jScrollPane;
    }
}

