/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagSelector
extends JPanel {
    Options options;
    MediaBagEditor mbe;
    MediaBagElementEditor current;
    int filters;
    private ListSelectionListener selListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null && !listSelectionEvent.getValueIsAdjusting()) {
                MediaBagSelector.this.setSelected((MediaBagElementEditor)MediaBagSelector.this.mediaList.getSelectedValue());
            }
        }
    };
    private static HashMap dlgPanels = new HashMap(1);
    private JButton addMediaBtn;
    private JPanel elementPanel;
    private JLabel fileLb;
    private JLabel fileText;
    private JPanel listPanel;
    private JList mediaList;
    private JLabel nameLb;
    private JLabel nameText;
    private JLabel previewLabel;
    private JScrollPane scrollList;
    private JLabel sizeTx;
    private JLabel typeTx;

    public MediaBagSelector(Options options) {
        this.options = options;
        this.initComponents();
        this.mediaList.addListSelectionListener(this.selListener);
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.scrollList = new JScrollPane();
        this.mediaList = new JList();
        this.addMediaBtn = new JButton();
        this.elementPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.nameLb = new JLabel();
        this.nameText = new JLabel();
        this.fileLb = new JLabel();
        this.fileText = new JLabel();
        JLabel jLabel = new JLabel();
        this.typeTx = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.sizeTx = new JLabel();
        this.setLayout(new GridBagLayout());
        this.listPanel.setLayout(new BorderLayout());
        this.scrollList.setMinimumSize(new Dimension(200, 400));
        this.scrollList.setPreferredSize(new Dimension(200, 400));
        this.scrollList.setViewportView(this.mediaList);
        this.listPanel.add((Component)this.scrollList, "Center");
        this.addMediaBtn.setIcon(ResourceManager.getImageIcon("icons/media_new.gif"));
        this.addMediaBtn.setText(this.options.getMsg("edit_media_new"));
        this.addMediaBtn.setToolTipText(this.options.getMsg("edit_media_new_tooltip"));
        this.addMediaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MediaBagSelector.this.addMediaBtnActionPerformed(actionEvent);
            }
        });
        this.listPanel.add((Component)this.addMediaBtn, "Last");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.listPanel, gridBagConstraints);
        this.elementPanel.setLayout(new GridBagLayout());
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setBorder(BorderFactory.createEtchedBorder());
        this.previewLabel.setMinimumSize(new Dimension(100, 100));
        this.previewLabel.setPreferredSize(new Dimension(100, 100));
        this.previewLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MediaBagSelector.this.previewLabelMousePressed(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 7, 3);
        this.elementPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.nameLb.setText(this.options.getMsg("edit_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.nameLb, gridBagConstraints);
        this.nameText.setMinimumSize(new Dimension(200, 16));
        this.nameText.setPreferredSize(new Dimension(200, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.nameText, gridBagConstraints);
        this.fileLb.setText(this.options.getMsg("edit_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileLb, gridBagConstraints);
        this.fileText.setMinimumSize(new Dimension(200, 16));
        this.fileText.setPreferredSize(new Dimension(200, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileText, gridBagConstraints);
        jLabel.setText(this.options.getMsg("edit_media_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)jLabel, gridBagConstraints);
        this.typeTx.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.typeTx, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_media_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)jLabel2, gridBagConstraints);
        this.sizeTx.setText("0 Kb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.sizeTx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.elementPanel, gridBagConstraints);
    }

    private void previewLabelMousePressed(MouseEvent mouseEvent) {
        if (this.current != null) {
            this.current.testMedia(this, this.options);
        }
    }

    private void addMediaBtnActionPerformed(ActionEvent actionEvent) {
        MediaBagElementEditor[] mediaBagElementEditorArray;
        if (this.mbe != null && (mediaBagElementEditorArray = this.mbe.createNewMediaBagElements(this.options, this, this.filters)) != null && mediaBagElementEditorArray.length > 0) {
            this.mediaList.setListData(this.mbe.getChildrenList(this.filters));
            this.setSelected(mediaBagElementEditorArray[0]);
            this.mediaList.setSelectedValue(mediaBagElementEditorArray[0], true);
        }
    }

    protected void setMediaBagEditor(MediaBagEditor mediaBagEditor, int n) {
        this.mbe = mediaBagEditor;
        this.filters = n;
        this.setSelected(null);
        this.mediaList.setListData(mediaBagEditor == null ? new Vector() : mediaBagEditor.getChildrenList(n));
    }

    protected void setSelected(MediaBagElementEditor mediaBagElementEditor) {
        this.current = mediaBagElementEditor;
        this.nameText.setText(this.current == null ? "" : this.current.getName());
        this.fileText.setText(this.current == null ? "" : this.current.getMediaBagElement().getFileName());
        this.typeTx.setText(mediaBagElementEditor == null ? "" : mediaBagElementEditor.getDescription(this.options));
        long l = -1L;
        if (mediaBagElementEditor != null) {
            l = mediaBagElementEditor.getFileSize();
        }
        this.sizeTx.setText(l < 0L ? "" : this.options.getMessages().fileSize(l));
        this.previewLabel.setIcon(mediaBagElementEditor == null ? null : mediaBagElementEditor.getMediaBagElement().getThumbNail(90, 90, mediaBagElementEditor.getMediaBag().getProject().getFileSystem()));
        if (mediaBagElementEditor != null) {
            mediaBagElementEditor.getMediaBagElement().clearData();
        }
    }

    protected MediaBagElementEditor getSelected() {
        return this.current;
    }

    public static String getMediaName(String string, Options options, Component component, MediaBagEditor mediaBagEditor, int n) {
        MediaBagElementEditor mediaBagElementEditor;
        String string2 = null;
        Messages messages = options.getMessages();
        MediaBagSelector mediaBagSelector = (MediaBagSelector)dlgPanels.get(options);
        if (mediaBagSelector == null) {
            mediaBagSelector = new MediaBagSelector(options);
            dlgPanels.put(options, mediaBagSelector);
        }
        mediaBagSelector.setMediaBagEditor(mediaBagEditor, n);
        MediaBagElementEditor mediaBagElementEditor2 = string == null ? null : (MediaBagElementEditor)mediaBagEditor.getChildByName(string);
        mediaBagSelector.setSelected(mediaBagElementEditor2);
        mediaBagSelector.mediaList.setSelectedValue(mediaBagElementEditor2, true);
        boolean bl = messages.showInputDlg(component, mediaBagSelector, "edit_media_dlg_title");
        if (bl && (mediaBagElementEditor = mediaBagSelector.getSelected()) != null) {
            string2 = mediaBagElementEditor.getName();
        }
        mediaBagSelector.setMediaBagEditor(null, -1);
        return string2;
    }
}

