/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagElementEditorPanel;
import edu.xtec.jclic.boxes.ThumbsExplorerPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagMultiEditorPanel
extends EditorPanel {
    public static final int ICON_MAX_WIDTH = 100;
    public static final int BUTTON_WIDTH = 130;
    public static final int ICON_MAX_HEIGHT = 70;
    public static final int BUTTON_HEIGHT = 110;
    public static final String[] COMBO_ITEMS = new String[]{"filefilter_all_media", "filefilter_all_images", "filefilter_all_sounds", "filefilter_midi", "filefilter_all_video", "filefilter_all_anim", "filefilter_skins", "filefilter_fonts"};
    public static final int[] COMBO_FILTERS = new int[]{12, 11, 13, 14, 15, 16, 17, 18};
    private ThumbsExplorerPanel selectPanel;
    private MediaBagElementEditor current;
    int filters = -1;
    private ListSelectionListener btSelListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MediaBagMultiEditorPanel.this.current = (MediaBagElementEditor)MediaBagMultiEditorPanel.this.selectPanel.getCurrentObject();
            ((MediaBagElementEditorPanel)MediaBagMultiEditorPanel.this.elementEditPanel).attachEditor(MediaBagMultiEditorPanel.this.current, true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MediaBagMultiEditorPanel.this.selectPanel.checkCurrentVisibility();
                }
            });
        }
    };
    private ActionListener btActListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MediaBagElementEditor.testMediaBagElementAction.actionPerformed(new ActionEvent(MediaBagMultiEditorPanel.this.elementEditPanel, 1001, ""));
        }
    };
    private static HashMap dlgPanels = new HashMap(1);
    private ButtonGroup bGroup;
    private JPanel elementEditPanel;
    private JComboBox filterCombo;
    private JLabel filterLb;
    private JPanel filterPanel;
    private JPanel mainPanel;
    private JPanel sPanel;
    private JScrollPane scrollPanel;
    private JLabel statusLb;

    public MediaBagMultiEditorPanel(Options options) {
        super(options);
        MediaBagEditor.createActions(options);
        MediaBagElementEditor.createActions(options);
        this.initComponents();
        this.selectPanel = (ThumbsExplorerPanel)this.sPanel;
        this.scrollPanel.getVerticalScrollBar().setUnitIncrement(this.selectPanel.boxSize.height);
        this.selectPanel.addListSelectionListener(this.btSelListener);
        this.selectPanel.addActionListener(this.btActListener);
        this.filterCombo.setSelectedIndex(0);
        this.postInit(250, false, true);
        this.setEnabled(false);
    }

    protected String getTitle() {
        return this.options.getMsg("edit_media_title");
    }

    protected Vector getComboItems() {
        Vector<String> vector = new Vector<String>(COMBO_ITEMS.length);
        for (int i = 0; i < COMBO_ITEMS.length; ++i) {
            vector.add(this.options.getMsg(COMBO_ITEMS[i]));
        }
        return vector;
    }

    public void focusGained(FocusEvent focusEvent) {
        ((MediaBagElementEditorPanel)this.elementEditPanel).focusGained(focusEvent);
    }

    private void initComponents() {
        this.bGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.filterLb = new JLabel();
        this.filterCombo = new JComboBox(this.getComboItems());
        this.scrollPanel = new JScrollPane();
        this.sPanel = new ThumbsExplorerPanel();
        this.statusLb = new JLabel();
        this.elementEditPanel = new MediaBagElementEditorPanel(this.options);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.filterPanel.setLayout(new FlowLayout(0));
        this.filterLb.setText(this.options.getMsg("edit_media_show_type"));
        this.filterPanel.add(this.filterLb);
        this.filterCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MediaBagMultiEditorPanel.this.filterComboActionPerformed(actionEvent);
            }
        });
        this.filterPanel.add(this.filterCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.filterPanel, gridBagConstraints);
        this.scrollPanel.setHorizontalScrollBarPolicy(31);
        this.scrollPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MediaBagMultiEditorPanel.this.scrollPanelComponentResized(componentEvent);
            }
        });
        this.scrollPanel.setViewportView(this.sPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.scrollPanel, gridBagConstraints);
        this.statusLb.setText("0 " + this.options.getMsg("edit_media_objects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.statusLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.elementEditPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void filterComboActionPerformed(ActionEvent actionEvent) {
        this.setFilters(COMBO_FILTERS[this.filterCombo.getSelectedIndex()]);
    }

    private void scrollPanelComponentResized(ComponentEvent componentEvent) {
        this.selectPanel.resizeTo(this.scrollPanel.getViewport().getSize().width);
    }

    public void editorDataChanged(Editor editor) {
        if (editor != null) {
            if (editor.equals(this.getEditor())) {
                this.fillData();
            } else {
                ThumbsExplorerPanel.ThumbElement thumbElement = this.selectPanel.getElementFor(editor);
                if (thumbElement != null) {
                    MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)editor;
                    Dimension dimension = this.selectPanel.maxThumbSize;
                    thumbElement.setImage(mediaBagElementEditor.getMediaBagElement().getThumbNail(dimension.width, dimension.height, this.getMediaBag().getProject().getFileSystem()));
                    thumbElement.setText(mediaBagElementEditor.getName());
                    mediaBagElementEditor.getMediaBagElement().clearData();
                    this.btSelListener.valueChanged(null);
                    this.repaint();
                }
            }
        }
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof MediaBagEditor;
    }

    protected MediaBagEditor getMediaBagEditor() {
        return (MediaBagEditor)this.editor;
    }

    protected MediaBag getMediaBag() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagEditor().getMediaBag();
    }

    public void setFilters(int n) {
        this.filters = n;
        for (int i = 0; i < COMBO_FILTERS.length; ++i) {
            if (COMBO_FILTERS[i] != n) continue;
            this.filterCombo.setSelectedIndex(i);
            break;
        }
        this.fillData();
    }

    public int getFilters() {
        return this.filters;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.selectPanel.setEnabled(bl);
        this.filterCombo.setEnabled(bl);
        this.elementEditPanel.setEnabled(bl);
    }

    protected void fillData() {
        this.current = null;
        this.selectPanel.removeAllThumbElements();
        ((MediaBagElementEditorPanel)this.elementEditPanel).attachEditor(null, true);
        MediaBagEditor mediaBagEditor = this.getMediaBagEditor();
        int n = 0;
        if (mediaBagEditor != null) {
            Dimension dimension = this.selectPanel.maxThumbSize;
            Vector vector = mediaBagEditor.getChildrenList(this.filters);
            n = vector.size();
            FileSystem fileSystem = this.getMediaBag().getProject().getFileSystem();
            for (int i = 0; i < n; ++i) {
                MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)vector.get(i);
                this.selectPanel.addThumbElement(mediaBagElementEditor, mediaBagElementEditor.getMediaBagElement().getThumbNail(dimension.width, dimension.height, fileSystem), mediaBagElementEditor.getName());
                mediaBagElementEditor.getMediaBagElement().clearData();
            }
        }
        this.btSelListener.valueChanged(null);
        this.statusLb.setText(Integer.toString(n) + " " + this.options.getMsg(n == 1 ? "edit_media_object" : "edit_media_objects"));
        this.scrollPanelComponentResized(null);
    }

    protected void saveData() {
    }

    public MediaBagElementEditor getSelected() {
        return this.current;
    }

    public void setSelected(MediaBagElementEditor mediaBagElementEditor) {
        this.selectPanel.setCurrentObject(mediaBagElementEditor);
        this.btSelListener.valueChanged(null);
    }

    public static String getMediaName(String string, Options options, Component component, MediaBagEditor mediaBagEditor, int n) {
        MediaBagElementEditor mediaBagElementEditor;
        String string2 = null;
        Messages messages = options.getMessages();
        MediaBagMultiEditorPanel mediaBagMultiEditorPanel = (MediaBagMultiEditorPanel)dlgPanels.get(options);
        if (mediaBagMultiEditorPanel == null) {
            mediaBagMultiEditorPanel = new MediaBagMultiEditorPanel(options);
            mediaBagMultiEditorPanel.setPreferredSize(new Dimension(500, 500));
            dlgPanels.put(options, mediaBagMultiEditorPanel);
        }
        mediaBagMultiEditorPanel.attachEditor(mediaBagEditor, true);
        mediaBagMultiEditorPanel.setFilters(n);
        if (n >= 0) {
            mediaBagMultiEditorPanel.filterCombo.setEnabled(false);
        }
        mediaBagMultiEditorPanel.setSelected(string == null ? null : (MediaBagElementEditor)mediaBagEditor.getChildByName(string));
        boolean bl = messages.showInputDlg(component, mediaBagMultiEditorPanel, "edit_media_dlg_title");
        if (bl && (mediaBagElementEditor = mediaBagMultiEditorPanel.getSelected()) != null) {
            string2 = mediaBagElementEditor.getName();
        }
        mediaBagMultiEditorPanel.filterCombo.setEnabled(true);
        mediaBagMultiEditorPanel.removeEditor(true);
        return string2;
    }

    protected void addActionsTo(Container container) {
        container.add(new SmallButton(MediaBagEditor.newMediaBagElementAction));
        container.add(new SmallButton(MediaBagElementEditor.testMediaBagElementAction));
        container.add(new SmallButton(Editor.deleteAction));
        container.add(new SmallButton(MediaBagEditor.updateAllMediaAction));
        container.add(new SmallButton(MediaBagEditor.exportAllMediaAction));
    }
}

