/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagElementEditorPanel
extends EditorPanel {
    protected ZipFileSystem.ExtendedZipEntry zipEntry;
    protected ZipFileSystem zipFileSystem;
    protected FileSystem fileSystem;
    private JButton chFileBtn;
    private JButton chNameBtn;
    private JButton editActBtn;
    private JLabel fileText;
    private JPanel mainPanel;
    private JLabel nameText;
    private JList refList;
    private JPanel refPanel;
    private JScrollPane refScroll;
    private JButton refreshFileBtn;
    private JButton saveFileBtn;
    private JPanel settingsPanel;
    private JLabel sizeTx;
    private JLabel typeTx;
    private JCheckBox zipIncludeChk;

    public MediaBagElementEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.refList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    MediaBagElementEditorPanel.this.editActBtn.setEnabled(listSelectionEvent.getFirstIndex() >= 0);
                }
            }
        });
        this.postInit(250, false, false);
    }

    protected String getTitle() {
        return this.options.getMsg("edit_media_title");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.settingsPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.nameText = new JLabel();
        this.chNameBtn = new JButton();
        this.chNameBtn.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        this.fileText = new JLabel();
        this.chFileBtn = new JButton();
        this.chFileBtn.addActionListener(this);
        this.saveFileBtn = new JButton();
        this.refreshFileBtn = new JButton();
        this.refreshFileBtn.addActionListener(this);
        JLabel jLabel3 = new JLabel();
        this.typeTx = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.sizeTx = new JLabel();
        this.zipIncludeChk = new JCheckBox();
        this.zipIncludeChk.addActionListener(this);
        this.refPanel = new JPanel();
        this.refScroll = new JScrollPane();
        this.refList = new JList();
        this.editActBtn = new JButton();
        this.editActBtn.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setLayout(new GridBagLayout());
        jLabel.setText(this.options.getMsg("edit_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)jLabel, gridBagConstraints);
        this.nameText.setBorder(BorderFactory.createTitledBorder(""));
        this.nameText.setMinimumSize(new Dimension(200, 21));
        this.nameText.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.nameText, gridBagConstraints);
        this.chNameBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.chNameBtn.setToolTipText(this.options.getMsg("edit_media_change_name"));
        this.chNameBtn.setText("");
        this.chNameBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.chNameBtn, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)jLabel2, gridBagConstraints);
        this.fileText.setBorder(BorderFactory.createTitledBorder(""));
        this.fileText.setMinimumSize(new Dimension(200, 21));
        this.fileText.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.fileText, gridBagConstraints);
        this.chFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_open.gif")));
        this.chFileBtn.setToolTipText(this.options.getMsg("edit_media_change_file"));
        this.chFileBtn.setText("");
        this.chFileBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.chFileBtn, gridBagConstraints);
        this.saveFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_save.gif")));
        this.saveFileBtn.setToolTipText(this.options.getMsg("edit_media_save_file"));
        this.saveFileBtn.setText("");
        this.saveFileBtn.setMargin(new Insets(2, 2, 2, 2));
        this.saveFileBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.saveFileBtn, gridBagConstraints);
        this.refreshFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/reset.gif")));
        this.refreshFileBtn.setToolTipText(this.options.getMsg("edit_media_refresh_file"));
        this.refreshFileBtn.setText("");
        this.refreshFileBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.refreshFileBtn, gridBagConstraints);
        jLabel3.setText(this.options.getMsg("edit_media_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)jLabel3, gridBagConstraints);
        this.typeTx.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.typeTx, gridBagConstraints);
        jLabel4.setText(this.options.getMsg("edit_media_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)jLabel4, gridBagConstraints);
        this.sizeTx.setText("0 Kb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.sizeTx, gridBagConstraints);
        this.zipIncludeChk.setText(this.options.getMsg("edit_media_includeInZip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.zipIncludeChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.settingsPanel, gridBagConstraints);
        this.refPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_media_referencedBy")));
        this.refPanel.setMinimumSize(new Dimension(180, 100));
        this.refPanel.setPreferredSize(new Dimension(180, 100));
        this.refPanel.setLayout(new BorderLayout());
        this.refList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MediaBagElementEditorPanel.this.refListMouseClicked(mouseEvent);
            }
        });
        this.refScroll.setViewportView(this.refList);
        this.refPanel.add((Component)this.refScroll, "Center");
        this.editActBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/miniclic.png")));
        this.editActBtn.setToolTipText(this.options.getMsg("edit_act_editActivity_tooltip"));
        this.editActBtn.setText(this.options.getMsg("edit_act_editActivity"));
        this.editActBtn.setHorizontalAlignment(2);
        this.refPanel.add((Component)this.editActBtn, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.refPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void refListMouseClicked(MouseEvent mouseEvent) {
        if (this.refList.getSelectedValue() != null && mouseEvent.getClickCount() == 2) {
            this.editActivity(this.refList.getSelectedValue().toString());
        }
    }

    protected void editActivity(String string) {
        JClicProjectEditor jClicProjectEditor;
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        if (mediaBagElementEditor != null && string != null && (jClicProjectEditor = (JClicProjectEditor)mediaBagElementEditor.getFirstParent(JClicProjectEditor.class)) != null && jClicProjectEditor.getTestPlayerContainer() != null) {
            jClicProjectEditor.getTestPlayerContainer().editActivity(string);
        }
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof MediaBagElementEditor;
    }

    protected MediaBagElementEditor getMediaBagElementEditor() {
        return (MediaBagElementEditor)this.editor;
    }

    protected MediaBagElement getMediaBagElement() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagElementEditor().getMediaBagElement();
    }

    protected MediaBag getMediaBag() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagElementEditor().getMediaBag();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.chNameBtn.setEnabled(false);
            this.chFileBtn.setEnabled(false);
            this.saveFileBtn.setEnabled(false);
            this.refreshFileBtn.setEnabled(false);
            this.zipIncludeChk.setEnabled(false);
        }
        this.refList.setEnabled(bl);
    }

    protected void fillData() {
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        String string = mediaBagElementEditor == null ? "" : mediaBagElementEditor.getMediaBagElement().getFileName();
        FileSystem fileSystem = this.fileSystem = mediaBagElementEditor == null || mediaBagElementEditor.getMediaBag() == null ? null : mediaBagElementEditor.getMediaBag().getProject().getFileSystem();
        if (this.fileSystem instanceof ZipFileSystem) {
            this.zipFileSystem = (ZipFileSystem)this.fileSystem;
            this.zipEntry = this.zipFileSystem.getEntry(string);
        } else {
            this.zipFileSystem = null;
            this.zipEntry = null;
        }
        String string2 = mediaBagElementEditor == null ? "" : mediaBagElementEditor.getName();
        this.nameText.setText(string2);
        this.nameText.setToolTipText(string2);
        this.chNameBtn.setEnabled(mediaBagElementEditor != null);
        this.fileText.setText(string);
        this.fileText.setToolTipText(string);
        this.chFileBtn.setEnabled(mediaBagElementEditor != null);
        this.saveFileBtn.setEnabled(this.zipEntry != null);
        this.refreshFileBtn.setEnabled(mediaBagElementEditor != null);
        this.typeTx.setText(mediaBagElementEditor == null ? "" : mediaBagElementEditor.getDescription(this.options));
        long l = -1L;
        if (mediaBagElementEditor != null) {
            l = mediaBagElementEditor.getFileSize();
        }
        this.sizeTx.setText(l < 0L ? "" : this.options.getMessages().fileSize(l));
        this.zipIncludeChk.setSelected(mediaBagElementEditor == null ? true : mediaBagElementEditor.getMediaBagElement().saveFlag);
        this.zipIncludeChk.setEnabled(mediaBagElementEditor != null);
        this.checkReferences();
    }

    protected void checkReferences() {
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        Vector vector = null;
        if (mediaBagElementEditor != null) {
            vector = mediaBagElementEditor.listReferences();
        }
        this.refList.setListData(vector == null ? new Vector() : vector);
        this.refList.setSelectedIndex(-1);
        this.editActBtn.setEnabled(false);
    }

    protected void saveData() {
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        if (mediaBagElementEditor != null) {
            mediaBagElementEditor.getMediaBagElement().saveFlag = this.zipIncludeChk.isSelected();
        }
    }

    public boolean eventPerformed(EventObject eventObject) {
        if (eventObject != null) {
            if (eventObject.getSource() == this.refreshFileBtn) {
                this.refreshFile();
            } else if (eventObject.getSource() == this.saveFileBtn) {
                this.saveFile();
            } else if (eventObject.getSource() == this.chFileBtn) {
                this.changeFileName();
            } else if (eventObject.getSource() == this.chNameBtn) {
                this.changeName();
            } else if (eventObject.getSource() == this.editActBtn && this.refList.getSelectedValue() != null) {
                this.editActivity(this.refList.getSelectedValue().toString());
                return false;
            }
        }
        return true;
    }

    private void refreshFile() {
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        if (mediaBagElementEditor != null) {
            if (this.zipEntry != null) {
                if (!this.zipFileSystem.fileExists(this.getMediaBagElement().getFileName())) {
                    this.options.getMessages().showAlert((Component)this, "edit_media_warn_zipFileNotExternal");
                    return;
                }
                this.zipEntry.ignore = true;
                this.zipEntry = null;
                mediaBagElementEditor.updateContent(this);
                this.notifyChangesToParentPanel();
                this.getEditor().setModified(true);
            }
            this.getMediaBagElement().setData(null);
        }
    }

    private void saveFile() {
        String string;
        String string2;
        if (this.zipEntry != null && (string2 = this.zipFileSystem.chooseFile(string = this.getMediaBagElement().getFileName(), true, null, this.options, "FILE_SAVE", this, false)) != null) {
            try {
                FileOutputStream fileOutputStream = this.zipFileSystem.createSecureFileOutputStream(string2);
                int n = (int)this.zipFileSystem.getFileLength(string);
                InputStream inputStream = this.zipFileSystem.getInputStream(string);
                StreamIO.writeStreamDlg(inputStream, fileOutputStream, n, this.options.getMessages().get("filesystem_copyFile"), this, this.options);
            }
            catch (Exception exception) {
                this.options.getMessages().showErrorWarning(this, "FILE_ERR_SAVING", exception);
            }
        }
    }

    private void changeFileName() {
        MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        if (mediaBagElementEditor != null) {
            MediaBagElement mediaBagElement = mediaBagElementEditor.getMediaBagElement();
            Messages messages = this.options.getMessages();
            String string = mediaBagElement.getFileName();
            FileSystem fileSystem = mediaBagElementEditor.getMediaBag().getProject().getFileSystem();
            int[] nArray = new int[]{Utils.getFileFilterCode(string)};
            String string2 = fileSystem.chooseFile(string.replace('/', File.separatorChar), false, nArray, this.options, "edit_find_media", this, true);
            if (string2 != null && mediaBagElementEditor.changeFileName(string2 = string2.replace(File.separatorChar, '/'), this, messages)) {
                this.notifyChangesToParentPanel();
            }
        }
    }

    private void changeName() {
        String string;
        Messages messages;
        String string2;
        final MediaBagElementEditor mediaBagElementEditor = this.getMediaBagElementEditor();
        if (mediaBagElementEditor != null && (string2 = (messages = this.options.getMessages()).showInputDlg((Component)this, "edit_media_rename", "edit_media_rename_prompt", string = this.getMediaBagElement().getName(), "edit_media_rename_title", false)) != null) {
            final ProgressDialog progressDialog = new ProgressDialog(this, this.options);
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    mediaBagElementEditor.rename(string2, MediaBagElementEditorPanel.this, MediaBagElementEditorPanel.this.options.getMessages());
                    return null;
                }

                public void finished() {
                    MediaBagElementEditorPanel.this.notifyChangesToParentPanel();
                    progressDialog.setVisible(false);
                }
            };
            progressDialog.start("edit_media_rename", "edit_media_renaming", swingWorker, false, false, false);
        }
    }

    private void notifyChangesToParentPanel() {
        MediaBagMultiEditorPanel mediaBagMultiEditorPanel = (MediaBagMultiEditorPanel)this.getAWTAncestor(MediaBagMultiEditorPanel.class);
        if (mediaBagMultiEditorPanel != null) {
            mediaBagMultiEditorPanel.editorDataChanged(this.getEditor());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.checkReferences();
    }
}

