/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.CopyActivityAttributesPanel;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivityBagEditorPanel;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.NewActivityPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom.Element;

public class ActivityBagEditor
extends Editor {
    public static ImageIcon icon;
    public static EditorAction newActivityBagElementAction;
    public static EditorAction copyActivityAttributesAction;
    public static boolean actionsCreated;
    private boolean initializing;
    private static NewActivityPanel newActivityPanel;

    public ActivityBagEditor(ActivityBag activityBag) {
        super(activityBag);
    }

    protected void createChildren() {
        this.initializing = true;
        ActivityBag activityBag = this.getActivityBag();
        if (activityBag != null) {
            int n = activityBag.size();
            for (int i = 0; i < n; ++i) {
                activityBag.elementAt(i).getEditor(this);
            }
        }
        this.initializing = false;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new ActivityBagEditorPanel(options);
    }

    public Class getEditorPanelClass() {
        return ActivityBagEditorPanel.class;
    }

    public String getTitleKey() {
        return "edit_activities";
    }

    public ActivityBag getActivityBag() {
        return (ActivityBag)this.getUserObject();
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/database.gif");
        }
        return icon;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return ActivityBagEditor.getIcon();
    }

    public String toString() {
        return "Activity bag";
    }

    public Options getOptions() {
        return this.getActivityBag().getProject().getBridge().getOptions();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public boolean createNewActivityBagElement(int n, Component component) {
        String string = null;
        String string2 = null;
        while (true) {
            if (newActivityPanel == null) {
                newActivityPanel = new NewActivityPanel(this.getOptions());
            } else {
                newActivityPanel.setActivityName(null);
            }
            if (!this.getOptions().getMessages().showInputDlg(component, newActivityPanel, "edit_act_newActivity")) {
                return false;
            }
            string = newActivityPanel.gectActivityClassName();
            if (string == null) {
                this.getOptions().getMessages().showAlert(component, "edit_act_newActivity_error_noAct");
                continue;
            }
            string2 = newActivityPanel.getActivityName();
            if (string2 == null) {
                this.getOptions().getMessages().showAlert(component, "edit_act_newActivity_error_noName");
                continue;
            }
            if (this.getActivityBag().getElementIndex(string2) < 0) break;
            this.getOptions().getMessages().showAlert(component, "edit_media_rename_exists");
        }
        Activity activity = null;
        try {
            activity = Activity.getActivity(string, this.getProjectEditor().getProject());
            activity.name = string2;
        }
        catch (Exception exception) {
            this.getOptions().getMessages().showErrorWarning(component, "edit_act_newActivity_error_creating", exception);
            return false;
        }
        Element element = activity.getJDomElement();
        if (element == null) {
            this.getOptions().getMessages().showErrorWarning(component, "edit_act_newActivity_error_creating", null);
            return false;
        }
        ActivityBagElement activityBagElement = new ActivityBagElement(activity.getJDomElement());
        ActivityBagElementEditor activityBagElementEditor = (ActivityBagElementEditor)activityBagElement.getEditor(null);
        n = n < 0 ? this.getChildCount() : Math.min(n, this.getChildCount());
        return this.insertEditor(activityBagElementEditor, true, n, true);
    }

    public void changeActivityClass(ActivityBagElementEditor activityBagElementEditor, String string) throws Exception {
        activityBagElementEditor.collectData();
        ActivityBagElement activityBagElement = activityBagElementEditor.getActivityBagElement();
        activityBagElementEditor.forgetActivityEditor();
        Activity activity = Activity.getActivity(string, this.getProjectEditor().getProject());
        activity.setProperties(activityBagElement.getData(), null);
        activityBagElement.setData(activity.getJDomElement());
        this.setModified(true);
    }

    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newActivityBagElementAction.setActionOwner(this);
        }
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newActivityBagElementAction.setActionOwner(null);
        }
    }

    public static void createActions(Options options) {
        ActivityBagEditor.createBasicActions(options);
        if (!actionsCreated) {
            newActivityBagElementAction = new EditorAction("edit_act_newActivity", "icons/new_miniclic.png", "edit_act_newActivity_tooltip", options){

                protected void doAction(Editor editor) {
                    Editor editor2 = null;
                    if (editor instanceof ActivityBagElementEditor) {
                        editor2 = editor;
                        editor = editor.getEditorParent();
                    }
                    if (editor instanceof ActivityBagEditor) {
                        ((ActivityBagEditor)editor).createNewActivityBagElement(editor.getNearestIndex(editor2, true), this.getComponentSrc());
                    }
                }
            };
            copyActivityAttributesAction = new EditorAction("edit_act_copyAttributes", "icons/copy_properties.gif", "edit_act_copyAttributes_tooltip", options){

                protected void doAction(Editor editor) {
                    Object var2_2 = null;
                    if (editor instanceof ActivityBagElementEditor) {
                        CopyActivityAttributesPanel copyActivityAttributesPanel = new CopyActivityAttributesPanel(this.options, (ActivityBagElementEditor)editor);
                        copyActivityAttributesPanel.showDialog(this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        super.insert(mutableTreeNode, n);
        if (!this.initializing) {
            ActivityBagElement activityBagElement = ((ActivityBagElementEditor)mutableTreeNode).getActivityBagElement();
            if (this.getActivityBag().getElementIndex(activityBagElement.getName()) >= 0) {
                int n2;
                String string = activityBagElement.getName();
                for (n2 = string.length() - 1; n2 >= 0 && Character.isDigit(string.charAt(n2)); --n2) {
                }
                if (!(string = string.substring(0, n2 + 1)).endsWith("_")) {
                    string = string + "_";
                }
                int n3 = 2;
                while (this.getActivityBag().getElementIndex(string + n3) >= 0) {
                    ++n3;
                }
                activityBagElement.getData().setAttribute("name", string + n3);
            }
            this.getActivityBag().insertElementAt(activityBagElement, n);
        }
    }

    public void remove(int n) {
        super.remove(n);
        this.getActivityBag().removeElementAt(n);
    }

    public boolean nameChanged(int n, String string, String string2) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            bl |= ((ActivityBagElementEditor)enumeration.nextElement()).nameChanged(n, string, string2);
        }
        return bl;
    }

    public int checkOrphanElements(Options options, Component component, boolean bl) {
        Object[] objectArray;
        int n;
        int n2 = 1;
        Vector<Object[]> vector = new Vector<Object[]>();
        ActivityBagElement[] activityBagElementArray = this.getActivityBag().getElements();
        ActivitySequenceEditor activitySequenceEditor = this.getProjectEditor().getActivitySequenceEditor();
        ActivitySequenceElement[] activitySequenceElementArray = activitySequenceEditor.getActivitySequence().getElements();
        for (n = 0; n < activityBagElementArray.length; ++n) {
            objectArray = activityBagElementArray[n].getName();
            int n3 = 0;
            for (n3 = 0; n3 < activitySequenceElementArray.length && !activitySequenceElementArray[n3].getActivityName().equals(objectArray); ++n3) {
            }
            if (n3 != activitySequenceElementArray.length) continue;
            vector.add(objectArray);
        }
        if (!vector.isEmpty()) {
            int n4 = n = !bl ? 1 : 0;
            if (n == 0) {
                objectArray = new Object[]{options.getMsg("edit_project_orphanActivities"), vector.size() > 10 ? new JScrollPane(new JList(vector)) : vector, options.getMsg("edit_project_orphanActivities_prompt")};
                n2 = options.getMessages().showQuestionDlgObj(component, objectArray, "edit_project_orphanActivities_title", "ync");
                int n5 = n = n2 == 1 ? 1 : 0;
            }
            if (n != 0) {
                objectArray = vector.iterator();
                while (objectArray.hasNext()) {
                    activitySequenceEditor.createNewSequenceElement((String)objectArray.next(), null, -1);
                }
            }
        }
        return n2;
    }

    static {
        newActivityPanel = null;
    }
}

