/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.beans.CheckBoxTree;
import edu.xtec.jclic.beans.CheckBoxTreeObject;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class CopyActivityAttributesPanel
extends JPanel {
    Options options;
    ActivityBagElementEditor abed;
    ActivityBagEditor abe;
    private CheckBoxTreeObject bgColor;
    private CheckBoxTreeObject bgGradient;
    private CheckBoxTreeObject bgImage;
    private CheckBoxTreeObject activityBgColor;
    private CheckBoxTreeObject activityBgGradient;
    private CheckBoxTreeObject transparentBg;
    private CheckBoxTreeObject border;
    private CheckBoxTreeObject position;
    private CheckBoxTreeObject margin;
    private CheckBoxTreeObject msgPrev;
    private CheckBoxTreeObject msgIni;
    private CheckBoxTreeObject msgEnd;
    private CheckBoxTreeObject msgErr;
    private CheckBoxTreeObject repInclude;
    private CheckBoxTreeObject repActions;
    private CheckBoxTreeObject skin;
    private CheckBoxTreeObject evSounds;
    private CheckBoxTreeObject cTime;
    private CheckBoxTreeObject maxTime;
    private CheckBoxTreeObject cTries;
    private CheckBoxTreeObject maxTries;
    private CheckBoxTreeObject cScore;
    private CheckBoxTreeObject scramble;
    private CheckBoxTreeObject helpBtn;
    private CheckBoxTreeObject infoBtn;
    private CheckBoxTreeObject gridA;
    private CheckBoxTreeObject gridB;
    private CheckBoxTreeObject textGrid;
    private CheckBoxTreeObject textFontFace;
    private CheckBoxTreeObject textFontSize;
    private CheckBoxTreeObject textStyle;
    private CheckBoxTreeObject textColour;
    private CheckBoxTreeObject targetColour;
    private CheckBoxTreeObject errorColour;
    private CheckBoxTreeObject tabSpace;
    private JList actList;
    private CheckBoxTree checkBoxTree;
    private JButton selectAllBtn;
    private JButton selectNoneBtn;

    public CopyActivityAttributesPanel(Options options, ActivityBagElementEditor activityBagElementEditor) {
        this.options = options;
        this.abed = activityBagElementEditor;
        this.abe = (ActivityBagEditor)activityBagElementEditor.getEditorParent();
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.checkBoxTree = new CheckBoxTree();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.actList = new JList();
        this.selectAllBtn = new JButton();
        this.selectNoneBtn = new JButton();
        this.setLayout(new BorderLayout());
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        this.checkBoxTree.setModel(this.getTreeModel());
        int n = this.checkBoxTree.getRowCount();
        for (int i = n + 1; i >= 0; --i) {
            this.checkBoxTree.expandRow(i);
        }
        jScrollPane.setViewportView(this.checkBoxTree);
        this.add((Component)jScrollPane, "Center");
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_copy_dest")));
        jScrollPane2.setPreferredSize(new Dimension(200, 300));
        this.actList.setModel(this.abe.getListModel());
        jScrollPane2.setViewportView(this.actList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        this.selectAllBtn.setText(this.options.getMsg("SELECT_ALL"));
        this.selectAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CopyActivityAttributesPanel.this.selectAllBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.selectAllBtn, gridBagConstraints);
        this.selectNoneBtn.setText(this.options.getMsg("SELECT_NONE"));
        this.selectNoneBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CopyActivityAttributesPanel.this.selectNoneBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.selectNoneBtn, gridBagConstraints);
        this.add((Component)jPanel, "East");
    }

    private void selectNoneBtnActionPerformed(ActionEvent actionEvent) {
        this.actList.clearSelection();
    }

    private void selectAllBtnActionPerformed(ActionEvent actionEvent) {
        this.actList.setSelectionInterval(0, this.actList.getModel().getSize() - 1);
    }

    public boolean showDialog(Component component) {
        boolean bl = false;
        if (this.options.getMessages().showInputDlg(component, this, "edit_act_copy_title")) {
            final Object[] objectArray = this.actList.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                this.options.getMessages().showAlert((Component)this, "edit_act_copy_err_noSelection");
            } else {
                ActivityEditor activityEditor = this.abed.getActivityEditor();
                activityEditor.collectData();
                final Activity activity = activityEditor.getActivity();
                final ProgressDialog progressDialog = new ProgressDialog(this, this.options);
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        int n = 0;
                        for (int i = 0; i < objectArray.length; ++i) {
                            ActivityBagElementEditor activityBagElementEditor = (ActivityBagElementEditor)objectArray[i];
                            if (activityBagElementEditor != CopyActivityAttributesPanel.this.abed) {
                                ActivityEditor activityEditor = activityBagElementEditor.getActivityEditor();
                                Activity activity2 = activityEditor.getActivity();
                                progressDialog.setFileLabel(activity2.name);
                                CopyActivityAttributesPanel.this.copyAttributes(activity, activity2);
                                progressDialog.setProgressValue(n++);
                                activityEditor.setModified(true);
                                activityBagElementEditor.forgetActivityEditor();
                            }
                            if (this.isCancelled() || Thread.currentThread().isInterrupted()) break;
                        }
                        return new Integer(n);
                    }

                    public void finished() {
                        progressDialog.setVisible(false);
                    }
                };
                progressDialog.setProgressMax(objectArray.length);
                progressDialog.start("WORKING", "edit_act_copy_action_prefix", swingWorker, true, true, false);
            }
        }
        return bl;
    }

    private TreeModel getTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_attributes"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_style_main"));
        this.bgColor = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgColor"), true);
        defaultMutableTreeNode2.add(this.bgColor);
        this.bgGradient = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gradient"), true);
        defaultMutableTreeNode2.add(this.bgGradient);
        this.bgImage = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgImage"), true);
        defaultMutableTreeNode2.add(this.bgImage);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_style_play"));
        this.activityBgColor = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgColor"), true);
        defaultMutableTreeNode2.add(this.activityBgColor);
        this.activityBgGradient = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gradient"), true);
        defaultMutableTreeNode2.add(this.activityBgGradient);
        this.transparentBg = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_transparentBg"), true);
        defaultMutableTreeNode2.add(this.transparentBg);
        this.border = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_border"), true);
        defaultMutableTreeNode2.add(this.border);
        this.margin = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_margin"), true);
        defaultMutableTreeNode2.add(this.margin);
        this.position = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_position"), false);
        defaultMutableTreeNode2.add(this.position);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_messages"));
        this.msgPrev = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_prev"), true);
        defaultMutableTreeNode2.add(this.msgPrev);
        this.msgIni = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_ini"), true);
        defaultMutableTreeNode2.add(this.msgIni);
        this.msgEnd = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_end"), true);
        defaultMutableTreeNode2.add(this.msgEnd);
        this.msgErr = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_err"), true);
        defaultMutableTreeNode2.add(this.msgErr);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_reports"));
        this.repInclude = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_rep_include"), false);
        defaultMutableTreeNode2.add(this.repInclude);
        this.repActions = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_rep_actions"), false);
        defaultMutableTreeNode2.add(this.repActions);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_interface"));
        this.skin = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_skin"), false);
        defaultMutableTreeNode2.add(this.skin);
        this.evSounds = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_evSounds"), false);
        defaultMutableTreeNode2.add(this.evSounds);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_counters"));
        this.cTime = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cTime"), true);
        defaultMutableTreeNode2.add(this.cTime);
        this.maxTime = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_maxTime"), false);
        defaultMutableTreeNode2.add(this.maxTime);
        this.cTries = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cTries"), true);
        defaultMutableTreeNode2.add(this.cTries);
        this.maxTries = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_maxTries"), false);
        defaultMutableTreeNode2.add(this.maxTries);
        this.cScore = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cScore"), true);
        defaultMutableTreeNode2.add(this.cScore);
        this.scramble = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_scramble"), false);
        defaultMutableTreeNode2.add(this.scramble);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_buttons"));
        this.helpBtn = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_btnHelp"), false);
        defaultMutableTreeNode2.add(this.helpBtn);
        this.infoBtn = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_btnInfo"), false);
        defaultMutableTreeNode2.add(this.infoBtn);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_grids"));
        this.gridA = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gridA"), true);
        defaultMutableTreeNode2.add(this.gridA);
        this.gridB = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gridB"), true);
        defaultMutableTreeNode2.add(this.gridB);
        this.textGrid = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textGrid"), true);
        defaultMutableTreeNode2.add(this.textGrid);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_text"));
        this.textFontFace = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontFace"), true);
        defaultMutableTreeNode2.add(this.textFontFace);
        this.textFontSize = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontSize"), true);
        defaultMutableTreeNode2.add(this.textFontSize);
        this.textStyle = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontStyle"), true);
        defaultMutableTreeNode2.add(this.textStyle);
        this.textColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textColour"), true);
        defaultMutableTreeNode2.add(this.textColour);
        this.targetColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textTargetColour"), true);
        defaultMutableTreeNode2.add(this.targetColour);
        this.errorColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textErrorColour"), true);
        defaultMutableTreeNode2.add(this.errorColour);
        this.tabSpace = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_tabSpace"), false);
        defaultMutableTreeNode2.add(this.tabSpace);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private void copyAttributes(Activity activity, Activity activity2) {
        if (this.bgColor.isSelected()) {
            activity2.bgColor = activity.bgColor;
        }
        if (this.bgGradient.isSelected()) {
            activity2.bgGradient = activity.bgGradient;
        }
        if (this.bgImage.isSelected()) {
            activity2.bgImageFile = activity.bgImageFile;
            activity2.tiledBgImg = activity.tiledBgImg;
        }
        if (this.margin.isSelected()) {
            activity2.margin = activity.margin;
        }
        if (this.activityBgColor.isSelected()) {
            activity2.activityBgColor = activity.activityBgColor;
        }
        if (this.activityBgGradient.isSelected()) {
            activity2.activityBgGradient = activity.activityBgGradient;
        }
        if (this.transparentBg.isSelected()) {
            activity2.transparentBg = activity.transparentBg;
        }
        if (this.border.isSelected()) {
            activity2.border = activity.border;
        }
        if (this.position.isSelected()) {
            activity2.absolutePositioned = activity.absolutePositioned;
            activity2.absolutePosition = activity.absolutePosition;
        }
        if (this.msgPrev.isSelected() && activity.messages[0] != null && activity2.messages[0] != null) {
            activity.messages[0].copyStyleTo(activity2.messages[0]);
        }
        if (this.msgIni.isSelected() && activity.messages[1] != null && activity2.messages[1] != null) {
            activity.messages[1].copyStyleTo(activity2.messages[1]);
        }
        if (this.msgEnd.isSelected() && activity.messages[2] != null && activity2.messages[2] != null) {
            activity.messages[2].copyStyleTo(activity2.messages[2]);
        }
        if (this.msgErr.isSelected() && activity.messages[3] != null && activity2.messages[3] != null) {
            activity.messages[3].copyStyleTo(activity2.messages[3]);
        }
        if (this.repInclude.isSelected()) {
            activity2.includeInReports = activity.includeInReports;
        }
        if (this.repActions.isSelected()) {
            activity2.reportActions = activity.reportActions;
        }
        if (this.skin.isSelected()) {
            activity2.skinFileName = activity.skinFileName;
        }
        if (this.evSounds.isSelected()) {
            activity2.eventSounds = activity.eventSounds;
        }
        if (this.cTime.isSelected()) {
            activity2.bTimeCounter = activity.bTimeCounter;
        }
        if (this.maxTime.isSelected()) {
            activity2.maxTime = activity.maxTime;
            activity2.countDownTime = activity.countDownTime;
        }
        if (this.cTries.isSelected()) {
            activity2.bActionsCounter = activity.bActionsCounter;
        }
        if (this.maxTries.isSelected()) {
            activity2.maxActions = activity.maxActions;
            activity2.countDownActions = activity.countDownActions;
        }
        if (this.cScore.isSelected()) {
            activity2.bScoreCounter = activity.bScoreCounter;
        }
        if (this.scramble.isSelected()) {
            activity2.shuffles = activity.shuffles;
        }
        if (this.helpBtn.isSelected()) {
            activity2.helpWindow = activity.helpWindow;
            activity2.showSolution = activity.showSolution;
        }
        if (this.infoBtn.isSelected()) {
            activity2.infoUrl = activity.infoUrl;
            activity2.infoCmd = activity.infoCmd;
        }
        if (this.gridA.isSelected() && activity.abc != null && activity.abc.length > 0 && activity.abc[0] != null && activity2.abc != null && activity2.abc.length > 0 && activity2.abc[0] != null) {
            activity.abc[0].copyStyleTo(activity2.abc[0]);
        }
        if (this.gridB.isSelected() && activity.abc != null && activity.abc.length > 1 && activity.abc[1] != null && activity2.abc != null && activity2.abc.length > 1 && activity2.abc[1] != null) {
            activity.abc[1].copyStyleTo(activity2.abc[1]);
        }
        if (this.textGrid.isSelected() && activity.tgc != null && activity2.tgc != null) {
            activity.tgc.copyStyleTo(activity2.tgc);
        }
        if (activity instanceof TextActivityBase && activity2 instanceof TextActivityBase) {
            TextActivityBase textActivityBase = (TextActivityBase)activity;
            TextActivityBase textActivityBase2 = (TextActivityBase)activity2;
            if (this.textFontFace.isSelected() || this.textFontSize.isSelected() || this.textStyle.isSelected() || this.textColour.isSelected() || this.targetColour.isSelected() || this.errorColour.isSelected() || this.tabSpace.isSelected()) {
                StyleContext styleContext = TextActivityDocument.copyStylesFrom(textActivityBase.getStyleContext(), textActivityBase2.getStyleContext(), this.textFontFace.isSelected(), this.textFontSize.isSelected(), this.textStyle.isSelected(), this.textColour.isSelected(), this.targetColour.isSelected(), this.errorColour.isSelected());
                if (styleContext != null) {
                    textActivityBase2.setStyleContext(styleContext);
                }
                if (this.tabSpace.isSelected()) {
                    textActivityBase2.getDocument().setTabSpc(textActivityBase.getDocument().getTabSpc());
                }
            }
        }
    }
}

