/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.AppletHtmlCreator;
import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.TestPlayerContainer;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagEditorPanel;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.jclic.project.NewProjectDlg;
import edu.xtec.jclic.project.ProjectInstallerEditPanel;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.JDomTreePanel;
import edu.xtec.util.KJMenuItem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Document;
import org.jdom.Element;

public class AuthorSingleFrame
extends JPanel
implements ResourceBridge,
TestPlayerContainer,
RunnableComponent,
Constants,
ActionListener {
    protected Options options;
    protected Messages messages;
    protected JClicProject project;
    protected JFrame debugFrame = null;
    protected int recentFilesOffset;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu recentFilesMenu;
    protected JMenu toolsMenu;
    protected JMenu helpMenu;
    protected JMenu editMenu;
    protected JMenu insertMenu;
    protected JMenu viewMenu;
    protected AuthorSettings settings;
    protected Player player;
    protected JTabbedPane tabbedPane;
    protected Action[] actions;
    protected Action[] projectActions;
    private SwingWorker worker = null;
    protected JDialog playerDlg;
    protected JClicProjectEditor projectEditor;
    protected EditorPanel mediaBagEditorPanel;
    protected EditorPanel activityBagEditorPanel;
    protected EditorPanel activitySequenceEditorPanel;
    protected EditorPanel projectSettingsEditorPanel;
    protected ProgressDialog progressDialog;
    public static final String MESSAGES_BUNDLE = "messages.AuthorMessages";
    public static final int ACTION_OPEN_FILE = 0;
    public static final int ACTION_OPEN_URL = 1;
    public static final int ACTION_SAVE_FILE = 2;
    public static final int ACTION_SAVE_FILE_AS = 3;
    public static final int ACTION_EXIT = 4;
    public static final int ACTION_SETTINGS = 5;
    public static final int ACTION_DOCTREE = 6;
    public static final int ACTION_ABOUT = 7;
    public static final int ACTION_NEW_PROJECT = 8;
    public static final int ACTION_EDIT_PROJECT = 9;
    public static final int ACTION_EDIT_MEDIA = 10;
    public static final int ACTION_EDIT_ACTIVITIES = 11;
    public static final int ACTION_EDIT_SEQ = 12;
    public static final int ACTION_CREATE_HTML = 13;
    public static final int ACTION_CREATE_INSTALLER = 14;
    public static final int ACTION_IMPORT_ACTIVITIES = 15;
    public static final int NUM_ACTIONS = 16;
    public static final String[] ACTION_NAME = new String[]{"openFile", "openUrl", "saveFile", "saveFileAs", "exit", "settings", "docTree", "helpAbout", "newProject", "editProject", "editMedia", "editActivities", "editSeq", "createHTML", "createInstaller", "importActivities"};
    public static final String[] ACTION_ICONS = new String[]{"icons/file_open.gif", "icons/world.gif", "icons/file_save.gif", "icons/file_save_as.gif", "icons/exit_small.gif", "icons/settings.gif", "icons/tree.gif", "icons/help.gif", "icons/project_new.gif", "icons/project_settings.gif", "icons/media_bag.gif", "icons/miniclic.png", "icons/sequence.gif", "icons/html_doc.gif", "icons/installer.gif", "icons/import_act.png"};
    static boolean saveResult;
    private EditorPanel lastFocusedPanel;
    protected FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            if (AuthorSingleFrame.this.playerDlg != null && AuthorSingleFrame.this.playerDlg.isShowing()) {
                AuthorSingleFrame.this.playerDlg.requestFocus();
            } else {
                AuthorSingleFrame.this.checkTabbedPaneFocus(false);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            AuthorSingleFrame.this.checkTabbedPaneFocus(true);
        }
    };

    public AuthorSingleFrame(Options options) {
        this.options = options;
        this.setLayout(new BorderLayout());
        this.init();
    }

    protected void init() {
        this.settings = AuthorSettings.loadAuthorSettings(this);
        this.options.setLookAndFeel();
        Utils.checkRenderingHints(this.options);
        CheckMediaSystem.check(this.options, false);
        this.setMessages();
        this.buildActions();
        this.setActionsText();
        this.progressDialog = new ProgressDialog(this, this.options);
        ActiveBox.compressImages = this.options.getBoolean("compressImages", true);
        this.createFrames();
    }

    public void activate() {
        this.focusListener.focusGained(null);
    }

    public InputStream getProgressInputStream(InputStream inputStream, int n, String string) {
        return this.progressDialog == null ? inputStream : this.progressDialog.getProgressInputStream(inputStream, n, string);
    }

    public Options getOptions() {
        return this.options;
    }

    public String getMsg(String string) {
        return this.messages.get(string);
    }

    public JComponent getComponent() {
        return this;
    }

    public void addTo(RootPaneContainer rootPaneContainer, Object object) {
        rootPaneContainer.setContentPane(this);
        this.checkMenu(false);
    }

    public boolean start(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = this.load(string, string2);
        }
        return bl;
    }

    public void stop() {
    }

    public void end() {
    }

    public Messages setMessages() {
        this.messages = Messages.getMessages(this.options, "messages.JClicMessages");
        this.messages.addBundle("commonSettings");
        this.messages.addBundle("messages.PlayerMessages");
        this.messages.addBundle(MESSAGES_BUNDLE);
        this.setLocale(this.messages.getLocale());
        return this.messages;
    }

    public boolean load(String string, String string2) {
        this.load(string, string2, null);
        return true;
    }

    public void load(final String string, final String string2, final String string3) {
        if (this.worker != null) {
            return;
        }
        if (string != null && this.project != null) {
            if (this.project != null) {
                this.project.mediaBag.clearData();
            }
            if (this.player != null) {
                this.player.activeMediaBag.removeAll();
            }
            System.gc();
        }
        this.worker = new SwingWorker(){
            ActivityBagElement abe = null;
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;
            String fullPath = null;
            String sequence = null;
            String activityName = null;
            boolean imported = false;

            public Object construct() {
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.fullPath = Clic3.pacNameToLowerCase(string);
                    this.sequence = Clic3.pacNameToLowerCase(string2);
                    this.activityName = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    while (!bl2 && !this.isCancelled()) {
                        Object object;
                        Object object2;
                        FileSystem fileSystem;
                        String string4 = this.fullPath != null ? this.fullPath : (this.sequence != null ? this.sequence : this.activityName);
                        AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("msg_loading") + " " + string4);
                        FileSystem fileSystem2 = fileSystem = AuthorSingleFrame.this.project == null ? AuthorSingleFrame.this.createFileSystem() : AuthorSingleFrame.this.project.getFileSystem();
                        if (this.fullPath != null) {
                            if (fileSystem != null) {
                                this.fullPath = fileSystem.getUrl(this.fullPath);
                                if (this.fullPath.startsWith("file://")) {
                                    this.fullPath = this.fullPath.substring(7);
                                }
                            }
                            if (this.sequence == null) {
                                this.sequence = "0";
                            }
                            object2 = null;
                            if (this.fullPath.endsWith(".jclic.zip")) {
                                fileSystem = FileSystem.createFileSystem(this.fullPath, this.thisAuthor);
                                object = ((ZipFileSystem)fileSystem).getEntries(".jclic");
                                if (object == null) {
                                    throw new Exception("File " + this.fullPath + " does not contain any jclic project");
                                }
                                object2 = object[0];
                            } else {
                                fileSystem = new FileSystem(FileSystem.getPathPartOf(this.fullPath), this.thisAuthor);
                                object2 = FileSystem.getFileNameOf(this.fullPath);
                            }
                            if (((String)object2).endsWith(".jclic")) {
                                object = fileSystem.getXMLDocument((String)object2);
                                System.gc();
                                AuthorSingleFrame.this.setProject(JClicProject.getJClicProject(((Document)object).getRootElement(), this.thisAuthor, fileSystem, this.fullPath));
                            } else {
                                this.sequence = object2;
                                AuthorSingleFrame.this.setProject(new JClicProject(this.thisAuthor, fileSystem, this.fullPath));
                            }
                        }
                        if (this.sequence != null) {
                            int n;
                            object2 = null;
                            object = FileSystem.stdFn(this.sequence);
                            if (AuthorSingleFrame.this.project != null) {
                                object2 = AuthorSingleFrame.this.project.activitySequence.getElementByTag((String)object, true);
                            }
                            if (object2 == null && AuthorSingleFrame.this.project != null && (n = StrUtils.getAbsIntValueOf((String)object)) >= 0) {
                                object2 = AuthorSingleFrame.this.project.activitySequence.getElement(n, true);
                            }
                            if (object2 == null && AuthorSingleFrame.this.project != null) {
                                n = AuthorSingleFrame.this.project.activitySequence.getSize() == 0 ? 1 : 0;
                                boolean bl3 = ((String)object).endsWith(".pcc");
                                boolean bl4 = ((String)object).endsWith(".pac");
                                if (bl3 || bl4) {
                                    this.imported = true;
                                    if (bl3) {
                                        String string22 = fileSystem.root + (String)object;
                                        fileSystem = FileSystem.createFileSystem(string22, this.thisAuthor);
                                        if (n != 0) {
                                            AuthorSingleFrame.this.project.setFileSystem(fileSystem);
                                            AuthorSingleFrame.this.project.setFullPath(string22);
                                        } else {
                                            AuthorSingleFrame.this.setProject(new JClicProject(this.thisAuthor, fileSystem, string22));
                                        }
                                        n = 1;
                                        Clic3.readPccFile(AuthorSingleFrame.this.project);
                                        object2 = AuthorSingleFrame.this.project.activitySequence.getCurrentAct();
                                    } else if (bl4) {
                                        Clic3.addPacToSequence(AuthorSingleFrame.this.project, (String)object);
                                        object2 = AuthorSingleFrame.this.project.activitySequence.getElementByTag((String)object, true);
                                    }
                                    if (n != 0) {
                                        AuthorSingleFrame.this.project.setName((String)object);
                                    }
                                }
                            }
                            if (object2 != null) {
                                this.activityName = ((ActivitySequenceElement)object2).getActivityName();
                            }
                        }
                        if (this.activityName != null && AuthorSingleFrame.this.project != null) {
                            object2 = FileSystem.stdFn(this.activityName);
                            this.abe = AuthorSingleFrame.this.project.activityBag.getElement((String)object2);
                        }
                        this.fullPath = null;
                        this.sequence = null;
                        this.activityName = null;
                        if (AuthorSingleFrame.this.project != null) {
                            AuthorSingleFrame.this.project.activitySequence.checkAllElements();
                        }
                        if (AuthorSingleFrame.this.project != null) {
                            object2 = new HashMap();
                            AuthorSingleFrame.this.project.activityBag.listReferences("sequence", (HashMap)object2);
                            AuthorSingleFrame.this.project.activityBag.listReferences("activity", (HashMap)object2);
                            AuthorSingleFrame.this.project.activitySequence.listReferences(null, (HashMap)object2);
                            object = ((HashMap)object2).keySet().iterator();
                            while (object.hasNext() && !this.isCancelled()) {
                                String string32 = (String)object.next();
                                if ("sequence".equals(((HashMap)object2).get(string32))) {
                                    if (AuthorSingleFrame.this.project.activitySequence.getElementByTag(string32, false) != null) continue;
                                    this.sequence = Clic3.pacNameToLowerCase(string32);
                                    break;
                                }
                                if (AuthorSingleFrame.this.project.activityBag.activityExists(string32)) continue;
                                this.activityName = string32;
                                break;
                            }
                        }
                        if (this.fullPath == null && this.sequence == null && this.activityName == null) {
                            bl2 = true;
                            break;
                        }
                        if (!bl) {
                            boolean bl5 = bl = AuthorSingleFrame.this.messages.showQuestionDlg(AuthorSingleFrame.this.progressDialog, "msg_prompt_loadReferences", null, "yn") == 1;
                            if (!bl) {
                                bl2 = true;
                                break;
                            }
                        }
                        this.abe = null;
                    }
                    if (AuthorSingleFrame.this.project != null && !this.isCancelled()) {
                        AuthorSingleFrame.this.project.mediaBag.waitForAllImages();
                    }
                }
                catch (Exception exception) {
                    this.exception = exception;
                    System.err.println("Exception:" + exception);
                }
                AuthorSingleFrame.this.attachProject();
                if (this.imported && AuthorSingleFrame.this.projectEditor != null) {
                    AuthorSingleFrame.this.projectEditor.setModified(true);
                }
                return this.abe;
            }

            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    String string4 = null;
                    Vector<String> vector = new Vector<String>();
                    if (this.fullPath != null) {
                        vector.add(this.fullPath);
                        string4 = "msg_error_loading_project";
                    }
                    if (this.sequence != null) {
                        vector.add(this.sequence);
                        if (string4 == null) {
                            string4 = "msg_error_loading_sequence";
                        }
                    }
                    if (this.activityName != null) {
                        vector.add(this.activityName);
                        if (string4 == null) {
                            string4 = "msg_error_loading_activity";
                        }
                    }
                    if (string4 == null) {
                        string4 = "ERROR";
                    }
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "err_reading_data", vector, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "msg_loading_project", this.worker, true, true, false);
    }

    protected void setProject(JClicProject jClicProject) {
        if (this.project != null) {
            this.project.end();
        }
        this.project = jClicProject;
        Frame frame = JOptionPane.getFrameForComponent(this);
        if (frame != null) {
            StringBuffer stringBuffer = new StringBuffer("JClic author");
            if (this.project != null) {
                stringBuffer.append(" - ").append(this.project.getName());
            }
            frame.setTitle(stringBuffer.substring(0));
        }
        this.checkActions();
    }

    protected void checkActions() {
        if (this.projectActions != null) {
            for (int i = 0; i < this.projectActions.length; ++i) {
                this.projectActions[i].setEnabled(this.project != null);
            }
        }
    }

    protected FileSystem createFileSystem() {
        return this.settings.fileSystem;
    }

    protected void createMenu() {
        Editor.createBasicActions(this.options);
        MediaBagEditor.createActions(this.options);
        ActivityBagEditor.createBasicActions(this.options);
        ActivitySequenceEditor.createActions(this.options);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.get("m_File"));
        this.fileMenu.setMnemonic(this.messages.get("m_File_Mnemonic").charAt(0));
        this.fileMenu.add(new KJMenuItem(this.getAction(8)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(0)));
        this.fileMenu.add(new KJMenuItem(this.getAction(1)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(2)));
        this.fileMenu.add(new KJMenuItem(this.getAction(3)));
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(this.messages.get("m_Edit"));
        this.editMenu.setMnemonic(this.messages.get("m_Edit_Mnemonic").charAt(0));
        this.editMenu.add(new KJMenuItem(Editor.cutAction));
        this.editMenu.add(new KJMenuItem(Editor.copyAction));
        this.editMenu.add(new KJMenuItem(Editor.pasteAction));
        this.editMenu.add(new KJMenuItem(Editor.deleteAction));
        this.editMenu.addSeparator();
        this.editMenu.add(ActivityBagEditor.copyActivityAttributesAction);
        this.editMenu.addSeparator();
        this.editMenu.add(new KJMenuItem(Editor.moveUpAction));
        this.editMenu.add(new KJMenuItem(Editor.moveDownAction));
        this.menuBar.add(this.editMenu);
        this.insertMenu = new JMenu(this.messages.get("m_Insert"));
        this.insertMenu.setMnemonic(this.messages.get("m_Insert_Mnemonic").charAt(0));
        this.insertMenu.add(MediaBagEditor.newMediaBagElementAction);
        this.insertMenu.add(ActivityBagEditor.newActivityBagElementAction);
        this.insertMenu.add(ActivitySequenceEditor.newActivitySequenceElementAction);
        this.insertMenu.addSeparator();
        this.insertMenu.add(new KJMenuItem(this.getAction(15)));
        this.menuBar.add(this.insertMenu);
        this.toolsMenu = new JMenu(this.messages.get("m_Tools"));
        this.toolsMenu.setMnemonic(this.messages.get("m_Tools_Mnemonic").charAt(0));
        this.toolsMenu.add(new KJMenuItem(this.getAction(5)));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new KJMenuItem(this.getAction(6)));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new KJMenuItem(this.getAction(13)));
        this.toolsMenu.add(new KJMenuItem(this.getAction(14)));
        this.menuBar.add(this.toolsMenu);
        this.viewMenu = new JMenu(this.messages.get("m_View"));
        this.viewMenu.setMnemonic(this.messages.get("m_View_Mnemonic").charAt(0));
        this.viewMenu.add(new KJMenuItem(this.getAction(9)));
        this.viewMenu.add(new KJMenuItem(this.getAction(10)));
        this.viewMenu.add(new KJMenuItem(this.getAction(11)));
        this.viewMenu.add(new KJMenuItem(this.getAction(12)));
        this.viewMenu.addSeparator();
        this.viewMenu.add(ActivityBagElementEditor.testActivityAction);
        this.viewMenu.add(MediaBagElementEditor.testMediaBagElementAction);
        this.menuBar.add(this.viewMenu);
        this.helpMenu = new JMenu(this.messages.get("m_Help"));
        this.helpMenu.setMnemonic(this.messages.get("m_Help_Mnemonic").charAt(0));
        this.helpMenu.add(new KJMenuItem(this.getAction(7)));
        this.menuBar.add(this.helpMenu);
    }

    protected void postCreateMenu() {
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(4)));
        this.fileMenu.addSeparator();
        this.recentFilesMenu = this.fileMenu;
        this.recentFilesOffset = this.fileMenu.getItemCount();
        this.updateRecentFilesMenu();
    }

    protected void checkMenu(boolean bl) {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (bl || jRootPane.getJMenuBar() == null) {
            if (bl || this.menuBar == null) {
                this.createMenu();
                this.postCreateMenu();
            }
            jRootPane.setJMenuBar(this.menuBar);
            jRootPane.revalidate();
        }
    }

    protected void updateRecentFilesMenu() {
        if (this.recentFilesMenu != null && this.recentFilesOffset >= 0) {
            int n;
            int n2 = this.recentFilesMenu.getItemCount() - this.recentFilesOffset;
            for (n = 0; n < n2; ++n) {
                this.recentFilesMenu.remove(this.recentFilesOffset);
            }
            for (n = 0; n < PlayerSettings.MAX_RECENT; ++n) {
                if (this.settings.recentFiles[n] == null) continue;
                String string = this.settings.recentFiles[n];
                int n3 = string.lastIndexOf(92);
                if (n3 < 0) {
                    n3 = string.lastIndexOf(47);
                }
                if (n3 >= 0) {
                    string = string.substring(n3 + 1);
                }
                this.createMenuItem(this.recentFilesMenu, Integer.toString(n + 1) + ". " + string, "recent" + n, true, KeyStroke.getKeyStroke(49 + n, 8));
            }
        }
    }

    JMenuItem createMenuItem(JComponent jComponent, String string, String string2, boolean bl, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (string2 != null) {
            jMenuItem.setActionCommand(string2);
            jMenuItem.addActionListener(this);
        }
        if (bl) {
            jMenuItem.setMnemonic(jMenuItem.getText().charAt(0));
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jComponent.add(jMenuItem);
        return jMenuItem;
    }

    protected int getNumActions() {
        return 16;
    }

    protected void buildActions() {
        this.actions = new Action[this.getNumActions()];
        this.actions[0] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                int[] nArray;
                FileSystem fileSystem;
                String string2;
                if (AuthorSingleFrame.this.checkSaveChanges() && (string2 = (fileSystem = AuthorSingleFrame.this.settings.fileSystem).chooseFile(null, false, nArray = new int[]{5, 7, 4}, AuthorSingleFrame.this.options, null, AuthorSingleFrame.this, false)) != null && AuthorSingleFrame.this.load(string = fileSystem.getFullFileNamePath(string2), null)) {
                    AuthorSingleFrame.this.addRecentFile(string);
                }
            }
        };
        this.actions[1] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (AuthorSingleFrame.this.checkSaveChanges() && (string = AuthorSingleFrame.this.messages.showInputDlg((Component)AuthorSingleFrame.this, "URL_OPEN", "URL", "http://", "URL_OPEN", false)) != null) {
                    if ((string = string.trim()).startsWith("http://http://")) {
                        string = string.substring(7);
                    }
                    if (string.length() > 0 && !string.equals("http://") && AuthorSingleFrame.this.load(string, null)) {
                        AuthorSingleFrame.this.addRecentFile(string);
                    }
                }
            }
        };
        this.actions[2] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthorSingleFrame.this.saveFile(false);
            }
        };
        this.actions[3] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthorSingleFrame.this.saveFile(true);
            }
        };
        this.actions[4] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthorSingleFrame.this.exit();
            }
        };
        this.actions[5] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AuthorSingleFrame.this.options.getString("lookAndFeel");
                String string2 = AuthorSingleFrame.this.options.getString("language");
                String string3 = AuthorSingleFrame.this.options.getString("country");
                String string4 = AuthorSingleFrame.this.options.getString("variant");
                String string5 = AuthorSingleFrame.this.settings.mediaSystem;
                if (AuthorSingleFrame.this.settings.edit(AuthorSingleFrame.this)) {
                    AuthorSingleFrame.this.settings.save();
                    AuthorSingleFrame.this.options.syncProperties(AuthorSingleFrame.this.settings.getProperties(), false);
                    boolean bl = false;
                    if (!AuthorSingleFrame.this.settings.lookAndFeel.equals(string)) {
                        AuthorSingleFrame.this.options.setLookAndFeel();
                        bl = true;
                    }
                    if (!(AuthorSingleFrame.this.settings.language == null || StrUtils.compareObjects(AuthorSingleFrame.this.settings.language, string2) && StrUtils.compareObjects(AuthorSingleFrame.this.settings.country, string3) && StrUtils.compareObjects(AuthorSingleFrame.this.settings.variant, string4))) {
                        AuthorSingleFrame.this.setMessages();
                        bl = true;
                    }
                    if (bl) {
                        AuthorSingleFrame.this.checkMenu(true);
                    }
                    if (!string5.equals(AuthorSingleFrame.this.settings.mediaSystem)) {
                        AuthorSingleFrame.this.options.put("mediaSystem", AuthorSingleFrame.this.settings.mediaSystem);
                        CheckMediaSystem.check(AuthorSingleFrame.this.options, false);
                    }
                }
            }
        };
        this.actions[6] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Element element;
                if (AuthorSingleFrame.this.project != null && (element = JDomTreePanel.editElement(AuthorSingleFrame.this, AuthorSingleFrame.this.project.getJDomElement(), AuthorSingleFrame.this, AuthorSingleFrame.this.project.getFileSystem(), AuthorSingleFrame.this.project.getName(), "edit_docTree_title")) != null) {
                    try {
                        String string = AuthorSingleFrame.this.project.getFullPath();
                        JClicProject jClicProject = JClicProject.getJClicProject(element, AuthorSingleFrame.this, FileSystem.createFileSystem(string, AuthorSingleFrame.this), string);
                        if (jClicProject != null) {
                            AuthorSingleFrame.this.setProject(jClicProject);
                            AuthorSingleFrame.this.attachProject();
                            AuthorSingleFrame.this.projectEditor.setModified(true);
                        }
                    }
                    catch (Exception exception) {
                        AuthorSingleFrame.this.messages.showErrorWarning(AuthorSingleFrame.this, "edit_tree_badFormat", exception);
                    }
                }
            }
        };
        this.actions[15] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray;
                FileSystem fileSystem;
                String string;
                if (AuthorSingleFrame.this.project != null && (string = (fileSystem = AuthorSingleFrame.this.settings.fileSystem).chooseFile(null, false, nArray = new int[]{4}, AuthorSingleFrame.this.options, "import_selectProject", AuthorSingleFrame.this, false)) != null) {
                    String string2 = fileSystem.getFullFileNamePath(string);
                    if (new File(AuthorSingleFrame.this.project.getFileSystem().getFullRoot()).equals(new File(string2))) {
                        AuthorSingleFrame.this.messages.showAlert((Component)AuthorSingleFrame.this, "import_warn_samefile");
                    } else {
                        AuthorSingleFrame.this.doImportActivities(string2);
                    }
                }
            }
        };
        this.actions[7] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutWindow aboutWindow = new AboutWindow((Component)AuthorSingleFrame.this, AuthorSingleFrame.this, new Dimension(500, 400));
                try {
                    aboutWindow.buildAboutTab("JClic author", AuthorSingleFrame.this.getMsg("AUTHOR_VERSION"), "logo_author_small.png", null, null, null, null);
                    aboutWindow.buildStandardTab(aboutWindow.getHtmlSystemInfo(), "about_window_systemInfo", "about_window_lb_system", "icons/system_small.gif");
                    aboutWindow.setVisible(true);
                }
                catch (Exception exception) {
                    System.err.println("Error building about window: " + exception);
                }
            }
        };
        this.actions[8] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JClicProject jClicProject;
                if (AuthorSingleFrame.this.checkSaveChanges() && (jClicProject = NewProjectDlg.prompt(AuthorSingleFrame.this, AuthorSingleFrame.this, AuthorSingleFrame.this.createFileSystem())) != null) {
                    AuthorSingleFrame.this.setProject(jClicProject);
                    AuthorSingleFrame.this.attachProject();
                }
            }
        };
        this.actions[9] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.projectSettingsEditorPanel);
                }
            }
        };
        this.actions[10] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.mediaBagEditorPanel);
                }
            }
        };
        this.actions[11] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.activityBagEditorPanel);
                }
            }
        };
        this.actions[12] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.activitySequenceEditorPanel);
                }
            }
        };
        this.actions[13] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.checkSaveChanges()) {
                    AppletHtmlCreator.createHtml(AuthorSingleFrame.this.project, AuthorSingleFrame.this.settings, AuthorSingleFrame.this);
                }
            }
        };
        this.actions[14] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AuthorSingleFrame.this.checkSaveChanges()) {
                    ProjectInstallerEditPanel.createInstaller(AuthorSingleFrame.this.project, AuthorSingleFrame.this);
                }
            }
        };
        this.projectActions = new Action[]{this.actions[2], this.actions[3], this.actions[6], this.actions[12], this.actions[11], this.actions[10], this.actions[9], this.actions[13], this.actions[14], this.actions[15]};
        this.checkActions();
    }

    protected boolean saveFile(boolean bl) {
        boolean bl2 = false;
        if (this.project != null && this.projectEditor.checkProject(this.options, this, true)) {
            int[] nArray = new int[]{1};
            FileSystem fileSystem = this.project.getFileSystem();
            String string = StrUtils.secureString(this.project.getFullPath(), this.project.getName() + ".jclic.zip");
            String string2 = string.toLowerCase();
            if (!string2.endsWith(".jclic.zip")) {
                if (string2.endsWith(".jclic")) {
                    string = string + ".zip";
                } else if (string2.endsWith(".pac") || string2.endsWith(".pcc")) {
                    int n = string.lastIndexOf(46);
                    if (n >= 1) {
                        string = string.substring(0, n);
                    }
                    string = string + ".jclic.zip";
                }
            }
            String string3 = null;
            File file = new File(string);
            string3 = !bl && file.exists() && file.canWrite() ? string : fileSystem.chooseFile(string, true, nArray, this.options, null, this, false);
            if (string3 != null) {
                bl2 = this.doSaveFile(string3);
            }
        }
        return bl2;
    }

    protected boolean doSaveFile(final String string) {
        if (this.worker != null) {
            return false;
        }
        saveResult = false;
        this.worker = new SwingWorker(){
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;

            public Object construct() {
                Boolean bl = null;
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    AuthorSingleFrame.this.projectEditor.saveProject(string);
                    saveResult = true;
                    AuthorSingleFrame.this.addRecentFile(AuthorSingleFrame.this.project.getFullPath());
                    bl = new Boolean(true);
                }
                catch (Exception exception) {
                    this.exception = exception;
                }
                return bl;
            }

            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "FILE_ERR_SAVING", string, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "msg_saving_project", this.worker, true, false, true);
        return saveResult;
    }

    protected void doImportActivities(final String string) {
        if (this.worker != null) {
            return;
        }
        System.gc();
        this.worker = new SwingWorker(){
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;

            public Object construct() {
                Boolean bl = null;
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JClicProject jClicProject = JClicProject.getJClicProject(this.thisAuthor, string, AuthorSingleFrame.this.progressDialog);
                    if (jClicProject != null) {
                        AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_importing"));
                        JClicProjectEditor jClicProjectEditor = (JClicProjectEditor)jClicProject.getEditor(null);
                        JList<ActivityBagElement> jList = new JList<ActivityBagElement>(jClicProject.activityBag.getElements());
                        JScrollPane jScrollPane = new JScrollPane(jList);
                        jScrollPane.setPreferredSize(new Dimension(300, 300));
                        if (AuthorSingleFrame.this.messages.showInputDlg((Component)this.thisAuthor, new String[]{"import_selectActivities"}, new String[0], new JComponent[]{jScrollPane}, "action_importActivities_caption") && jList.getSelectedIndices().length > 0) {
                            Object object;
                            int n;
                            Object object2;
                            Object object3;
                            Object object4;
                            AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_checkdep"));
                            Object[] objectArray = jList.getSelectedValues();
                            Vector<Object> vector = new Vector<Object>();
                            for (int i = 0; i < objectArray.length; ++i) {
                                ActivityBagElement activityBagElement = (ActivityBagElement)objectArray[i];
                                object4 = activityBagElement.getReferences();
                                object3 = ((HashMap)object4).keySet().iterator();
                                while (object3.hasNext()) {
                                    object2 = (String)object3.next();
                                    Object v = ((HashMap)object4).get(object2);
                                    if (!"media".equals(v) || vector.contains(object2)) continue;
                                    vector.add(object2);
                                }
                            }
                            Vector<Object> vector2 = new Vector<Object>();
                            for (n = 0; n < vector.size(); ++n) {
                                object4 = jClicProject.mediaBag.getElement((String)vector.get(n));
                                if (object4 == null) continue;
                                vector2.add(object4);
                            }
                            for (n = 0; n < vector2.size(); ++n) {
                                object4 = (MediaBagElement)vector2.get(n);
                                object2 = object3 = ((MediaBagElement)object4).getName();
                                AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_impmedia") + " " + (String)object3);
                                int n2 = 0;
                                while (AuthorSingleFrame.this.project.mediaBag.getElement((String)object3) != null) {
                                    object3 = "i0" + Integer.toString(++n2) + "-" + (String)object2;
                                }
                                object = ((MediaBagElement)object4).getFileName();
                                String string2 = object;
                                n2 = 0;
                                while (AuthorSingleFrame.this.project.getFileSystem().fileExists((String)object)) {
                                    object = "i0" + Integer.toString(++n2) + "-" + string2;
                                }
                                File file = new File(AuthorSingleFrame.this.project.getFileSystem().getFullFileNamePath((String)object));
                                file.getParentFile().mkdirs();
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                StreamIO.writeStreamTo(jClicProject.mediaBag.getInputStream(((MediaBagElement)object4).getName()), fileOutputStream);
                                if (!((String)object3).equals(object2)) {
                                    jClicProjectEditor.getActivityBagEditor().nameChanged(18416, (String)object2, (String)object3);
                                    ((MediaBagElement)object4).setName((String)object3);
                                }
                                if (!((String)object).equals(string2)) {
                                    ((MediaBagElement)object4).setFileName((String)object);
                                }
                                ((MediaBagElement)object4).setData(null);
                                AuthorSingleFrame.this.projectEditor.getMediaBagEditor().addMediaBagElement((MediaBagElement)object4);
                            }
                            for (n = 0; n < objectArray.length; ++n) {
                                object4 = (ActivityBagElement)objectArray[n];
                                object2 = object3 = ((ActivityBagElement)object4).toString();
                                AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_impact") + " " + (String)object3);
                                int n3 = 0;
                                while (AuthorSingleFrame.this.project.activityBag.getElementByName((String)object3) != null) {
                                    object3 = "i0" + Integer.toString(++n3) + (String)object2;
                                }
                                if (!((String)object3).equals(object2)) {
                                    jClicProjectEditor.nameChanged(1, (String)object2, (String)object3);
                                }
                                object = (ActivityBagElementEditor)((ActivityBagElement)object4).getEditor(null);
                                AuthorSingleFrame.this.projectEditor.getActivityBagEditor().insertEditor((Editor)object, true, -1, false);
                            }
                            bl = new Boolean(true);
                        }
                    }
                }
                catch (Exception exception) {
                    this.exception = exception;
                }
                return bl;
            }

            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "FILE_ERR_OPENING", string, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "import_importing", this.worker, true, false, true);
    }

    protected void setActionsText() {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                Icon icon;
                if (this.actions[i] == null) continue;
                String string = this.messages.get("action_" + this.getActionName(i) + "_caption");
                if (!string.equals(this.actions[i].getValue("Name"))) {
                    this.actions[i].putValue("Name", string);
                }
                if (!(string = this.messages.get("action_" + this.getActionName(i) + "_tooltip")).equals(this.actions[i].getValue("ShortDescription"))) {
                    this.actions[i].putValue("ShortDescription", string);
                }
                if ((string = this.messages.get("action_" + this.getActionName(i) + "_keys")) != null && string.length() == 2) {
                    this.actions[i].putValue("MnemonicKey", new Integer(string.charAt(0)));
                    if (string.charAt(1) != '*') {
                        this.actions[i].putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)string.charAt(1), 2));
                    }
                }
                if ((icon = this.getActionIcon(i)) == null || icon.equals(this.actions[i].getValue("SmallIcon"))) continue;
                this.actions[i].putValue("SmallIcon", icon);
            }
        }
    }

    protected String getActionName(int n) {
        if (n < 0 || n >= ACTION_NAME.length) {
            return null;
        }
        return ACTION_NAME[n];
    }

    protected Icon getActionIcon(int n) {
        if (n < 0 || n >= ACTION_ICONS.length) {
            return null;
        }
        return ResourceManager.getImageIcon(ACTION_ICONS[n]);
    }

    public Action getAction(int n) {
        if (this.actions == null || n < 0 || n >= this.actions.length) {
            return null;
        }
        return this.actions[n];
    }

    protected boolean processActionEvent(String string) {
        if (string.startsWith("recent") && string.length() > 6) {
            try {
                int n = Integer.parseInt(string.substring(6));
                if (n >= 0 && n < PlayerSettings.MAX_RECENT && this.settings.recentFiles[n] != null && this.checkSaveChanges()) {
                    this.load(this.settings.recentFiles[n], null);
                }
            }
            catch (Exception exception) {
                System.err.println("invalid command: " + string);
            }
        } else {
            return !this.isEnabled();
        }
        return true;
    }

    protected void addRecentFile(String string) {
        this.settings.addRecentFile(string);
        this.updateRecentFilesMenu();
        this.settings.save();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            this.processActionEvent(string);
        }
    }

    public void exit() {
        if (this.checkSaveChanges()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (AuthorSingleFrame.this.options.getApplet() == null) {
                        try {
                            AuthorSingleFrame.this.end();
                            Frame frame = JOptionPane.getFrameForComponent(AuthorSingleFrame.this);
                            if (frame != null) {
                                frame.dispose();
                            } else {
                                System.exit(0);
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Unable to exit!\n" + exception);
                        }
                    }
                }
            });
        }
    }

    protected void attachProject() {
        this.lastFocusedPanel = null;
        if (this.projectSettingsEditorPanel != null && this.mediaBagEditorPanel != null && this.activityBagEditorPanel != null && this.activitySequenceEditorPanel != null) {
            if (this.project != null) {
                this.project.activityBag.sortByName();
            }
            this.projectEditor = this.project == null ? null : (JClicProjectEditor)this.project.getEditor(null);
            this.projectSettingsEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getProjectSettingsEditor(), true);
            this.mediaBagEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getMediaBagEditor(), true);
            this.activityBagEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getActivityBagEditor(), true);
            this.activitySequenceEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getActivitySequenceEditor(), true);
            if (this.project != null) {
                this.player.setProject(this.project);
                this.player.getHistory().clearHistory();
            }
            this.projectEditor.setTestPlayerContainer(this);
        }
        this.actions[6].setEnabled(this.project != null);
    }

    protected void checkTabbedPaneFocus(boolean bl) {
        if (this.tabbedPane != null) {
            Component component = this.tabbedPane.getSelectedComponent();
            if (!bl && component instanceof EditorPanel) {
                if (this.lastFocusedPanel != null) {
                    this.lastFocusedPanel.focusLost(null);
                }
                this.lastFocusedPanel = (EditorPanel)component;
                this.lastFocusedPanel.focusGained(null);
            } else {
                Editor.clearBasicActionsOwner();
            }
        }
    }

    protected void createFrames() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AuthorSingleFrame.this.checkTabbedPaneFocus(false);
            }
        });
        JClicProject jClicProject = new JClicProject(this, new FileSystem(this), "");
        this.projectEditor = (JClicProjectEditor)jClicProject.getEditor(null);
        ProjectSettingsEditor projectSettingsEditor = this.projectEditor.getProjectSettingsEditor();
        this.projectSettingsEditorPanel = projectSettingsEditor.createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_project"), JClicProjectEditor.getIcon(), this.projectSettingsEditorPanel, this.messages.get("edit_project_tooltip"));
        this.mediaBagEditorPanel = new MediaBagMultiEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_media"), MediaBagEditor.getIcon(), this.mediaBagEditorPanel, this.messages.get("edit_media_tooltip"));
        ActivityBagEditor activityBagEditor = this.projectEditor.getActivityBagEditor();
        this.activityBagEditorPanel = activityBagEditor.createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_activities"), ActivityEditor.getIcon(), this.activityBagEditorPanel, this.messages.get("edit_activities_tooltip"));
        this.activitySequenceEditorPanel = this.projectEditor.getActivitySequenceEditor().createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_sequences"), ActivitySequenceEditor.getIcon(), this.activitySequenceEditorPanel, this.messages.get("edit_sequences_tooltip"));
        this.playerDlg = new JDialog(JOptionPane.getFrameForComponent(this), "test player", true);
        this.player = new Player(this.options, jClicProject);
        this.player.getHistory().setTestMode(true);
        this.player.appName = "JClic test player";
        this.player.addTo(this.playerDlg, null);
        this.playerDlg.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                AuthorSingleFrame.this.player.closeHelpWindow();
                AuthorSingleFrame.this.player.removeActivity();
            }
        });
        this.playerDlg.pack();
        this.add((Component)this.tabbedPane, "Center");
    }

    public Player getTestPlayer() {
        return this.player;
    }

    public void test() {
        if (this.playerDlg != null && this.player != null) {
            this.player.initReporter();
            if (this.player.reporter != null && this.project != null) {
                this.player.reporter.newSession(this.project, this.player, this.messages);
            }
            this.playerDlg.setVisible(true);
        }
    }

    public boolean newInstanceRequest(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(AuthorSingleFrame.this);
                if (frame != null) {
                    frame.toFront();
                }
                AuthorSingleFrame.this.messages.showAlert((Component)AuthorSingleFrame.this, new String[]{"new instance request", string, string2});
            }
        });
        return true;
    }

    protected boolean checkSaveChanges() {
        boolean bl = true;
        if (this.projectEditor != null) {
            this.projectEditor.collectData();
            if (this.projectEditor.isModified()) {
                switch (this.messages.showQuestionDlg(this, "warn_project_modified", "CONFIRM", "ync")) {
                    case 1: {
                        bl = this.saveFile(false);
                        break;
                    }
                    case 5: {
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public boolean windowCloseRequested() {
        return this.checkSaveChanges();
    }

    public void displayUrl(String string, boolean bl) {
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            System.err.println("Unable to invoque URL " + string + "\n" + exception);
        }
    }

    public void editActivity(String string) {
        if (this.tabbedPane != null && this.activityBagEditorPanel != null && ((ActivityBagEditorPanel)this.activityBagEditorPanel).editActivity(string)) {
            this.tabbedPane.setSelectedComponent(this.activityBagEditorPanel);
        }
    }
}

