/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.servlet.RequestProcessor;
import edu.xtec.util.ResourceManager;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class ResourceRP
extends RequestProcessor {
    protected String objectName;
    protected byte[] objectData;
    public static final String ID = "id";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String RESOURCE_BASE = "html/";
    protected static HashMap objects = new HashMap();
    protected static String dateStr = ResourceRP.httpDate(new Date());

    public boolean noCache() {
        return false;
    }

    public boolean init() throws Exception {
        this.objectName = this.getParam(ID);
        if (this.objectName != null) {
            this.objectData = (byte[])objects.get(this.objectName);
            if (this.objectData == null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer(RESOURCE_BASE);
                    stringBuffer.append(this.objectName);
                    this.objectData = ResourceManager.getResourceBytes(stringBuffer.substring(0));
                    objects.put(this.objectName, this.objectData);
                }
                catch (Exception exception) {
                    this.errCode = 404;
                    this.errMsg = this.objectName + " not found!";
                }
            }
        } else {
            this.errCode = 400;
            this.errMsg = "Unespecified object id!";
        }
        return true;
    }

    public void header(Vector vector) {
        super.header(vector);
        if (this.objectData != null) {
            String string = null;
            if (this.objectName.endsWith(".gif")) {
                string = "image/gif";
            } else if (this.objectName.endsWith(".jpg")) {
                string = "text/jpg";
            } else if (this.objectName.endsWith(".css")) {
                string = "text/css";
            }
            if (string != null) {
                vector.add(new String[]{"CONTENT_TYPE", string});
            }
            vector.add(new String[]{"CONTENT_LENGTH", Integer.toString(this.objectData.length)});
            vector.add(new String[]{"EXTRA", LAST_MODIFIED, dateStr});
        }
    }

    public boolean usesWriter() {
        return false;
    }

    public void process(OutputStream outputStream) throws Exception {
        if (this.objectData != null) {
            outputStream.write(this.objectData, 0, this.objectData.length);
        }
    }
}

