/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.jclic.report.ReportUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public abstract class RequestProcessor {
    public static final String REDIRECT = "REDIRECT";
    public static final String CONTENT_TYPE = "CONTENT_TYPE";
    public static final String CONTENT_LENGTH = "CONTENT_LENGTH";
    public static final String COOKIE = "COOKIE";
    public static final String EXTRA = "EXTRA";
    public static final String ERROR = "ERROR";
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final String CHARSET = "ISO-8859-1";
    private HashMap params = new HashMap();
    private HashMap cookies = new HashMap();
    private HashMap headers = new HashMap();
    private InputStream inputStream = null;
    public int errCode = -1;
    public String errMsg = null;
    private static boolean DIRECT_RESOURCES;
    protected static HashMap properties;
    private static SimpleDateFormat HTTP_DF;

    public static void config(Map map) {
        if (map != null) {
            properties.putAll(map);
        }
    }

    public boolean init() throws Exception {
        return true;
    }

    public boolean usesWriter() {
        return true;
    }

    public boolean noCache() {
        return true;
    }

    public void process(OutputStream outputStream) throws Exception {
    }

    public void process(PrintWriter printWriter) throws Exception {
        this.startHead(printWriter);
        this.head(printWriter);
        this.endHead(printWriter);
        this.startBody(printWriter);
        this.body(printWriter);
        this.endBody(printWriter);
    }

    public void header(Vector vector) {
        if (this.cookies.size() > 0) {
            Iterator iterator = this.cookies.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.cookies.get(string);
                vector.add(new String[]{COOKIE, string, string2});
            }
        }
    }

    public void end() {
    }

    public boolean wantsInputStream() {
        return false;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getIntParam(String string, int n) {
        int n2 = n;
        String string2 = this.getParam(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public Date getDateParam(String string, Date date, boolean bl) {
        Date date2 = date;
        String string2 = this.getParam(string);
        if (string2 != null) {
            try {
                date2 = ReportUtils.strToDate(string2, bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date2;
    }

    public String getParamNotNull(String string) {
        String string2 = this.getParam(string, 0);
        if (string2 == null) {
            string2 = "";
        }
        return string2.trim();
    }

    public String getParam(String string) {
        return this.getParam(string, 0);
    }

    public Object[] getParams(String string) {
        return (Object[])this.params.get(string);
    }

    public String getParam(String string, int n) {
        String string2 = null;
        Object[] objectArray = (Object[])this.params.get(string);
        if (n >= 0 && objectArray != null && objectArray.length > n) {
            string2 = (String)objectArray[n];
        }
        return string2;
    }

    public void setParam(String string, String string2) {
        this.params.put(string, new String[]{string2});
    }

    public void setParam(String string, String[] stringArray) {
        this.params.put(string, stringArray);
    }

    public void setParams(Map map) {
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                if (k == null) continue;
                if (v instanceof String) {
                    this.setParam(k.toString(), (String)v);
                    continue;
                }
                if (!(v instanceof String[])) continue;
                this.setParam(k.toString(), (String[])v);
            }
        }
    }

    public String getCookie(String string) {
        return (String)this.cookies.get(string);
    }

    public void setCookie(String string, String string2) {
        this.cookies.put(string, string2);
    }

    public void setCookies(Map map) {
        this.cookies.putAll(map);
    }

    public void setHeaders(Map map) {
        this.headers.putAll(map);
    }

    public Vector getHeaders(String string) {
        return (Vector)this.headers.get(string.toLowerCase());
    }

    public String getHeader(String string) {
        String string2 = null;
        Vector vector = this.getHeaders(string);
        if (vector != null && !vector.isEmpty()) {
            string2 = (String)vector.get(0);
        }
        return string2;
    }

    protected void startHead(PrintWriter printWriter) {
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.print("<meta http-equiv=\"Content-Type\" content=\"text/html; ");
        printWriter.print(CHARSET);
        printWriter.println("\">");
    }

    protected void head(PrintWriter printWriter) throws Exception {
    }

    protected void endHead(PrintWriter printWriter) {
        printWriter.println("</head>");
    }

    protected void linkStyle(String string, String string2, PrintWriter printWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append("\" media=\"screen\">\n");
            stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            stringBuffer.append(string2).append("\" media=\"print\">");
        } else {
            stringBuffer.append("\">");
        }
        printWriter.println(stringBuffer.substring(0));
    }

    protected void linkScript(String string, PrintWriter printWriter) {
        printWriter.print("<script language=\"JavaScript\" src=\"");
        printWriter.print(string);
        printWriter.println("\" type=\"text/javascript\"></script>");
    }

    protected void writeScript(String string, PrintWriter printWriter) {
        printWriter.println("<script language=\"JavaScript\" type=\"text/javascript\">");
        printWriter.println("<!--");
        printWriter.println(string);
        printWriter.println("// -->");
        printWriter.println("</script>");
    }

    protected void title(String string, String string2, PrintWriter printWriter) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<title>");
        if (string != null) {
            stringBuffer.append(RequestProcessor.filter(string)).append(" - ");
        }
        stringBuffer.append(RequestProcessor.filter(string2));
        stringBuffer.append("</title>");
        printWriter.println(stringBuffer.substring(0));
    }

    protected void startBody(PrintWriter printWriter) {
        printWriter.println("<body>");
    }

    protected void body(PrintWriter printWriter) throws Exception {
    }

    protected void endBody(PrintWriter printWriter) {
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public static String filter(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                String string4 = null;
                switch (c) {
                    case '<': {
                        string4 = "&lt;";
                        break;
                    }
                    case '>': {
                        string4 = "&gt;";
                        break;
                    }
                    case '\"': {
                        string4 = "&quot;";
                        break;
                    }
                    case '&': {
                        string4 = "&amp;";
                    }
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                    continue;
                }
                stringBuffer.append(c);
            }
            string2 = stringBuffer.substring(0);
        }
        return string2;
    }

    public static String escape(String string) {
        String string2 = string;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                String string3 = null;
                switch (c) {
                    case '\'': {
                        string3 = "\\'";
                        break;
                    }
                    case '\\': {
                        string3 = "\\\\";
                    }
                }
                if (string3 != null) {
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(c);
            }
            string2 = stringBuffer.substring(0);
        }
        return string2;
    }

    public static String toNbsp(String string) {
        StringTokenizer stringTokenizer;
        StringBuffer stringBuffer = new StringBuffer(string == null ? 0 : string.length() * 2);
        if (string != null && (stringTokenizer = new StringTokenizer(string)).hasMoreTokens()) {
            while (true) {
                stringBuffer.append(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) break;
                stringBuffer.append("&nbsp;");
            }
        }
        return stringBuffer.substring(0);
    }

    public static void setDirectResources(boolean bl) {
        DIRECT_RESOURCES = bl;
    }

    protected static String resourceUrl(String string) {
        String string2 = string;
        if (!DIRECT_RESOURCES) {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("resource?id=").append(string);
            string2 = stringBuffer.substring(0);
        }
        return string2;
    }

    public static String httpDate(Date date) {
        if (HTTP_DF == null) {
            HTTP_DF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            HTTP_DF.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return HTTP_DF.format(date);
    }

    static {
        properties = new HashMap();
    }
}

