/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import edu.xtec.jclic.report.rp.GroupAdmin;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.util.Encryption;
import edu.xtec.util.StrUtils;
import java.io.PrintWriter;
import java.util.ResourceBundle;

public class UserAdmin
extends Basic {
    public static String TITLE = "user_admin_title";
    public static String URL = "userAdmin";
    public static final String GROUP = "group";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String USER = "user";
    public static final String PASS = "pass";
    public static final String PASSC = "passc";
    public static final int USER_MENU = 0;
    public static final int EDIT = 1;
    public static final int EDIT_UPDATE = 2;
    public static final int CREATE = 3;
    public static final int CREATE_UPDATE = 4;
    public static final int DELETE = 5;
    public static final int DELETE_UPDATE = 6;
    public static final int CLEAR = 7;
    public static final int CLEAR_UPDATE = 8;
    public static final int ERROR = 9;
    public static final String[] ACTIONS = new String[]{"", "edit", "editUpd", "create", "createUpd", "del", "delUpd", "clear", "clearUpd"};
    protected int page;
    protected DateManager dm;
    protected GroupData gd;
    protected UserData ud;
    protected String errMsg;
    protected boolean err = true;
    protected String returnUrl;

    public String getTitle(ResourceBundle resourceBundle) {
        return resourceBundle.getString(TITLE);
    }

    public String getUrl() {
        return UserAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int n) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(URL);
        UserAdmin.urlParamSb(stringBuffer, "lang", this.lang, true);
        UserAdmin.urlParamSb(stringBuffer, "action", ACTIONS[n], false);
        if (this.ud != null) {
            UserAdmin.urlParamSb(stringBuffer, USER, this.ud.getId(), false);
        } else if (this.gd != null) {
            UserAdmin.urlParamSb(stringBuffer, GROUP, this.gd.getId(), false);
        }
        return stringBuffer.substring(0);
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        String string = this.getParamNotNull(USER);
        if (string.length() > 0) {
            this.ud = bridge.getUserData(string);
        }
        String string2 = this.getParamNotNull(GROUP);
        if (this.ud != null) {
            string2 = this.ud.groupId;
        }
        if (string2.length() > 0) {
            this.gd = bridge.getGroupData(string2);
        }
        this.page = this.getAction(ACTIONS, 0);
        if (this.page == 7 || this.page == 8) {
            this.dm = new DateManager(this);
            if (!this.dm.init()) {
                return false;
            }
        }
        switch (this.page) {
            case 2: {
                this.edit();
                break;
            }
            case 4: {
                this.create();
                break;
            }
            case 6: {
                this.delete();
                break;
            }
            case 8: {
                this.clear();
            }
        }
        return true;
    }

    protected void edit() throws Exception {
        this.returnUrl = this.getUrl(0);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String string = this.getParamNotNull(NAME).trim();
        String string2 = StrUtils.nullableString(this.getParam(PASS));
        String string3 = StrUtils.nullableString(this.getParam(PASSC));
        if (string.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_name");
        } else if (!StrUtils.compareObjects(string2, string3)) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_err_bad_pw");
        } else {
            this.ud.setText(string);
            this.ud.pwd = string2 == null ? null : Encryption.Encrypt(string2);
            this.ud.setIconUrl(this.getParamNotNull(ICON).trim());
            try {
                bridge.updateUser(this.ud, false);
                this.page = 0;
            }
            catch (Exception exception) {
                this.errMsg = this.errMsg + exception.getLocalizedMessage();
            }
        }
    }

    protected String getGroupUrl() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(GroupAdmin.URL);
        UserAdmin.urlParamSb(stringBuffer, "lang", this.lang, true);
        UserAdmin.urlParamSb(stringBuffer, "action", GroupAdmin.ACTIONS[1], false);
        UserAdmin.urlParamSb(stringBuffer, GROUP, this.gd.getId(), false);
        return stringBuffer.substring(0);
    }

    protected void create() throws Exception {
        this.returnUrl = this.getGroupUrl();
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String string = this.getParamNotNull(NAME).trim();
        String string2 = this.getParamNotNull(ID).trim();
        String string3 = this.getParamNotNull(ICON).trim();
        String string4 = StrUtils.nullableString(this.getParam(PASS));
        String string5 = StrUtils.nullableString(this.getParam(PASSC));
        if (string.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_name");
        } else if (string2.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_id");
        } else if (!StrUtils.compareObjects(string4, string5)) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_err_bad_pw");
        } else {
            this.ud = bridge.getUserData(string2);
            if (this.ud != null) {
                this.returnUrl = UserAdmin.urlParam(UserAdmin.urlParam(this.getUrl(3), NAME, string), ICON, string3);
                this.errMsg = this.errMsg + this.getMsg("user_admin_id_already_exists");
            } else {
                try {
                    this.ud = new UserData(string2, string, string3, null, this.gd.getId());
                    this.ud.pwd = string4 == null ? null : Encryption.Encrypt(string4);
                    bridge.updateUser(this.ud, true);
                    this.page = 0;
                }
                catch (Exception exception) {
                    this.ud = null;
                    this.errMsg = this.errMsg + exception.getLocalizedMessage();
                }
            }
        }
    }

    protected void delete() throws Exception {
        this.returnUrl = this.getUrl(0);
        try {
            bridge.deleteUser(this.ud.getId());
            this.ud = null;
            this.errMsg = this.getMsg("user_admin_user_deleted");
            this.err = false;
            this.returnUrl = this.getGroupUrl();
        }
        catch (Exception exception) {
            this.returnUrl = this.getUrl(0);
            this.errMsg = this.getMsg("db_error") + "<BR>" + exception.getLocalizedMessage();
        }
    }

    protected void clear() throws Exception {
        this.returnUrl = this.getUrl(0);
        try {
            bridge.clearUserReportData(this.ud.getId(), this.dm.dFrom, this.dm.dTo);
            this.page = 0;
        }
        catch (Exception exception) {
            this.errMsg = this.getMsg("db_error") + "<BR>" + exception.getLocalizedMessage();
        }
    }

    public void head(PrintWriter printWriter) throws Exception {
        super.head(printWriter);
        if (this.page == 7) {
            StringBuffer stringBuffer = new StringBuffer(300);
            this.dm.writeDateScript(stringBuffer);
            printWriter.println(stringBuffer.substring(0));
        }
    }

    public void body(PrintWriter printWriter) throws Exception {
        super.body(printWriter);
        StringBuffer stringBuffer = new StringBuffer(3000);
        StringBuffer stringBuffer2 = new StringBuffer(500);
        boolean bl = false;
        stringBuffer.append(UserAdmin.linkTo(UserAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        stringBuffer.append(" | ");
        stringBuffer.append(UserAdmin.linkTo(UserAdmin.urlParam(GroupAdmin.URL, "lang", this.lang), this.bundle.getString(GroupAdmin.TITLE), null));
        if (this.gd != null) {
            stringBuffer.append(" | ");
            stringBuffer.append(UserAdmin.linkTo(this.getGroupUrl(), this.gd.getText(), null));
        }
        if (this.page != 0 && this.ud != null) {
            stringBuffer.append(" | ").append(UserAdmin.linkTo(this.getUrl(0), this.ud.getText(), null));
        }
        this.standardHeader(printWriter, UserAdmin.filter(this.getTitle(this.bundle)), stringBuffer.substring(0));
        stringBuffer.setLength(0);
        if (this.ud == null && this.page != 3 && this.page != 6) {
            this.page = 9;
            if (this.errMsg == null) {
                this.errMsg = this.getMsg("bad_data");
            }
            this.err = true;
        }
        switch (this.page) {
            case 0: {
                stringBuffer.append("<form class=\"info\">\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_id")).append("</strong> ").append(UserAdmin.filter(this.ud.getId())).append("</p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_name")).append("</strong> ").append(UserAdmin.filter(this.ud.getText())).append("</p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_pw_prompt")).append("</strong> ").append(this.ud.pwd == null ? "" : "***").append("</p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_icon")).append("</strong> ");
                if (this.ud.getIconUrl() != null && this.ud.getIconUrl().length() > 0) {
                    stringBuffer.append("<img src=\"").append(UserAdmin.filter(this.ud.getIconUrl())).append("\"");
                    stringBuffer.append(" title=\"").append(UserAdmin.filter(this.ud.getIconUrl())).append("\">");
                } else {
                    stringBuffer.append("---\n");
                }
                stringBuffer.append("</p>\n");
                stringBuffer.append("<p>");
                stringBuffer.append(UserAdmin.buttonTo(this.getUrl(1), this.getMsg("user_admin_edit_button"), null));
                stringBuffer.append(UserAdmin.buttonTo(this.getUrl(5), this.getMsg("user_admin_delete_button"), null));
                stringBuffer.append(UserAdmin.buttonTo(this.getUrl(7), this.getMsg("user_admin_clear_button"), null));
                stringBuffer.append("</p>\n");
                stringBuffer.append("</form>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                break;
            }
            case 1: {
                bl = true;
            }
            case 3: {
                String string = this.ud != null ? this.ud.getId() : this.getParamNotNull(ID).trim();
                String string2 = this.ud != null ? this.ud.getText() : this.getParamNotNull(NAME).trim();
                String string3 = this.ud != null ? this.ud.getIconUrl() : this.getParamNotNull(ICON).trim();
                String string4 = this.ud != null ? Encryption.Decrypt(this.ud.pwd) : this.getParam(PASS);
                stringBuffer.append("<form class=\"inputForm\" method=\"post\" action=\"").append(this.getUrl(bl ? 2 : 4)).append("\">\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_id")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(ID).append("\" value=\"").append(UserAdmin.filter(string)).append("\" size=40 ");
                if (bl) {
                    stringBuffer.append("readonly");
                }
                stringBuffer.append(">\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_name")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(NAME).append("\" value=\"").append(UserAdmin.filter(string2)).append("\" size=40></p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_pw_prompt")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(PASS).append("\" type=\"password\" value=\"").append(string4 == null ? "" : UserAdmin.filter(string4)).append("\" size=20><br>\n");
                stringBuffer.append("<strong>").append(this.getMsg("user_admin_pw_prompt_confirm")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(PASSC).append("\" type=\"password\" value=\"").append(string4 == null ? "" : UserAdmin.filter(string4)).append("\" size=20></p>\n");
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_icon")).append("</strong> ");
                stringBuffer.append("<input name=\"").append(ICON).append("\" value=\"").append(UserAdmin.filter(string3)).append("\" size=40></p>\n");
                stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"> ");
                stringBuffer.append(UserAdmin.buttonTo(bl ? this.getUrl(0) : this.getGroupUrl(), this.getMsg("cancel"), null)).append("</p>\n");
                stringBuffer.append("</form>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                break;
            }
            case 5: {
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_delete_user")).append(" \"").append(UserAdmin.filter(this.ud.getText())).append("\"</strong></p>\n");
                stringBuffer.append("<p>").append(this.getMsg("user_admin_delete_user_explain")).append("</p>\n");
                stringBuffer.append("<p>").append(this.getMsg("report_areyousure")).append("</p>\n");
                stringBuffer.append("<form method=\"post\" action=\"").append(this.getUrl(6)).append("\">\n");
                stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("YES")).append("\" width=50> ");
                stringBuffer.append(UserAdmin.buttonTo(this.getUrl(0), this.getMsg("NOT"), "width=50"));
                stringBuffer.append("</p>\n");
                stringBuffer.append("</form>\n");
                break;
            }
            case 7: {
                stringBuffer.append("<p><strong>").append(this.getMsg("user_admin_clear_user")).append(" \"").append(UserAdmin.filter(this.ud.getText())).append("\"</strong></p>\n");
                stringBuffer.append("<p>").append(this.getMsg("user_admin_clear_user_explain")).append("</p>\n");
                stringBuffer.append("<form class=\"inputForm\" action=\"").append(this.getUrl(8)).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
                this.dm.writeHiddenFields(stringBuffer);
                stringBuffer2.setLength(0);
                stringBuffer2.append("document.").append("mainForm").append(".submit()");
                this.dm.zonaData(stringBuffer, UserAdmin.buttonAction(stringBuffer2.substring(0), this.getMsg("db_clear_reports_date"), null));
                stringBuffer.append("</form>\n");
                stringBuffer.append("<br clear=\"all\">\n");
                break;
            }
            default: {
                stringBuffer.append("<p><strong>").append(this.getMsg(this.err ? "error" : "success")).append("</strong></p>\n");
                if (this.errMsg != null) {
                    stringBuffer.append("<p>").append(this.errMsg).append("</p>\n");
                }
                if (this.returnUrl == null) break;
                stringBuffer.append("<p><a href=\"").append(this.returnUrl).append("\">").append(this.getMsg("return")).append("</a></p>\n");
            }
        }
        printWriter.println(stringBuffer.substring(0));
    }
}

